/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.admin.indices.segments.PitSegmentsRequest;
import org.opensearch.action.search.CreatePitRequest;
import org.opensearch.action.search.DeletePitRequest;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.security.OpenSearchSecurityPlugin;
import org.opensearch.security.privileges.PrivilegesEvaluatorResponse;
import org.opensearch.security.resolver.IndexResolverReplacer;
import org.opensearch.security.securityconf.SecurityRoles;
import org.opensearch.security.user.User;

public class PitPrivilegesEvaluator {
    public PrivilegesEvaluatorResponse evaluate(ActionRequest request, ClusterService clusterService, User user, SecurityRoles securityRoles, String action, IndexNameExpressionResolver resolver, PrivilegesEvaluatorResponse presponse, IndexResolverReplacer irr) {
        if (!(request instanceof DeletePitRequest) && !(request instanceof PitSegmentsRequest)) {
            return presponse;
        }
        List<String> pitIds = new ArrayList();
        if (request instanceof DeletePitRequest) {
            DeletePitRequest deletePitRequest = (DeletePitRequest)request;
            pitIds = deletePitRequest.getPitIds();
        } else if (request instanceof PitSegmentsRequest) {
            PitSegmentsRequest pitSegmentsRequest = (PitSegmentsRequest)request;
            pitIds = pitSegmentsRequest.getPitIds();
        }
        if (pitIds.size() == 1 && "_all".equals(pitIds.get(0))) {
            return presponse;
        }
        return this.handlePitsAccess(pitIds, clusterService, user, securityRoles, action, resolver, presponse, irr);
    }

    private PrivilegesEvaluatorResponse handlePitsAccess(List<String> pitIds, ClusterService clusterService, User user, SecurityRoles securityRoles, String action, IndexNameExpressionResolver resolver, PrivilegesEvaluatorResponse presponse, IndexResolverReplacer irr) {
        Map pitToIndicesMap = OpenSearchSecurityPlugin.GuiceHolder.getPitService().getIndicesForPits(pitIds);
        HashSet<String> pitIndices = new HashSet<String>();
        for (String[] indices : pitToIndicesMap.values()) {
            pitIndices.addAll(Arrays.asList(indices));
        }
        Set<String> allPermittedIndices = this.getPermittedIndices(pitIndices, clusterService, user, securityRoles, action, resolver, irr);
        if (allPermittedIndices.containsAll(pitIndices)) {
            presponse.allowed = true;
            presponse.markComplete();
        }
        return presponse;
    }

    private Set<String> getPermittedIndices(Set<String> pitIndices, ClusterService clusterService, User user, SecurityRoles securityRoles, String action, IndexNameExpressionResolver resolver, IndexResolverReplacer irr) {
        String[] indicesArr = new String[pitIndices.size()];
        CreatePitRequest req = new CreatePitRequest(new TimeValue(1L, TimeUnit.DAYS), Boolean.valueOf(true), pitIndices.toArray(indicesArr));
        IndexResolverReplacer.Resolved pitResolved = irr.resolveRequest(req);
        return securityRoles.reduce(pitResolved, user, new String[]{action}, resolver, clusterService);
    }
}

