/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.util.onnx;

import ai.onnx.proto.OnnxMl;

final class ONNXShape {
    public final long UNKNOWN_DIMENSION = -1L;
    private final long[] dimensions;
    private final String[] dimensionOverrides;

    public ONNXShape(long[] dimensions) {
        for (int i = 0; i < dimensions.length; ++i) {
            if (dimensions[i] != -1L) continue;
            throw new IllegalArgumentException("Must specify a name for any unbound dimensions, at idx " + i + " found " + dimensions[i]);
        }
        this.dimensions = dimensions;
        this.dimensionOverrides = null;
    }

    public ONNXShape(long[] dimensions, String[] dimensionOverrides) {
        if (dimensions.length != dimensionOverrides.length) {
            throw new IllegalArgumentException("Must supply dimensions of equal length, found " + dimensions.length + ", and " + dimensionOverrides.length);
        }
        for (int i = 0; i < dimensions.length; ++i) {
            if ((dimensions[i] != -1L || dimensionOverrides[i] != null) && (dimensions[i] == -1L || dimensionOverrides[i] == null)) continue;
            throw new IllegalArgumentException("Only one of dimensions and dimensionOverrides must contain a value, at idx " + i + " found " + dimensions[i] + " and " + dimensionOverrides[i]);
        }
        this.dimensions = dimensions;
        this.dimensionOverrides = dimensionOverrides;
    }

    public OnnxMl.TensorShapeProto getProto() {
        OnnxMl.TensorShapeProto.Builder builder = OnnxMl.TensorShapeProto.newBuilder();
        for (int i = 0; i < this.dimensions.length; ++i) {
            if (this.dimensions[i] == -1L) {
                builder.addDim(OnnxMl.TensorShapeProto.Dimension.newBuilder().setDimParam(this.dimensionOverrides[i]).build());
                continue;
            }
            builder.addDim(OnnxMl.TensorShapeProto.Dimension.newBuilder().setDimValue(this.dimensions[i]).build());
        }
        return builder.build();
    }
}

