/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Function1;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Internal;
import org.jooq.impl.Names;
import org.jooq.impl.QOM;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.StringUtils;

final class Square<T extends Number>
extends AbstractField<T>
implements QOM.Square<T> {
    final Field<T> value;

    Square(Field<T> value) {
        super(Names.N_SQUARE, Tools.allNotNull(Tools.dataType(SQLDataType.INTEGER, value, false), value));
        this.value = Tools.nullSafeNotNull(value, SQLDataType.INTEGER);
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case SQLITE: {
                ctx.visit(Internal.imul(this.value, this.value));
                break;
            }
            case CUBRID: 
            case DERBY: 
            case FIREBIRD: 
            case H2: 
            case HSQLDB: 
            case IGNITE: 
            case MARIADB: 
            case MYSQL: 
            case POSTGRES: 
            case YUGABYTEDB: {
                if (Tools.isSimple(ctx, this.value)) {
                    ctx.visit(Internal.imul(this.value, this.value));
                    break;
                }
                ctx.visit(DSL.power(this.value, DSL.inline(2)));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_SQUARE, this.getDataType(), this.value));
            }
        }
    }

    @Override
    public final Field<T> $value() {
        return this.value;
    }

    @Override
    public final QOM.Square<T> $value(Field<T> newValue) {
        return this.constructor().apply(newValue);
    }

    public final Function1<? super Field<T>, ? extends QOM.Square<T>> constructor() {
        return a1 -> new Square(a1);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.Square) {
            QOM.Square o = (QOM.Square)that;
            return StringUtils.equals(this.$value(), o.$value());
        }
        return super.equals(that);
    }
}

