/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Function1;
import org.jooq.Name;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.Row;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectSelectStep;
import org.jooq.Table;
import org.jooq.TableOptions;
import org.jooq.impl.AbstractTable;
import org.jooq.impl.DSL;
import org.jooq.impl.FieldsImpl;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;
import org.jooq.impl.QOM;
import org.jooq.impl.QueryPartListView;
import org.jooq.impl.RecordImplN;
import org.jooq.impl.TableAlias;
import org.jooq.impl.Tools;
import org.jooq.impl.Val;

final class Values<R extends Record>
extends AbstractTable<R>
implements QOM.Values<R> {
    static final Set<SQLDialect> NO_SUPPORT_VALUES = SQLDialect.supportedUntil(SQLDialect.FIREBIRD, SQLDialect.MARIADB);
    static final Set<SQLDialect> REQUIRE_ROWTYPE_CAST = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD);
    static final Set<SQLDialect> REQUIRE_ROWTYPE_CAST_FIRST_ROW = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    static final Set<SQLDialect> NO_SUPPORT_PARENTHESES = SQLDialect.supportedBy(new SQLDialect[0]);
    private final QueryPartListView<Row> rows;
    private transient DataType<?>[] types;

    Values(Row[] rows) {
        super(TableOptions.expression(), Names.N_VALUES);
        this.rows = Values.assertNotEmpty(rows);
    }

    static final QueryPartListView<Row> assertNotEmpty(Row[] rows) {
        if (rows == null || rows.length == 0) {
            throw new IllegalArgumentException("Cannot create a VALUES() constructor with an empty set of rows");
        }
        return QueryPartListView.wrap((QueryPart[])rows);
    }

    private final DataType<?>[] rowType() {
        if (this.types == null) {
            this.types = new DataType[((Row)this.rows.get(0)).size()];
            block0: for (int i = 0; i < this.types.length; ++i) {
                this.types[i] = ((Row)this.rows.get(0)).dataType(i);
                if (this.types[i].getType() != Object.class) continue;
                for (int j = 1; j < this.rows.size(); ++j) {
                    DataType<?> type = ((Row)this.rows.get(j)).dataType(i);
                    if (type.getType() == Object.class) continue;
                    this.types[i] = type;
                    continue block0;
                }
            }
        }
        return this.types;
    }

    private final Field<?>[] castToRowType(Field<?>[] fields) {
        Field[] result = new Field[fields.length];
        for (int i = 0; i < result.length; ++i) {
            DataType<?> type = this.rowType()[i];
            result[i] = fields[i].getDataType().equals(type) ? fields[i] : fields[i].cast(type);
        }
        return result;
    }

    @Override
    public final Class<? extends R> getRecordType() {
        return RecordImplN.class;
    }

    @Override
    public final Table<R> as(Name alias) {
        return new TableAlias(this, alias, c -> !NO_SUPPORT_PARENTHESES.contains((Object)c.dialect()));
    }

    @Override
    public final Table<R> as(Name alias, Name ... fieldAliases) {
        return new TableAlias(this, alias, fieldAliases, c -> !NO_SUPPORT_PARENTHESES.contains((Object)c.dialect()));
    }

    private final Row castNullLiteralToRowType(Context<?> ctx, Row row) {
        if (Tools.anyMatch(row.fields(), f -> this.nullLiteralOrUntypedNullBind(ctx, (Field<?>)f))) {
            Field[] result = new Field[row.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.nullLiteralOrUntypedNullBind(ctx, row.field(i)) && this.rowType()[i].getType() != Object.class ? row.field(i).cast(this.rowType()[i]) : row.field(i);
            }
            return DSL.row(result);
        }
        return row;
    }

    private final boolean nullLiteralOrUntypedNullBind(Context<?> ctx, Field<?> field) {
        return Tools.isVal(field) && ((Val)field).getValue() == null && (((Val)field).isInline(ctx) || field.getType() == Object.class);
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (NO_SUPPORT_VALUES.contains((Object)ctx.dialect())) {
            Select<Record> selects = null;
            boolean cast = REQUIRE_ROWTYPE_CAST.contains((Object)ctx.dialect());
            for (Row row : this.rows) {
                SelectSelectStep<Record> select = DSL.select(cast ? this.castToRowType(row.fields()) : row.fields());
                if (selects == null) {
                    selects = select;
                    continue;
                }
                selects = selects.unionAll(select);
            }
            Tools.visitSubquery(ctx, selects, false);
        } else {
            ctx.start(Clause.TABLE_VALUES);
            ctx.visit(Keywords.K_VALUES);
            if (this.rows.size() > 1) {
                ctx.formatIndentStart().formatSeparator();
            } else {
                ctx.sql(' ');
            }
            for (int i = 0; i < this.rows.size(); ++i) {
                if (i > 0) {
                    ctx.sql(',').formatSeparator();
                }
                if (ctx.family() == SQLDialect.MYSQL) {
                    ctx.visit(Keywords.K_ROW).sql(" ");
                }
                if (i == 0 && REQUIRE_ROWTYPE_CAST_FIRST_ROW.contains((Object)ctx.dialect())) {
                    ctx.visit(this.castNullLiteralToRowType(ctx, (Row)this.rows.get(i)));
                    continue;
                }
                if (REQUIRE_ROWTYPE_CAST.contains((Object)ctx.dialect())) {
                    ctx.visit(this.castNullLiteralToRowType(ctx, (Row)this.rows.get(i)));
                    continue;
                }
                ctx.visit((QueryPart)this.rows.get(i));
            }
            if (this.rows.size() > 1) {
                ctx.formatIndentEnd().formatNewLine();
            }
            ctx.end(Clause.TABLE_VALUES);
        }
    }

    @Override
    final FieldsImpl<R> fields0() {
        return new FieldsImpl(((Row)this.rows.get(0)).fields());
    }

    @Override
    public final Function1<? super QOM.UnmodifiableList<? extends Row>, ? extends Table<R>> constructor() {
        return r -> new Values(r.toArray(Tools.EMPTY_ROW));
    }

    @Override
    public final QOM.UnmodifiableList<? extends Row> $arg1() {
        return QOM.unmodifiable(this.rows);
    }
}

