/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.services.simpleemail.model.RawMessage;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class RawMessageStaxUnmarshaller
implements Unmarshaller<RawMessage, StaxUnmarshallerContext> {
    private static RawMessageStaxUnmarshaller instance;

    public RawMessage unmarshall(StaxUnmarshallerContext context) throws Exception {
        RawMessage rawMessage = new RawMessage();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return rawMessage;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("Data", targetDepth)) continue;
                rawMessage.setData(SimpleTypeStaxUnmarshallers.ByteBufferStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return rawMessage;
    }

    public static RawMessageStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new RawMessageStaxUnmarshaller();
        }
        return instance;
    }
}

