/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.decisionmaker.actions;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.opensearch.performanceanalyzer.AppContext;
import org.opensearch.performanceanalyzer.decisionmaker.actions.ImpactVector;
import org.opensearch.performanceanalyzer.decisionmaker.actions.SuppressibleAction;
import org.opensearch.performanceanalyzer.grpc.ResourceEnum;
import org.opensearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;

public class JvmGenAction
extends SuppressibleAction {
    private static final JsonParser jsonParser = new JsonParser();
    private static final ImpactVector NO_IMPACT = new ImpactVector();
    private static final String RESOURCE_KEY = "resource";
    private static final String TARGET_RATIO_KEY = "targetRatio";
    private static final String COOLOFF_KEY = "coolOffPeriodInMillis";
    private static final String CAN_UPDATE_KEY = "canUpdate";
    public static final String NAME = "JvmGenAction";
    private final int targetRatio;
    private final long coolOffPeriodInMillis;
    private final boolean canUpdate;

    public JvmGenAction(AppContext appContext, int targetRatio, long coolOffPeriodInMillis, boolean canUpdate) {
        super(appContext);
        this.targetRatio = targetRatio;
        this.coolOffPeriodInMillis = coolOffPeriodInMillis;
        this.canUpdate = canUpdate;
    }

    public int getTargetRatio() {
        return this.targetRatio;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public boolean canUpdate() {
        return this.canUpdate;
    }

    @Override
    public long coolOffPeriodInMillis() {
        return this.coolOffPeriodInMillis;
    }

    @Override
    public List<NodeKey> impactedNodes() {
        return this.appContext.getDataNodeInstances().stream().map(NodeKey::new).collect(Collectors.toList());
    }

    @Override
    public Map<NodeKey, ImpactVector> impact() {
        HashMap<NodeKey, ImpactVector> impact = new HashMap<NodeKey, ImpactVector>();
        for (NodeKey key : this.impactedNodes()) {
            impact.put(key, NO_IMPACT);
        }
        return impact;
    }

    @Override
    public String summary() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(RESOURCE_KEY, (Number)ResourceEnum.YOUNG_GEN.getNumber());
        jsonObject.addProperty(TARGET_RATIO_KEY, (Number)this.targetRatio);
        jsonObject.addProperty(COOLOFF_KEY, (Number)this.coolOffPeriodInMillis);
        jsonObject.addProperty(CAN_UPDATE_KEY, Boolean.valueOf(this.canUpdate));
        return jsonObject.toString();
    }

    public static JvmGenAction fromSummary(@Nonnull String summary, @Nonnull AppContext appContext) {
        JsonObject jsonObject = jsonParser.parse(summary).getAsJsonObject();
        int targetRatio = jsonObject.get(TARGET_RATIO_KEY).getAsInt();
        long coolOff = jsonObject.get(COOLOFF_KEY).getAsLong();
        boolean canUpdate = jsonObject.get(CAN_UPDATE_KEY).getAsBoolean();
        return new JvmGenAction(appContext, targetRatio, coolOff, canUpdate);
    }

    public String toString() {
        return this.summary();
    }
}

