/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.math.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import org.tribuo.math.util.VectorNormalizer;
import org.tribuo.util.onnx.ONNXNode;
import org.tribuo.util.onnx.ONNXOperators;

public class ExpNormalizer
implements VectorNormalizer,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public double[] normalize(double[] input) {
        double[] output = Arrays.copyOf(input, input.length);
        this.normalizeInPlace(output);
        return output;
    }

    @Override
    public void normalizeInPlace(double[] input) {
        int i;
        double max = -1.7976931348623157E308;
        for (int i2 = 0; i2 < input.length; ++i2) {
            if (!(max < input[i2])) continue;
            max = input[i2];
        }
        double sum = 0.0;
        for (i = 0; i < input.length; ++i) {
            input[i] = Math.exp(input[i] - max);
            sum += input[i];
        }
        i = 0;
        while (i < input.length) {
            int n = i++;
            input[n] = input[n] / sum;
        }
    }

    @Override
    public ONNXNode exportNormalizer(ONNXNode input) {
        return input.apply(ONNXOperators.SOFTMAX, Collections.singletonMap("axis", 1));
    }
}

