/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.suggest.completion.context;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.opensearch.OpenSearchParseException;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.mapper.KeywordFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.search.suggest.completion.context.CategoryQueryContext;
import org.opensearch.search.suggest.completion.context.ContextBuilder;
import org.opensearch.search.suggest.completion.context.ContextMapping;

public class CategoryContextMapping
extends ContextMapping<CategoryQueryContext> {
    private static final String FIELD_FIELDNAME = "path";
    static final String CONTEXT_VALUE = "context";
    static final String CONTEXT_BOOST = "boost";
    static final String CONTEXT_PREFIX = "prefix";
    private final String fieldName;

    private CategoryContextMapping(String name, String fieldName) {
        super(ContextMapping.Type.CATEGORY, name);
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    protected static CategoryContextMapping load(String name, Map<String, Object> config) throws OpenSearchParseException {
        Builder mapping = new Builder(name);
        Object fieldName = config.get(FIELD_FIELDNAME);
        if (fieldName != null) {
            mapping.field(fieldName.toString());
            config.remove(FIELD_FIELDNAME);
        }
        return mapping.build();
    }

    @Override
    protected XContentBuilder toInnerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.fieldName != null) {
            builder.field(FIELD_FIELDNAME, this.fieldName);
        }
        return builder;
    }

    @Override
    public Set<String> parseContext(ParseContext parseContext, XContentParser parser) throws IOException, OpenSearchParseException {
        HashSet<String> contexts = new HashSet<String>();
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_STRING || token == XContentParser.Token.VALUE_NUMBER || token == XContentParser.Token.VALUE_BOOLEAN) {
            contexts.add(parser.text());
        } else if (token == XContentParser.Token.START_ARRAY) {
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                if (token == XContentParser.Token.VALUE_STRING || token == XContentParser.Token.VALUE_NUMBER || token == XContentParser.Token.VALUE_BOOLEAN) {
                    contexts.add(parser.text());
                    continue;
                }
                throw new OpenSearchParseException("context array must have string, number or boolean values, but was [" + String.valueOf(token) + "]", new Object[0]);
            }
        } else {
            throw new OpenSearchParseException("contexts must be a string, number or boolean or a list of string, number or boolean, but was [" + String.valueOf(token) + "]", new Object[0]);
        }
        return contexts;
    }

    @Override
    public Set<String> parseContext(ParseContext.Document document) {
        HashSet<String> values = null;
        if (this.fieldName != null) {
            IndexableField[] fields = document.getFields(this.fieldName);
            values = new HashSet<String>(fields.length);
            for (IndexableField field : fields) {
                if (field instanceof SortedDocValuesField || field instanceof SortedSetDocValuesField || field instanceof StoredField) continue;
                if (field instanceof KeywordFieldMapper.KeywordField) {
                    values.add(field.binaryValue().utf8ToString());
                    continue;
                }
                if (field.stringValue() != null) {
                    values.add(field.stringValue());
                    continue;
                }
                throw new IllegalArgumentException("Failed to parse context field [" + this.fieldName + "], only keyword and text fields are accepted");
            }
        }
        return values == null ? Collections.emptySet() : values;
    }

    @Override
    protected CategoryQueryContext fromXContent(XContentParser parser) throws IOException {
        return CategoryQueryContext.fromXContent(parser);
    }

    @Override
    public List<ContextMapping.InternalQueryContext> toInternalQueryContexts(List<CategoryQueryContext> queryContexts) {
        ArrayList<ContextMapping.InternalQueryContext> internalInternalQueryContexts = new ArrayList<ContextMapping.InternalQueryContext>(queryContexts.size());
        internalInternalQueryContexts.addAll(queryContexts.stream().map(queryContext -> new ContextMapping.InternalQueryContext(queryContext.getCategory(), queryContext.getBoost(), queryContext.isPrefix())).collect(Collectors.toList()));
        return internalInternalQueryContexts;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CategoryContextMapping mapping = (CategoryContextMapping)o;
        return !(this.fieldName == null ? mapping.fieldName != null : !this.fieldName.equals(mapping.fieldName));
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fieldName);
    }

    public static class Builder
    extends ContextBuilder<CategoryContextMapping> {
        private String fieldName;

        public Builder(String name) {
            super(name);
        }

        public Builder field(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        @Override
        public CategoryContextMapping build() {
            return new CategoryContextMapping(this.name, this.fieldName);
        }
    }
}

