/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.iocscan.service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.commons.alerting.model.Trigger;
import org.opensearch.securityanalytics.model.threatintel.IocFinding;
import org.opensearch.securityanalytics.model.threatintel.ThreatIntelAlert;
import org.opensearch.securityanalytics.threatIntel.model.monitor.ThreatIntelTrigger;

public class ThreatIntelAlertContext {
    public static final String MONITOR_FIELD = "monitor";
    public static final String NEW_ALERTS_FIELD = "new_alerts";
    public static final String EXISTING_ALERTS_FIELD = "existing_alerts";
    private final List<String> dataSources;
    private final List<String> iocTypes;
    private final String triggerName;
    private final String triggerId;
    private final List<ThreatIntelAlert> newAlerts;
    private final List<ThreatIntelAlert> existingAlerts;
    private final String severity;
    private final List<IocFinding> findingIds;
    private final Monitor monitor;

    public ThreatIntelAlertContext(ThreatIntelTrigger threatIntelTrigger, Trigger trigger, List<IocFinding> findingIds, Monitor monitor, List<ThreatIntelAlert> newAlerts, List<ThreatIntelAlert> existingAlerts) {
        this.dataSources = threatIntelTrigger.getDataSources();
        this.iocTypes = threatIntelTrigger.getIocTypes();
        this.triggerName = trigger.getName();
        this.triggerId = trigger.getId();
        this.newAlerts = newAlerts;
        this.existingAlerts = existingAlerts;
        this.severity = this.triggerId;
        this.findingIds = findingIds;
        this.monitor = monitor;
    }

    public Map<String, Object> asTemplateArg() {
        return Map.of("data_sources", this.dataSources, "ioc_types", this.iocTypes, "name", this.triggerName, "id", this.triggerId, "severity", this.severity, "finding_ids", this.findingIds.stream().map(IocFinding::asTemplateArg).collect(Collectors.toList()), MONITOR_FIELD, this.monitor.asTemplateArg(), NEW_ALERTS_FIELD, this.newAlerts.stream().map(ThreatIntelAlert::asTemplateArg).collect(Collectors.toList()), EXISTING_ALERTS_FIELD, this.existingAlerts.stream().map(ThreatIntelAlert::asTemplateArg).collect(Collectors.toList()));
    }
}

