/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.resthandler;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.securityanalytics.threatIntel.action.SAIndexTIFSourceConfigAction;
import org.opensearch.securityanalytics.threatIntel.action.SAIndexTIFSourceConfigRequest;
import org.opensearch.securityanalytics.threatIntel.action.SAIndexTIFSourceConfigResponse;
import org.opensearch.securityanalytics.threatIntel.model.SATIFSourceConfigDto;

public class RestIndexTIFSourceConfigAction
extends BaseRestHandler {
    private static final Logger log = LogManager.getLogger(RestIndexTIFSourceConfigAction.class);

    public String getName() {
        return "index_tif_config_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_plugins/_security_analytics/threat_intel/sources"), new RestHandler.Route(RestRequest.Method.PUT, String.format(Locale.getDefault(), "%s/{%s}", "/_plugins/_security_analytics/threat_intel/sources", "threat_intel_source_config_id")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        log.debug(String.format(Locale.getDefault(), "%s %s", request.method(), "/_plugins/_security_analytics/threat_intel/sources"));
        String id = request.param("threat_intel_source_config_id", null);
        XContentParser xcp = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        SATIFSourceConfigDto tifConfig = SATIFSourceConfigDto.parse(xcp, id, null);
        SAIndexTIFSourceConfigRequest indexTIFConfigRequest = new SAIndexTIFSourceConfigRequest(id, request.method(), tifConfig);
        return channel -> client.execute((ActionType)SAIndexTIFSourceConfigAction.INSTANCE, (ActionRequest)indexTIFConfigRequest, this.indexTIFConfigResponse((RestChannel)channel, request.method()));
    }

    private RestResponseListener<SAIndexTIFSourceConfigResponse> indexTIFConfigResponse(RestChannel channel, final RestRequest.Method restMethod) {
        return new RestResponseListener<SAIndexTIFSourceConfigResponse>(channel){

            public RestResponse buildResponse(SAIndexTIFSourceConfigResponse response) throws Exception {
                RestStatus returnStatus = RestStatus.CREATED;
                if (restMethod == RestRequest.Method.PUT) {
                    returnStatus = RestStatus.OK;
                }
                BytesRestResponse restResponse = new BytesRestResponse(returnStatus, response.toXContent(this.channel.newBuilder(), ToXContent.EMPTY_PARAMS));
                if (restMethod == RestRequest.Method.POST) {
                    String location = String.format(Locale.getDefault(), "%s/%s", "/_plugins/_security_analytics/threat_intel/sources", response.getTIFConfigId());
                    restResponse.addHeader("Location", location);
                }
                return restResponse;
            }
        };
    }
}

