/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.transform;

import javax.xml.stream.events.XMLEvent;
import org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.ReceiptAction;
import org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.transform.AddHeaderActionStaxUnmarshaller;
import org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.transform.BounceActionStaxUnmarshaller;
import org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.transform.LambdaActionStaxUnmarshaller;
import org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.transform.S3ActionStaxUnmarshaller;
import org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.transform.SNSActionStaxUnmarshaller;
import org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.transform.StopActionStaxUnmarshaller;
import org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.transform.WorkmailActionStaxUnmarshaller;
import org.opensearch.notifications.core.repackage.com.amazonaws.transform.StaxUnmarshallerContext;
import org.opensearch.notifications.core.repackage.com.amazonaws.transform.Unmarshaller;

public class ReceiptActionStaxUnmarshaller
implements Unmarshaller<ReceiptAction, StaxUnmarshallerContext> {
    private static ReceiptActionStaxUnmarshaller instance;

    @Override
    public ReceiptAction unmarshall(StaxUnmarshallerContext context) throws Exception {
        ReceiptAction receiptAction = new ReceiptAction();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return receiptAction;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("S3Action", targetDepth)) {
                    receiptAction.setS3Action(S3ActionStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("BounceAction", targetDepth)) {
                    receiptAction.setBounceAction(BounceActionStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("WorkmailAction", targetDepth)) {
                    receiptAction.setWorkmailAction(WorkmailActionStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LambdaAction", targetDepth)) {
                    receiptAction.setLambdaAction(LambdaActionStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StopAction", targetDepth)) {
                    receiptAction.setStopAction(StopActionStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AddHeaderAction", targetDepth)) {
                    receiptAction.setAddHeaderAction(AddHeaderActionStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("SNSAction", targetDepth)) continue;
                receiptAction.setSNSAction(SNSActionStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return receiptAction;
    }

    public static ReceiptActionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ReceiptActionStaxUnmarshaller();
        }
        return instance;
    }
}

