/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.training.tracker;

import ai.djl.training.tracker.Tracker;

public class PolynomialDecayTracker
implements Tracker {
    private float baseValue;
    private float endLearningRate;
    private int decaySteps;
    private float power;

    public PolynomialDecayTracker(Builder builder) {
        if (Float.isNaN(builder.endLearningRate)) {
            throw new IllegalArgumentException("End learning rate is not set.");
        }
        if (builder.decaySteps <= 0) {
            throw new IllegalArgumentException("Decay steps is not set.");
        }
        this.baseValue = builder.baseValue;
        this.endLearningRate = builder.endLearningRate;
        this.decaySteps = builder.decaySteps;
        this.power = builder.power;
    }

    @Override
    public float getNewValue(int numUpdate) {
        int step = Math.max(0, Math.min(numUpdate, this.decaySteps));
        return (float)((double)(this.baseValue - this.endLearningRate) * Math.pow(1.0 - (double)step / (double)this.decaySteps, this.power) + (double)this.endLearningRate);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private float baseValue;
        private float endLearningRate = Float.NaN;
        private int decaySteps = -1;
        private float power = 1.0f;

        private Builder() {
        }

        public Builder setBaseValue(float baseValue) {
            this.baseValue = baseValue;
            return this;
        }

        public Builder setEndLearningRate(float endLearningRate) {
            this.endLearningRate = endLearningRate;
            return this;
        }

        public Builder setDecaySteps(int decaySteps) {
            this.decaySteps = decaySteps;
            return this;
        }

        public Builder optPower(float power) {
            this.power = power;
            return this;
        }

        public PolynomialDecayTracker build() {
            return new PolynomialDecayTracker(this);
        }
    }
}

