/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.agent.tools;

import java.io.IOException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.client.Client;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.ml.common.spi.tools.Tool;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;

public abstract class AbstractRetrieverTool
implements Tool {
    @Generated
    private static final Logger log = LogManager.getLogger(AbstractRetrieverTool.class);
    public static final String DEFAULT_DESCRIPTION = "Use this tool to search data in OpenSearch index.";
    public static final String INPUT_FIELD = "input";
    public static final String INDEX_FIELD = "index";
    public static final String SOURCE_FIELD = "source_field";
    public static final String DOC_SIZE_FIELD = "doc_size";
    public static final int DEFAULT_DOC_SIZE = 2;
    protected String description = "Use this tool to search data in OpenSearch index.";
    protected Client client;
    protected NamedXContentRegistry xContentRegistry;
    protected String index;
    protected String[] sourceFields;
    protected Integer docSize;
    protected String version;

    protected AbstractRetrieverTool(Client client, NamedXContentRegistry xContentRegistry, String index, String[] sourceFields, Integer docSize) {
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.index = index;
        this.sourceFields = sourceFields;
        this.docSize = docSize == null ? 2 : docSize;
    }

    protected abstract String getQueryBody(String var1);

    private static Map<String, Object> processResponse(SearchHit hit) {
        HashMap<String, Object> docContent = new HashMap<String, Object>();
        docContent.put("_index", hit.getIndex());
        docContent.put("_id", hit.getId());
        docContent.put("_score", Float.valueOf(hit.getScore()));
        docContent.put("_source", hit.getSourceAsMap());
        return docContent;
    }

    private <T> SearchRequest buildSearchRequest(Map<String, String> parameters) throws IOException {
        String question = parameters.get(INPUT_FIELD);
        if (StringUtils.isBlank((CharSequence)question)) {
            throw new IllegalArgumentException("[input] is null or empty, can not process it.");
        }
        String query = this.getQueryBody(question);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        XContentParser queryParser = XContentType.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, query);
        searchSourceBuilder.parseXContent(queryParser);
        searchSourceBuilder.fetchSource(this.sourceFields, null);
        searchSourceBuilder.size(this.docSize.intValue());
        SearchRequest searchRequest = new SearchRequest().source(searchSourceBuilder).indices(new String[]{this.index});
        return searchRequest;
    }

    public <T> void run(Map<String, String> parameters, ActionListener<T> listener) {
        SearchRequest searchRequest;
        try {
            searchRequest = this.buildSearchRequest(parameters);
        }
        catch (Exception e2) {
            log.error("Failed to build search request.", (Throwable)e2);
            listener.onFailure(e2);
            return;
        }
        ActionListener actionListener = ActionListener.wrap(r -> {
            SearchHit[] hits = r.getHits().getHits();
            if (hits != null && hits.length > 0) {
                StringBuilder contextBuilder = new StringBuilder();
                for (SearchHit hit : hits) {
                    Map<String, Object> docContent = AbstractRetrieverTool.processResponse(hit);
                    String docContentInString = AccessController.doPrivileged(() -> org.opensearch.ml.common.utils.StringUtils.gson.toJson((Object)docContent));
                    contextBuilder.append(docContentInString).append("\n");
                }
                listener.onResponse((Object)contextBuilder.toString());
            } else {
                listener.onResponse((Object)"Can not get any match from search result.");
            }
        }, e -> {
            log.error("Failed to search index.", (Throwable)e);
            listener.onFailure(e);
        });
        this.client.search(searchRequest, actionListener);
    }

    public boolean validate(Map<String, String> parameters) {
        return parameters != null && parameters.size() > 0 && !StringUtils.isBlank((CharSequence)parameters.get(INPUT_FIELD));
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Client getClient() {
        return this.client;
    }

    @Generated
    public NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @Generated
    public String getIndex() {
        return this.index;
    }

    @Generated
    public String[] getSourceFields() {
        return this.sourceFields;
    }

    @Generated
    public Integer getDocSize() {
        return this.docSize;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setClient(Client client) {
        this.client = client;
    }

    @Generated
    public void setXContentRegistry(NamedXContentRegistry xContentRegistry) {
        this.xContentRegistry = xContentRegistry;
    }

    @Generated
    public void setIndex(String index) {
        this.index = index;
    }

    @Generated
    public void setSourceFields(String[] sourceFields) {
        this.sourceFields = sourceFields;
    }

    @Generated
    public void setDocSize(Integer docSize) {
        this.docSize = docSize;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    protected static abstract class Factory<T extends Tool>
    implements Tool.Factory<T> {
        protected Client client;
        protected NamedXContentRegistry xContentRegistry;

        protected Factory() {
        }

        public void init(Client client, NamedXContentRegistry xContentRegistry) {
            this.client = client;
            this.xContentRegistry = xContentRegistry;
        }

        public String getDefaultDescription() {
            return AbstractRetrieverTool.DEFAULT_DESCRIPTION;
        }
    }
}

