/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.core.service.categorizer;

import java.util.Map;
import org.apache.lucene.search.BooleanClause;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilderVisitor;
import org.opensearch.plugin.insights.core.service.categorizer.SearchQueryCounters;
import org.opensearch.plugin.insights.rules.model.MetricType;

final class SearchQueryCategorizingVisitor
implements QueryBuilderVisitor {
    private final int level;
    private final SearchQueryCounters searchQueryCounters;
    private final Map<MetricType, Number> measurements;

    public SearchQueryCategorizingVisitor(SearchQueryCounters searchQueryCounters, Map<MetricType, Number> measurements) {
        this(searchQueryCounters, 0, measurements);
    }

    private SearchQueryCategorizingVisitor(SearchQueryCounters counters, int level, Map<MetricType, Number> measurements) {
        this.searchQueryCounters = counters;
        this.level = level;
        this.measurements = measurements;
    }

    public void accept(QueryBuilder qb) {
        this.searchQueryCounters.incrementCounter(qb, this.level, this.measurements);
    }

    public QueryBuilderVisitor getChildVisitor(BooleanClause.Occur occur) {
        return new SearchQueryCategorizingVisitor(this.searchQueryCounters, this.level + 1, this.measurements);
    }
}

