/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.core.service.categorizer;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.plugin.insights.rules.model.MetricType;
import org.opensearch.telemetry.metrics.Counter;
import org.opensearch.telemetry.metrics.Histogram;
import org.opensearch.telemetry.metrics.MetricsRegistry;
import org.opensearch.telemetry.metrics.tags.Tags;

public final class SearchQueryCounters {
    private static final String LEVEL_TAG = "level";
    private static final String TYPE_TAG = "type";
    private static final String UNIT = "1";
    private final MetricsRegistry metricsRegistry;
    private final Counter aggCounter;
    private final Counter otherQueryCounter;
    private final Counter sortCounter;
    private final Histogram queryTypeLatencyHistogram;
    private final Histogram queryTypeCpuHistogram;
    private final Histogram queryTypeMemoryHistogram;
    private final Map<Class<? extends QueryBuilder>, Counter> queryHandlers;
    private final ConcurrentHashMap<String, Counter> nameToQueryTypeCounters;

    public SearchQueryCounters(MetricsRegistry metricsRegistry) {
        this.metricsRegistry = metricsRegistry;
        this.nameToQueryTypeCounters = new ConcurrentHashMap();
        this.aggCounter = metricsRegistry.createCounter("search.query.type.agg.count", "Counter for the number of top level agg search queries", UNIT);
        this.otherQueryCounter = metricsRegistry.createCounter("search.query.type.other.count", "Counter for the number of top level and nested search queries that do not match any other categories", UNIT);
        this.sortCounter = metricsRegistry.createCounter("search.query.type.sort.count", "Counter for the number of top level sort search queries", UNIT);
        this.queryTypeLatencyHistogram = metricsRegistry.createHistogram("search.query.type.latency.histogram", "Histogram for the latency per query type", UNIT);
        this.queryTypeCpuHistogram = metricsRegistry.createHistogram("search.query.type.cpu.histogram", "Histogram for the cpu per query type", UNIT);
        this.queryTypeMemoryHistogram = metricsRegistry.createHistogram("search.query.type.memory.histogram", "Histogram for the memory per query type", UNIT);
        this.queryHandlers = new HashMap<Class<? extends QueryBuilder>, Counter>();
    }

    public void incrementCounter(QueryBuilder queryBuilder, int level, Map<MetricType, Number> measurements) {
        String uniqueQueryCounterName = queryBuilder.getName();
        Counter counter = this.nameToQueryTypeCounters.computeIfAbsent(uniqueQueryCounterName, k -> this.createQueryCounter((String)k));
        counter.add(1.0, Tags.create().addTag(LEVEL_TAG, (long)level));
        this.incrementAllHistograms(Tags.create().addTag(LEVEL_TAG, (long)level).addTag(TYPE_TAG, uniqueQueryCounterName), measurements);
    }

    public void incrementAggCounter(double value, Tags tags, Map<MetricType, Number> measurements) {
        this.aggCounter.add(value, tags);
        this.incrementAllHistograms(tags, measurements);
    }

    public void incrementSortCounter(double value, Tags tags, Map<MetricType, Number> measurements) {
        this.sortCounter.add(value, tags);
        this.incrementAllHistograms(tags, measurements);
    }

    private void incrementAllHistograms(Tags tags, Map<MetricType, Number> measurements) {
        this.queryTypeLatencyHistogram.record(measurements.get(MetricType.LATENCY).doubleValue(), tags);
        this.queryTypeCpuHistogram.record(measurements.get(MetricType.CPU).doubleValue(), tags);
        this.queryTypeMemoryHistogram.record(measurements.get(MetricType.MEMORY).doubleValue(), tags);
    }

    public Counter getAggCounter() {
        return this.aggCounter;
    }

    public Counter getSortCounter() {
        return this.sortCounter;
    }

    public Counter getCounterByQueryBuilderName(String queryBuilderName) {
        return this.nameToQueryTypeCounters.get(queryBuilderName);
    }

    private Counter createQueryCounter(String counterName) {
        Counter counter = this.metricsRegistry.createCounter("search.query.type." + counterName + ".count", "Counter for the number of top level and nested " + counterName + " search queries", UNIT);
        return counter;
    }
}

