/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.datasource.model;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class DataSourceType {
    public static DataSourceType PROMETHEUS = new DataSourceType("PROMETHEUS");
    public static DataSourceType OPENSEARCH = new DataSourceType("OPENSEARCH");
    public static DataSourceType SPARK = new DataSourceType("SPARK");
    public static DataSourceType S3GLUE = new DataSourceType("S3GLUE");
    private static Map<String, DataSourceType> knownValues = new HashMap<String, DataSourceType>();
    private final String name;

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static void register(DataSourceType ... dataSourceTypes) {
        for (DataSourceType type : dataSourceTypes) {
            String upperCaseName = type.name().toUpperCase();
            if (knownValues.containsKey(upperCaseName)) {
                throw new IllegalArgumentException("DataSourceType with name " + type.name() + " already exists");
            }
            knownValues.put(type.name().toUpperCase(), type);
        }
    }

    public static DataSourceType fromString(String name) {
        String upperCaseName = name.toUpperCase();
        if (knownValues.containsKey(upperCaseName)) {
            return knownValues.get(upperCaseName);
        }
        throw new IllegalArgumentException("No DataSourceType with name " + name + " found");
    }

    @Generated
    public DataSourceType(String name) {
        this.name = name;
    }

    static {
        DataSourceType.register(PROMETHEUS, OPENSEARCH, SPARK, S3GLUE);
    }
}

