/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.task;

import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.parkservices.AnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListenerResponseHandler;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.ThreadedActionListener;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.ad.constant.ADCommonMessages;
import org.opensearch.ad.indices.ADIndex;
import org.opensearch.ad.indices.ADIndexManagement;
import org.opensearch.ad.ml.ADModelManager;
import org.opensearch.ad.model.ADTask;
import org.opensearch.ad.model.ADTaskType;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.model.AnomalyResult;
import org.opensearch.ad.settings.ADEnabledSetting;
import org.opensearch.ad.settings.ADNumericSetting;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.ad.stats.ADStats;
import org.opensearch.ad.task.ADTaskCacheManager;
import org.opensearch.ad.task.ADTaskManager;
import org.opensearch.ad.transport.ADBatchAnomalyResultRequest;
import org.opensearch.ad.transport.ADBatchAnomalyResultResponse;
import org.opensearch.ad.transport.ADBatchTaskRemoteExecutionAction;
import org.opensearch.ad.transport.ADStatsNodesAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.CheckedRunnable;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.commons.InjectSecurity;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.bucket.terms.StringTerms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.aggregations.metrics.InternalMax;
import org.opensearch.search.aggregations.metrics.InternalMin;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.breaker.CircuitBreakerService;
import org.opensearch.timeseries.caching.PriorityTracker;
import org.opensearch.timeseries.cluster.HashRing;
import org.opensearch.timeseries.common.exception.EndRunException;
import org.opensearch.timeseries.common.exception.LimitExceededException;
import org.opensearch.timeseries.common.exception.ResourceNotFoundException;
import org.opensearch.timeseries.common.exception.TaskCancelledException;
import org.opensearch.timeseries.common.exception.TimeSeriesException;
import org.opensearch.timeseries.feature.FeatureManager;
import org.opensearch.timeseries.feature.SearchFeatureDao;
import org.opensearch.timeseries.function.ExecutorFunction;
import org.opensearch.timeseries.model.DateRange;
import org.opensearch.timeseries.model.Entity;
import org.opensearch.timeseries.model.FeatureData;
import org.opensearch.timeseries.model.IntervalTimeConfiguration;
import org.opensearch.timeseries.model.TaskState;
import org.opensearch.timeseries.stats.InternalStatNames;
import org.opensearch.timeseries.stats.StatNames;
import org.opensearch.timeseries.transport.StatsNodeResponse;
import org.opensearch.timeseries.transport.StatsRequest;
import org.opensearch.timeseries.transport.handler.ResultBulkIndexingHandler;
import org.opensearch.timeseries.util.ExceptionUtil;
import org.opensearch.timeseries.util.ParseUtils;
import org.opensearch.timeseries.util.SecurityClientUtil;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestOptions;
import org.opensearch.transport.TransportResponseHandler;
import org.opensearch.transport.TransportService;

public class ADBatchTaskRunner {
    private final Logger logger = LogManager.getLogger(ADBatchTaskRunner.class);
    private Settings settings;
    private final ThreadPool threadPool;
    private final Client client;
    private final SecurityClientUtil clientUtil;
    private final ADStats adStats;
    private final ClusterService clusterService;
    private final FeatureManager featureManager;
    private final CircuitBreakerService adCircuitBreakerService;
    private final ADTaskManager adTaskManager;
    private final ResultBulkIndexingHandler<AnomalyResult, ADIndex, ADIndexManagement> anomalyResultBulkIndexHandler;
    private final ADIndexManagement anomalyDetectionIndices;
    private final SearchFeatureDao searchFeatureDao;
    private final ADTaskCacheManager adTaskCacheManager;
    private final TransportRequestOptions option;
    private final HashRing hashRing;
    private final ADModelManager modelManager;
    private volatile Integer maxAdBatchTaskPerNode;
    private volatile Integer pieceSize;
    private volatile Integer pieceIntervalSeconds;
    private volatile Integer maxTopEntitiesPerHcDetector;
    private volatile Integer maxRunningEntitiesPerDetector;
    private static final int MAX_TOP_ENTITY_SEARCH_BUCKETS = 1000;
    private static final int SLEEP_TIME_FOR_NEXT_ENTITY_TASK_IN_MILLIS = 2000;

    public ADBatchTaskRunner(Settings settings, ThreadPool threadPool, ClusterService clusterService, Client client, SecurityClientUtil clientUtil, CircuitBreakerService adCircuitBreakerService, FeatureManager featureManager, ADTaskManager adTaskManager, ADIndexManagement anomalyDetectionIndices, ADStats adStats, ResultBulkIndexingHandler<AnomalyResult, ADIndex, ADIndexManagement> anomalyResultBulkIndexHandler, ADTaskCacheManager adTaskCacheManager, SearchFeatureDao searchFeatureDao, HashRing hashRing, ADModelManager modelManager) {
        this.settings = settings;
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.client = client;
        this.clientUtil = clientUtil;
        this.anomalyResultBulkIndexHandler = anomalyResultBulkIndexHandler;
        this.adStats = adStats;
        this.adCircuitBreakerService = adCircuitBreakerService;
        this.adTaskManager = adTaskManager;
        this.featureManager = featureManager;
        this.anomalyDetectionIndices = anomalyDetectionIndices;
        this.option = TransportRequestOptions.builder().withType(TransportRequestOptions.Type.REG).withTimeout((TimeValue)AnomalyDetectorSettings.AD_REQUEST_TIMEOUT.get(settings)).build();
        this.adTaskCacheManager = adTaskCacheManager;
        this.searchFeatureDao = searchFeatureDao;
        this.hashRing = hashRing;
        this.modelManager = modelManager;
        this.maxAdBatchTaskPerNode = (Integer)AnomalyDetectorSettings.MAX_BATCH_TASK_PER_NODE.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.MAX_BATCH_TASK_PER_NODE, it -> {
            this.maxAdBatchTaskPerNode = it;
        });
        this.pieceSize = (Integer)AnomalyDetectorSettings.BATCH_TASK_PIECE_SIZE.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.BATCH_TASK_PIECE_SIZE, it -> {
            this.pieceSize = it;
        });
        this.pieceIntervalSeconds = (Integer)AnomalyDetectorSettings.BATCH_TASK_PIECE_INTERVAL_SECONDS.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.BATCH_TASK_PIECE_INTERVAL_SECONDS, it -> {
            this.pieceIntervalSeconds = it;
        });
        this.maxTopEntitiesPerHcDetector = (Integer)AnomalyDetectorSettings.MAX_TOP_ENTITIES_FOR_HISTORICAL_ANALYSIS.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.MAX_TOP_ENTITIES_FOR_HISTORICAL_ANALYSIS, it -> {
            this.maxTopEntitiesPerHcDetector = it;
        });
        this.maxRunningEntitiesPerDetector = (Integer)AnomalyDetectorSettings.MAX_RUNNING_ENTITIES_PER_DETECTOR_FOR_HISTORICAL_ANALYSIS.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.MAX_RUNNING_ENTITIES_PER_DETECTOR_FOR_HISTORICAL_ANALYSIS, it -> {
            this.maxRunningEntitiesPerDetector = it;
        });
    }

    public void run(ADTask adTask, TransportService transportService, ActionListener<ADBatchAnomalyResultResponse> listener) {
        boolean isHCDetector = adTask.getDetector().isHighCardinality();
        if (isHCDetector && !this.adTaskCacheManager.topEntityInited(adTask.getConfigId())) {
            this.threadPool.executor("ad-batch-task-threadpool").execute(() -> {
                ActionListener<ADBatchAnomalyResultResponse> hcDelegatedListener = this.getInternalHCDelegatedListener(adTask);
                ActionListener<String> topEntitiesListener = this.getTopEntitiesListener(adTask, transportService, hcDelegatedListener);
                try {
                    this.getTopEntities(adTask, topEntitiesListener);
                }
                catch (Exception e) {
                    topEntitiesListener.onFailure(e);
                }
            });
            listener.onResponse((Object)new ADBatchAnomalyResultResponse(this.clusterService.localNode().getId(), false));
        } else {
            this.forwardOrExecuteADTask(adTask, transportService, listener);
        }
    }

    private ActionListener<ADBatchAnomalyResultResponse> getInternalHCDelegatedListener(ADTask adTask) {
        return ActionListener.wrap(r -> this.logger.debug("[InternalHCDelegatedListener]: running task {} on nodeId {}", (Object)adTask.getTaskId(), (Object)r.getNodeId()), e -> this.logger.error("[InternalHCDelegatedListener]: failed to run task", (Throwable)e));
    }

    private ActionListener<String> getTopEntitiesListener(ADTask adTask, TransportService transportService, ActionListener<ADBatchAnomalyResultResponse> listener) {
        String taskId = adTask.getTaskId();
        String detectorId = adTask.getConfigId();
        ActionListener actionListener = ActionListener.wrap(response -> {
            this.adTaskCacheManager.setTopEntityInited(detectorId);
            int totalEntities = this.adTaskCacheManager.getPendingEntityCount(detectorId);
            this.logger.info("Total top entities: {} for detector {}, task {}", (Object)totalEntities, (Object)detectorId, (Object)taskId);
            this.hashRing.getNodesWithSameLocalVersion(dataNodes -> {
                int numberOfEligibleDataNodes = ((DiscoveryNode[])dataNodes).length;
                int maxRunningEntitiesLimit = Math.min(totalEntities, Math.min(numberOfEligibleDataNodes * this.maxAdBatchTaskPerNode, this.maxRunningEntitiesPerDetector));
                this.adTaskCacheManager.setDetectorTaskLaneLimit(detectorId, maxRunningEntitiesLimit);
                int maxRunningEntities = Math.min(maxRunningEntitiesLimit, this.adTaskCacheManager.getDetectorTaskSlots(detectorId));
                this.logger.debug("Calculate task lane for detector {}: totalEntities: {}, numberOfEligibleDataNodes: {}, maxAdBatchTaskPerNode: {}, maxRunningEntitiesPerDetector: {}, maxRunningEntities: {}, detectorTaskSlots: {}", (Object)detectorId, (Object)totalEntities, (Object)numberOfEligibleDataNodes, (Object)this.maxAdBatchTaskPerNode, (Object)this.maxRunningEntitiesPerDetector, (Object)maxRunningEntities, (Object)this.adTaskCacheManager.getDetectorTaskSlots(detectorId));
                this.forwardOrExecuteADTask(adTask, transportService, listener);
                this.adTaskCacheManager.setAllowedRunningEntities(detectorId, maxRunningEntities - 1);
            }, listener);
        }, e -> {
            this.logger.debug("Failed to run task " + taskId, (Throwable)e);
            if (adTask.getTaskType().equals(ADTaskType.HISTORICAL_HC_DETECTOR.name())) {
                this.adTaskManager.entityTaskDone(adTask, (Exception)e, transportService);
            }
            listener.onFailure(e);
        });
        ThreadedActionListener threadedActionListener = new ThreadedActionListener(this.logger, this.threadPool, "ad-batch-task-threadpool", actionListener, false);
        return threadedActionListener;
    }

    public void getTopEntities(ADTask adTask, ActionListener<String> internalHCListener) {
        this.getDateRangeOfSourceData(adTask, (dataStartTime, dataEndTime) -> {
            PriorityTracker priorityTracker = new PriorityTracker(Clock.systemUTC(), adTask.getDetector().getIntervalInSeconds(), adTask.getDetectionDateRange().getStartTime().toEpochMilli(), 10000);
            long detectorInterval = adTask.getDetector().getIntervalInMilliseconds();
            this.logger.debug("start to search top entities at {}, data start time: {}, data end time: {}, interval: {}", (Object)System.currentTimeMillis(), dataStartTime, dataEndTime, (Object)detectorInterval);
            if (adTask.getDetector().hasMultipleCategories()) {
                this.searchTopEntitiesForMultiCategoryHC(adTask, priorityTracker, (long)dataEndTime, Math.max((dataEndTime - dataStartTime) / 1000L, detectorInterval), (long)dataStartTime, dataStartTime + detectorInterval, internalHCListener);
            } else {
                this.searchTopEntitiesForSingleCategoryHC(adTask, priorityTracker, (long)dataEndTime, Math.max((dataEndTime - dataStartTime) / 1000L, detectorInterval), (long)dataStartTime, dataStartTime + detectorInterval, internalHCListener);
            }
        }, internalHCListener);
    }

    private void searchTopEntitiesForMultiCategoryHC(ADTask adTask, PriorityTracker priorityTracker, long detectionEndTime, long bucketInterval, long dataStartTime, long dataEndTime, ActionListener<String> internalHCListener) {
        this.checkIfADTaskCancelledAndCleanupCache(adTask);
        ActionListener topEntitiesListener = ActionListener.wrap(topEntities -> {
            topEntities.forEach(entity -> priorityTracker.updatePriority(this.adTaskManager.convertEntityToString((Entity)entity, adTask.getDetector())));
            if (dataEndTime < detectionEndTime) {
                this.searchTopEntitiesForMultiCategoryHC(adTask, priorityTracker, detectionEndTime, bucketInterval, dataEndTime, dataEndTime + bucketInterval, internalHCListener);
            } else {
                this.logger.debug("finish searching top entities at " + System.currentTimeMillis());
                List<String> topNEntities = priorityTracker.getTopNEntities(this.maxTopEntitiesPerHcDetector);
                if (topNEntities.size() == 0) {
                    this.logger.error("There is no entity found for detector " + adTask.getConfigId());
                    internalHCListener.onFailure((Exception)new ResourceNotFoundException(adTask.getConfigId(), "No entity found"));
                    return;
                }
                this.adTaskCacheManager.addPendingEntities(adTask.getConfigId(), topNEntities);
                this.adTaskCacheManager.setTopEntityCount(adTask.getConfigId(), topNEntities.size());
                internalHCListener.onResponse((Object)"Get top entities done");
            }
        }, e -> {
            this.logger.error("Failed to get top entities for detector " + adTask.getConfigId(), (Throwable)e);
            internalHCListener.onFailure(e);
        });
        int minimumDocCount = Math.max((int)(bucketInterval / adTask.getDetector().getIntervalInMilliseconds()) / 2, 1);
        this.searchFeatureDao.getHighestCountEntities(adTask.getDetector(), dataStartTime, dataEndTime, 10000, minimumDocCount, 10000, (ActionListener<List<Entity>>)topEntitiesListener);
    }

    private void searchTopEntitiesForSingleCategoryHC(ADTask adTask, PriorityTracker priorityTracker, long detectionEndTime, long interval, long dataStartTime, long dataEndTime, ActionListener<String> internalHCListener) {
        this.checkIfADTaskCancelledAndCleanupCache(adTask);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        RangeQueryBuilder rangeQueryBuilder = new RangeQueryBuilder(adTask.getDetector().getTimeField()).gte((Object)dataStartTime).lte((Object)dataEndTime).format("epoch_millis");
        boolQueryBuilder.filter((QueryBuilder)rangeQueryBuilder);
        boolQueryBuilder.filter(adTask.getDetector().getFilterQuery());
        sourceBuilder.query((QueryBuilder)boolQueryBuilder);
        String topEntitiesAgg = "topEntities";
        TermsAggregationBuilder aggregation = ((TermsAggregationBuilder)new TermsAggregationBuilder(topEntitiesAgg).field(adTask.getDetector().getCategoryFields().get(0))).size(10000);
        sourceBuilder.aggregation((AggregationBuilder)aggregation).size(0);
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.source(sourceBuilder);
        searchRequest.indices(adTask.getDetector().getIndices().toArray(new String[0]));
        ActionListener searchResponseListener = ActionListener.wrap(r -> {
            StringTerms stringTerms = (StringTerms)r.getAggregations().get(topEntitiesAgg);
            List buckets = stringTerms.getBuckets();
            ArrayList<String> topEntities = new ArrayList<String>();
            for (StringTerms.Bucket bucket : buckets) {
                String key = bucket.getKeyAsString();
                topEntities.add(key);
            }
            topEntities.forEach(e -> priorityTracker.updatePriority((String)e));
            if (dataEndTime < detectionEndTime) {
                this.searchTopEntitiesForSingleCategoryHC(adTask, priorityTracker, detectionEndTime, interval, dataEndTime, dataEndTime + interval, internalHCListener);
            } else {
                this.logger.debug("finish searching top entities at " + System.currentTimeMillis());
                List<String> topNEntities = priorityTracker.getTopNEntities(this.maxTopEntitiesPerHcDetector);
                if (topNEntities.size() == 0) {
                    this.logger.error("There is no entity found for detector " + adTask.getConfigId());
                    internalHCListener.onFailure((Exception)new ResourceNotFoundException(adTask.getConfigId(), "No entity found"));
                    return;
                }
                this.adTaskCacheManager.addPendingEntities(adTask.getConfigId(), topNEntities);
                this.adTaskCacheManager.setTopEntityCount(adTask.getConfigId(), topNEntities.size());
                internalHCListener.onResponse((Object)"Get top entities done");
            }
        }, e -> {
            this.logger.error("Failed to get top entities for detector " + adTask.getConfigId(), (Throwable)e);
            internalHCListener.onFailure(e);
        });
        this.clientUtil.asyncRequestWithInjectedSecurity(searchRequest, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), adTask.getUser(), this.client, AnalysisType.AD, searchResponseListener);
    }

    public void forwardOrExecuteADTask(ADTask adTask, TransportService transportService, ActionListener<ADBatchAnomalyResultResponse> listener) {
        try {
            this.checkIfADTaskCancelledAndCleanupCache(adTask);
            String detectorId = adTask.getConfigId();
            AnomalyDetector detector = adTask.getDetector();
            boolean isHCDetector = detector.isHighCardinality();
            if (isHCDetector) {
                String entityString = this.adTaskCacheManager.pollEntity(detectorId);
                this.logger.debug("Start to run entity: {} of detector {}", (Object)entityString, (Object)detectorId);
                if (entityString == null) {
                    listener.onResponse((Object)new ADBatchAnomalyResultResponse(this.clusterService.localNode().getId(), false));
                    return;
                }
                ActionListener wrappedListener = ActionListener.wrap(r -> this.logger.debug("Entity task created successfully"), e -> {
                    this.logger.error("Failed to start entity task for detector: {}, entity: {}", (Object)detectorId, (Object)entityString);
                    this.adTaskCacheManager.addPendingEntity(detectorId, entityString);
                });
                Entity entity = this.adTaskManager.parseEntityFromString(entityString, adTask);
                String parentTaskId = adTask.getTaskType().equals(ADTaskType.HISTORICAL_HC_ENTITY.name()) ? adTask.getParentTaskId() : adTask.getTaskId();
                this.adTaskManager.getAndExecuteOnLatestConfigTask(detectorId, parentTaskId, entity, ImmutableList.of((Object)ADTaskType.HISTORICAL_HC_ENTITY), existingEntityTask -> {
                    if (existingEntityTask.isPresent()) {
                        ADTask adEntityTask = (ADTask)existingEntityTask.get();
                        this.logger.debug("Rerun entity task for task id: {}, error of last run: {}", (Object)adEntityTask.getTaskId(), (Object)adEntityTask.getError());
                        ActionListener<ADBatchAnomalyResultResponse> workerNodeResponseListener = this.workerNodeResponseListener(adEntityTask, transportService, listener);
                        this.forwardOrExecuteEntityTask(adEntityTask, transportService, workerNodeResponseListener);
                    } else {
                        this.logger.info("Create entity task for entity:{}", (Object)entityString);
                        Instant now = Instant.now();
                        ADTask adEntityTask = ((ADTask.Builder)((ADTask.Builder)((ADTask.Builder)((ADTask.Builder)((ADTask.Builder)((ADTask.Builder)((ADTask.Builder)((ADTask.Builder)((ADTask.Builder)((ADTask.Builder)((ADTask.Builder)((ADTask.Builder)((ADTask.Builder)((ADTask.Builder)new ADTask.Builder().configId(adTask.getConfigId())).detector(detector).isLatest(true)).taskType(ADTaskType.HISTORICAL_HC_ENTITY.name())).executionStartTime(now)).taskProgress(Float.valueOf(0.0f))).initProgress(Float.valueOf(0.0f))).state(TaskState.INIT.name())).initProgress(Float.valueOf(0.0f))).lastUpdateTime(now)).startedBy(adTask.getStartedBy())).coordinatingNode(this.clusterService.localNode().getId())).detectionDateRange(adTask.getDetectionDateRange()).user(adTask.getUser())).entity(entity)).parentTaskId(parentTaskId)).build();
                        this.adTaskManager.createTaskDirectly(adEntityTask, r -> {
                            adEntityTask.setTaskId(r.getId());
                            ActionListener<ADBatchAnomalyResultResponse> workerNodeResponseListener = this.workerNodeResponseListener(adEntityTask, transportService, listener);
                            this.forwardOrExecuteEntityTask(adEntityTask, transportService, workerNodeResponseListener);
                        }, wrappedListener);
                    }
                }, transportService, false, wrappedListener);
            } else {
                HashMap<String, Object> updatedFields = new HashMap<String, Object>();
                updatedFields.put("state", TaskState.INIT.name());
                updatedFields.put("init_progress", Float.valueOf(0.0f));
                ActionListener<ADBatchAnomalyResultResponse> workerNodeResponseListener = this.workerNodeResponseListener(adTask, transportService, listener);
                this.adTaskManager.updateTask(adTask.getTaskId(), updatedFields, (ActionListener<UpdateResponse>)ActionListener.wrap(r -> this.forwardOrExecuteEntityTask(adTask, transportService, workerNodeResponseListener), e -> workerNodeResponseListener.onFailure(e)));
            }
        }
        catch (Exception e2) {
            this.logger.error("Failed to forward or execute AD task " + adTask.getTaskId(), (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    private ActionListener<ADBatchAnomalyResultResponse> workerNodeResponseListener(ADTask adTask, TransportService transportService, ActionListener<ADBatchAnomalyResultResponse> listener) {
        ActionListener actionListener = ActionListener.wrap(r -> {
            listener.onResponse((Object)r);
            if (adTask.isHistoricalEntityTask()) {
                this.adTaskCacheManager.moveToRunningEntity(adTask.getConfigId(), this.adTaskManager.convertEntityToString(adTask));
            }
            this.startNewEntityTaskLane(adTask, transportService);
        }, e -> {
            this.logger.error("Failed to dispatch task to worker node, task id: " + adTask.getTaskId(), (Throwable)e);
            listener.onFailure(e);
            this.handleException(adTask, (Exception)e);
            if (adTask.getDetector().isHighCardinality()) {
                this.adTaskManager.entityTaskDone(adTask, (Exception)e, transportService);
                if (this.adTaskCacheManager.getAvailableNewEntityTaskLanes(adTask.getConfigId()) > 0) {
                    this.threadPool.schedule(() -> this.startNewEntityTaskLane(adTask, transportService), TimeValue.timeValueSeconds((long)2000L), "ad-batch-task-threadpool");
                }
            }
        });
        ThreadedActionListener threadedActionListener = new ThreadedActionListener(this.logger, this.threadPool, "ad-batch-task-threadpool", actionListener, false);
        return threadedActionListener;
    }

    private void forwardOrExecuteEntityTask(ADTask adTask, TransportService transportService, ActionListener<ADBatchAnomalyResultResponse> workerNodeResponseListener) {
        this.checkIfADTaskCancelledAndCleanupCache(adTask);
        this.dispatchTask(adTask, (ActionListener<DiscoveryNode>)ActionListener.wrap(node -> {
            if (this.clusterService.localNode().getId().equals(node.getId())) {
                this.startADBatchTaskOnWorkerNode(adTask, false, transportService, workerNodeResponseListener);
            } else {
                transportService.sendRequest(node, ADBatchTaskRemoteExecutionAction.NAME, (TransportRequest)new ADBatchAnomalyResultRequest(adTask), this.option, (TransportResponseHandler)new ActionListenerResponseHandler(workerNodeResponseListener, ADBatchAnomalyResultResponse::new));
            }
        }, e -> workerNodeResponseListener.onFailure(e)));
    }

    private synchronized void startNewEntityTaskLane(ADTask adTask, TransportService transportService) {
        if (adTask.getDetector().isHighCardinality() && this.adTaskCacheManager.getAndDecreaseEntityTaskLanes(adTask.getConfigId()) > 0) {
            this.logger.debug("start new task lane for detector {}", (Object)adTask.getConfigId());
            this.forwardOrExecuteADTask(adTask, transportService, this.getInternalHCDelegatedListener(adTask));
        }
    }

    private void dispatchTask(ADTask adTask, ActionListener<DiscoveryNode> listener) {
        this.hashRing.getNodesWithSameLocalVersion(dataNodes -> {
            StatsRequest adStatsRequest = new StatsRequest((DiscoveryNode)dataNodes);
            adStatsRequest.addAll((Set<String>)ImmutableSet.of((Object)StatNames.AD_EXECUTING_BATCH_TASK_COUNT.getName(), (Object)InternalStatNames.JVM_HEAP_USAGE.getName()));
            this.client.execute((ActionType)ADStatsNodesAction.INSTANCE, (ActionRequest)adStatsRequest, ActionListener.wrap(adStatsResponse -> {
                List candidateNodeResponse = adStatsResponse.getNodes().stream().filter(stat -> (Long)stat.getStatsMap().get(InternalStatNames.JVM_HEAP_USAGE.getName()) < (long)ADNumericSetting.getJVMHeapUsageThreshold()).collect(Collectors.toList());
                if (candidateNodeResponse.size() == 0) {
                    StringBuilder errorMessageBuilder = new StringBuilder("All nodes' memory usage exceeds limitation ").append(ADNumericSetting.getJVMHeapUsageThreshold()).append("%. ").append(ADCommonMessages.NO_ELIGIBLE_NODE_TO_RUN_DETECTOR).append(adTask.getConfigId());
                    String errorMessage = errorMessageBuilder.toString();
                    this.logger.warn(errorMessage + ", task id " + adTask.getTaskId() + ", " + adTask.getTaskType());
                    listener.onFailure((Exception)new LimitExceededException(adTask.getConfigId(), errorMessage));
                    return;
                }
                if ((candidateNodeResponse = candidateNodeResponse.stream().filter(stat -> (Long)stat.getStatsMap().get(StatNames.AD_EXECUTING_BATCH_TASK_COUNT.getName()) < (long)this.maxAdBatchTaskPerNode.intValue()).collect(Collectors.toList())).size() == 0) {
                    StringBuilder errorMessageBuilder = new StringBuilder("All nodes' executing batch tasks exceeds limitation ").append(ADCommonMessages.NO_ELIGIBLE_NODE_TO_RUN_DETECTOR).append(adTask.getConfigId());
                    String errorMessage = errorMessageBuilder.toString();
                    this.logger.warn(errorMessage + ", task id " + adTask.getTaskId() + ", " + adTask.getTaskType());
                    listener.onFailure((Exception)new LimitExceededException(adTask.getConfigId(), errorMessage));
                    return;
                }
                Optional targetNode = candidateNodeResponse.stream().sorted((r1, r2) -> {
                    int result = ((Long)r1.getStatsMap().get(StatNames.AD_EXECUTING_BATCH_TASK_COUNT.getName())).compareTo((Long)r2.getStatsMap().get(StatNames.AD_EXECUTING_BATCH_TASK_COUNT.getName()));
                    if (result == 0) {
                        return ((Long)r1.getStatsMap().get(InternalStatNames.JVM_HEAP_USAGE.getName())).compareTo((Long)r2.getStatsMap().get(InternalStatNames.JVM_HEAP_USAGE.getName()));
                    }
                    return result;
                }).findFirst();
                listener.onResponse((Object)((StatsNodeResponse)((Object)((Object)((Object)targetNode.get())))).getNode());
            }, exception -> {
                this.logger.error("Failed to get node's task stats", (Throwable)exception);
                listener.onFailure(exception);
            }));
        }, listener);
    }

    public void startADBatchTaskOnWorkerNode(ADTask adTask, boolean runTaskRemotely, TransportService transportService, ActionListener<ADBatchAnomalyResultResponse> delegatedListener) {
        try {
            this.checkClusterState(adTask);
            this.threadPool.executor("ad-batch-task-threadpool").execute(() -> {
                ActionListener<String> internalListener = this.internalBatchTaskListener(adTask, transportService);
                try {
                    this.executeADBatchTaskOnWorkerNode(adTask, internalListener);
                }
                catch (Exception e) {
                    internalListener.onFailure(e);
                }
            });
            delegatedListener.onResponse((Object)new ADBatchAnomalyResultResponse(this.clusterService.localNode().getId(), runTaskRemotely));
        }
        catch (Exception e) {
            this.logger.error("Fail to start AD batch task " + adTask.getTaskId(), (Throwable)e);
            delegatedListener.onFailure(e);
        }
    }

    private ActionListener<String> internalBatchTaskListener(ADTask adTask, TransportService transportService) {
        String taskId = adTask.getTaskId();
        String detectorTaskId = adTask.getConfigLevelTaskId();
        String detectorId = adTask.getConfigId();
        ActionListener listener = ActionListener.wrap(response -> {
            this.adTaskCacheManager.remove(taskId, detectorId, detectorTaskId);
            this.adStats.getStat(StatNames.AD_EXECUTING_BATCH_TASK_COUNT.getName()).decrement();
            if (!adTask.getDetector().isHighCardinality()) {
                this.adTaskManager.cleanDetectorCache(adTask, transportService, () -> this.adTaskManager.updateTask(taskId, (Map<String, Object>)ImmutableMap.of((Object)"state", (Object)TaskState.FINISHED.name())));
            } else {
                this.adTaskManager.updateTask(adTask.getTaskId(), (Map<String, Object>)ImmutableMap.of((Object)"state", (Object)TaskState.FINISHED.name()));
                this.adTaskManager.entityTaskDone(adTask, null, transportService);
            }
        }, e -> {
            this.adTaskCacheManager.remove(taskId, detectorId, detectorTaskId);
            this.adStats.getStat(StatNames.AD_EXECUTING_BATCH_TASK_COUNT.getName()).decrement();
            if (!adTask.getDetector().isHighCardinality()) {
                this.adTaskManager.cleanDetectorCache(adTask, transportService, () -> this.handleException(adTask, (Exception)e));
            } else {
                this.adTaskManager.entityTaskDone(adTask, (Exception)e, transportService);
                this.handleException(adTask, (Exception)e);
            }
        });
        ThreadedActionListener threadedActionListener = new ThreadedActionListener(this.logger, this.threadPool, "ad-batch-task-threadpool", listener, false);
        return threadedActionListener;
    }

    private void handleException(ADTask adTask, Exception e) {
        if (e instanceof TaskCancelledException) {
            this.adStats.getStat(StatNames.AD_CANCELED_BATCH_TASK_COUNT.getName()).increment();
        } else if (ExceptionUtil.countInStats(e)) {
            this.adStats.getStat(StatNames.AD_BATCH_TASK_FAILURE_COUNT.getName()).increment();
        }
        this.adTaskManager.handleTaskException(adTask, e);
    }

    private void executeADBatchTaskOnWorkerNode(ADTask adTask, ActionListener<String> internalListener) {
        this.adStats.getStat(StatNames.AD_EXECUTING_BATCH_TASK_COUNT.getName()).increment();
        this.adStats.getStat(StatNames.AD_TOTAL_BATCH_TASK_EXECUTION_COUNT.getName()).increment();
        this.adTaskCacheManager.add(adTask);
        Instant executeStartTime = Instant.now();
        this.runFirstPiece(adTask, executeStartTime, internalListener);
    }

    private void checkClusterState(ADTask adTask) {
        this.checkADPluginEnabled(adTask.getConfigId());
        this.checkCircuitBreaker(adTask);
    }

    private void checkADPluginEnabled(String detectorId) {
        if (!ADEnabledSetting.isADEnabled()) {
            throw new EndRunException(detectorId, "AD functionality is disabled. To enable update plugins.anomaly_detection.enabled to true", true).countedInStats(false);
        }
    }

    private void checkCircuitBreaker(ADTask adTask) {
        String taskId = adTask.getTaskId();
        if (this.adCircuitBreakerService.isOpen().booleanValue()) {
            String error = "Circuit breaker is open";
            this.logger.error("AD task: {}, {}", (Object)taskId, (Object)error);
            throw new LimitExceededException(adTask.getConfigId(), error, true);
        }
    }

    private void runFirstPiece(ADTask adTask, Instant executeStartTime, ActionListener<String> internalListener) {
        try {
            this.adTaskManager.updateTask(adTask.getTaskId(), (Map<String, Object>)ImmutableMap.of((Object)"state", (Object)TaskState.INIT.name(), (Object)"current_piece", (Object)adTask.getDetectionDateRange().getStartTime().toEpochMilli(), (Object)"task_progress", (Object)Float.valueOf(0.0f), (Object)"init_progress", (Object)Float.valueOf(0.0f), (Object)"worker_node", (Object)this.clusterService.localNode().getId()), (ActionListener<UpdateResponse>)ActionListener.wrap(r -> {
                try {
                    this.checkIfADTaskCancelledAndCleanupCache(adTask);
                    this.getDateRangeOfSourceData(adTask, (dataStartTime, dataEndTime) -> {
                        long interval = ((IntervalTimeConfiguration)adTask.getDetector().getInterval()).toDuration().toMillis();
                        long expectedPieceEndTime = dataStartTime + (long)this.pieceSize.intValue() * interval;
                        long firstPieceEndTime = Math.min(expectedPieceEndTime, dataEndTime);
                        this.logger.debug("start first piece from {} to {}, interval {}, dataStartTime {}, dataEndTime {}, detectorId {}, taskId {}", dataStartTime, (Object)firstPieceEndTime, (Object)interval, dataStartTime, dataEndTime, (Object)adTask.getConfigId(), (Object)adTask.getTaskId());
                        this.getFeatureData(adTask, (long)dataStartTime, firstPieceEndTime, (long)dataStartTime, (long)dataEndTime, interval, executeStartTime, internalListener);
                    }, internalListener);
                }
                catch (Exception e) {
                    internalListener.onFailure(e);
                }
            }, arg_0 -> internalListener.onFailure(arg_0)));
        }
        catch (Exception exception) {
            internalListener.onFailure(exception);
        }
    }

    private void getDateRangeOfSourceData(ADTask adTask, BiConsumer<Long, Long> consumer, ActionListener<String> internalListener) {
        String taskId = adTask.getTaskId();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().aggregation((AggregationBuilder)AggregationBuilders.min((String)"min_timefield").field(adTask.getDetector().getTimeField())).aggregation((AggregationBuilder)AggregationBuilders.max((String)"max_timefield").field(adTask.getDetector().getTimeField())).size(0);
        if (adTask.getEntity() != null && adTask.getEntity().getAttributes().size() > 0) {
            BoolQueryBuilder query = new BoolQueryBuilder();
            adTask.getEntity().getAttributes().entrySet().forEach(entity -> query.filter((QueryBuilder)new TermQueryBuilder((String)entity.getKey(), (String)entity.getValue())));
            searchSourceBuilder.query((QueryBuilder)query);
        }
        SearchRequest request = new SearchRequest().indices(adTask.getDetector().getIndices().toArray(new String[0])).source(searchSourceBuilder);
        ActionListener searchResponseListener = ActionListener.wrap(r -> {
            InternalMin minAgg = (InternalMin)r.getAggregations().get("min_timefield");
            InternalMax maxAgg = (InternalMax)r.getAggregations().get("max_timefield");
            double minValue = minAgg.getValue();
            double maxValue = maxAgg.getValue();
            if (minValue == Double.POSITIVE_INFINITY) {
                internalListener.onFailure((Exception)new ResourceNotFoundException(adTask.getConfigId(), "There is no data in the time field"));
                return;
            }
            long interval = ((IntervalTimeConfiguration)adTask.getDetector().getInterval()).toDuration().toMillis();
            DateRange detectionDateRange = adTask.getDetectionDateRange();
            long dataStartTime = detectionDateRange.getStartTime().toEpochMilli();
            long dataEndTime = detectionDateRange.getEndTime().toEpochMilli();
            long minDate = (long)minValue;
            long maxDate = (long)maxValue;
            if (minDate >= dataEndTime || maxDate <= dataStartTime) {
                internalListener.onFailure((Exception)new ResourceNotFoundException(adTask.getConfigId(), "There is no data in the detection date range"));
                return;
            }
            if (minDate > dataStartTime) {
                dataStartTime = minDate;
            }
            if (maxDate < dataEndTime) {
                dataEndTime = maxDate;
            }
            dataStartTime -= dataStartTime % interval;
            dataEndTime -= dataEndTime % interval;
            this.logger.debug("adjusted date range: start: {}, end: {}, taskId: {}", (Object)dataStartTime, (Object)dataEndTime, (Object)taskId);
            if (dataEndTime - dataStartTime < 32L * interval) {
                internalListener.onFailure((Exception)new TimeSeriesException("There is not enough data to train model").countedInStats(false));
                return;
            }
            consumer.accept(dataStartTime, dataEndTime);
        }, e -> internalListener.onFailure(e));
        this.clientUtil.asyncRequestWithInjectedSecurity(request, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), adTask.getUser(), this.client, AnalysisType.AD, searchResponseListener);
    }

    private void getFeatureData(ADTask adTask, long pieceStartTime, long pieceEndTime, long dataStartTime, long dataEndTime, long interval, Instant executeStartTime, ActionListener<String> internalListener) {
        ActionListener actionListener = ActionListener.wrap(dataPoints -> {
            try {
                if (dataPoints.size() == 0) {
                    this.logger.debug("No data in current piece with end time: " + pieceEndTime);
                    this.runNextPiece(adTask, pieceEndTime, dataStartTime, dataEndTime, interval, internalListener);
                } else {
                    this.detectAnomaly(adTask, (Map<Long, Optional<double[]>>)dataPoints, pieceStartTime, pieceEndTime, dataStartTime, dataEndTime, interval, executeStartTime, internalListener);
                }
            }
            catch (Exception e) {
                internalListener.onFailure(e);
            }
        }, exception -> {
            this.logger.debug("Fail to get feature data by batch for this piece with end time: " + pieceEndTime);
            internalListener.onFailure(exception);
        });
        ThreadedActionListener threadedActionListener = new ThreadedActionListener(this.logger, this.threadPool, "ad-batch-task-threadpool", actionListener, false);
        this.featureManager.getFeatureDataPointsByBatch(adTask.getDetector(), adTask.getEntity(), pieceStartTime, pieceEndTime, (ActionListener<Map<Long, Optional<double[]>>>)threadedActionListener);
    }

    private void detectAnomaly(ADTask adTask, Map<Long, Optional<double[]>> dataPoints, long pieceStartTime, long pieceEndTime, long dataStartTime, long dataEndTime, long interval, Instant executeStartTime, ActionListener<String> internalListener) {
        List roles;
        String user;
        String taskId = adTask.getTaskId();
        ThresholdedRandomCutForest trcf = this.adTaskCacheManager.getTRcfModel(taskId);
        ArrayList<AnomalyResult> anomalyResults = new ArrayList<AnomalyResult>();
        long intervalEndTime = pieceStartTime;
        for (int i = 0; i < this.pieceSize && intervalEndTime < dataEndTime; ++i) {
            Optional dataPoint = dataPoints.containsKey(intervalEndTime) ? dataPoints.get(intervalEndTime) : Optional.empty();
            intervalEndTime += interval;
            if (dataPoint.isEmpty()) {
                AnomalyResult anomalyResult = new AnomalyResult(adTask.getConfigId(), adTask.getConfigLevelTaskId(), null, Instant.ofEpochMilli(intervalEndTime - interval), Instant.ofEpochMilli(intervalEndTime), executeStartTime, Instant.now(), "No data in current detection window", Optional.ofNullable(adTask.getEntity()), adTask.getDetector().getUser(), this.anomalyDetectionIndices.getSchemaVersion(ADIndex.RESULT), adTask.getEntityModelId());
                anomalyResults.add(anomalyResult);
                continue;
            }
            List<FeatureData> featureData = ParseUtils.getFeatureData((double[])dataPoint.get(), adTask.getDetector());
            AnomalyDescriptor descriptor = trcf.process((double[])dataPoint.get(), intervalEndTime);
            double score = descriptor.getRCFScore();
            if (!this.adTaskCacheManager.isThresholdModelTrained(taskId) && score > 0.0) {
                this.adTaskCacheManager.setThresholdModelTrained(taskId, true);
            }
            AnomalyResult anomalyResult = AnomalyResult.fromRawTRCFResult(adTask.getConfigId(), adTask.getDetector().getIntervalInMilliseconds(), adTask.getConfigLevelTaskId(), score, descriptor.getAnomalyGrade(), descriptor.getDataConfidence(), featureData, Instant.ofEpochMilli(intervalEndTime - interval), Instant.ofEpochMilli(intervalEndTime), executeStartTime, Instant.now(), null, Optional.ofNullable(adTask.getEntity()), adTask.getDetector().getUser(), this.anomalyDetectionIndices.getSchemaVersion(ADIndex.RESULT), adTask.getEntityModelId(), this.modelManager.normalizeAttribution(trcf.getForest(), descriptor.getRelevantAttribution()), descriptor.getRelativeIndex(), descriptor.getPastValues(), descriptor.getExpectedValuesList(), descriptor.getLikelihoodOfValues(), descriptor.getThreshold());
            anomalyResults.add(anomalyResult);
        }
        if (adTask.getUser() == null) {
            user = "";
            roles = this.settings.getAsList("", (List)ImmutableList.of((Object)"all_access", (Object)"AmazonES_all_access"));
        } else {
            user = adTask.getUser().getName();
            roles = adTask.getUser().getRoles();
        }
        String resultIndex = adTask.getDetector().getCustomResultIndexOrAlias();
        if (resultIndex == null) {
            this.storeAnomalyResultAndRunNextPiece(adTask, pieceEndTime, dataStartTime, dataEndTime, interval, internalListener, anomalyResults, resultIndex, null);
            return;
        }
        try (InjectSecurity injectSecurity = new InjectSecurity(adTask.getTaskId(), this.settings, this.client.threadPool().getThreadContext());){
            injectSecurity.inject(user, roles);
            this.storeAnomalyResultAndRunNextPiece(adTask, pieceEndTime, dataStartTime, dataEndTime, interval, internalListener, anomalyResults, resultIndex, () -> injectSecurity.close());
        }
        catch (Exception exception) {
            this.logger.error("Failed to inject user roles", (Throwable)exception);
            internalListener.onFailure(exception);
        }
    }

    private void storeAnomalyResultAndRunNextPiece(ADTask adTask, long pieceEndTime, long dataStartTime, long dataEndTime, long interval, ActionListener<String> internalListener, List<AnomalyResult> anomalyResults, String resultIndex, CheckedRunnable<?> runBefore) {
        ThreadedActionListener actionListener = new ThreadedActionListener(this.logger, this.threadPool, "ad-batch-task-threadpool", ActionListener.wrap(r -> {
            try {
                this.runNextPiece(adTask, pieceEndTime, dataStartTime, dataEndTime, interval, internalListener);
            }
            catch (Exception e) {
                internalListener.onFailure(e);
            }
        }, e -> {
            this.logger.error("Fail to bulk index anomaly result", (Throwable)e);
            internalListener.onFailure(e);
        }), false);
        String detectorId = adTask.getConfigId();
        this.anomalyResultBulkIndexHandler.bulk(resultIndex, anomalyResults, detectorId, (ActionListener<BulkResponse>)(runBefore == null ? actionListener : ActionListener.runBefore((ActionListener)actionListener, runBefore)));
    }

    private void runNextPiece(ADTask adTask, long pieceStartTime, long dataStartTime, long dataEndTime, long interval, ActionListener<String> internalListener) {
        String taskId = adTask.getTaskId();
        String detectorId = adTask.getConfigId();
        String detectorTaskId = adTask.getConfigLevelTaskId();
        float initProgress = this.calculateInitProgress(taskId);
        String taskState = initProgress >= 1.0f ? TaskState.RUNNING.name() : TaskState.INIT.name();
        this.logger.debug("Init progress: {}, taskState:{}, task id: {}", (Object)Float.valueOf(initProgress), (Object)taskState, (Object)taskId);
        if (initProgress >= 1.0f && adTask.isHistoricalEntityTask()) {
            this.updateDetectorLevelTaskState(detectorId, adTask.getParentTaskId(), TaskState.RUNNING.name());
        }
        if (pieceStartTime < dataEndTime) {
            this.checkIfADTaskCancelledAndCleanupCache(adTask);
            this.threadPool.schedule(() -> {
                this.checkClusterState(adTask);
                long expectedPieceEndTime = pieceStartTime + (long)this.pieceSize.intValue() * interval;
                long pieceEndTime = expectedPieceEndTime > dataEndTime ? dataEndTime : expectedPieceEndTime;
                this.logger.debug("task id: {}, start next piece start from {} to {}, interval {}", (Object)adTask.getTaskId(), (Object)pieceStartTime, (Object)pieceEndTime, (Object)interval);
                float taskProgress = (float)(pieceStartTime - dataStartTime) / (float)(dataEndTime - dataStartTime);
                this.logger.debug("Task progress: {}, task id:{}, detector id:{}", (Object)Float.valueOf(taskProgress), (Object)taskId, (Object)detectorId);
                this.adTaskManager.updateTask(taskId, (Map<String, Object>)ImmutableMap.of((Object)"state", (Object)taskState, (Object)"current_piece", (Object)pieceStartTime, (Object)"task_progress", (Object)Float.valueOf(taskProgress), (Object)"init_progress", (Object)Float.valueOf(initProgress)), (ActionListener<UpdateResponse>)ActionListener.wrap(r -> this.getFeatureData(adTask, pieceStartTime, pieceEndTime, dataStartTime, dataEndTime, interval, Instant.now(), internalListener), e -> internalListener.onFailure(e)));
            }, TimeValue.timeValueSeconds((long)this.pieceIntervalSeconds.intValue()), "ad-batch-task-threadpool");
        } else {
            this.logger.info("AD task finished for detector {}, task id: {}", (Object)detectorId, (Object)taskId);
            this.adTaskCacheManager.remove(taskId, detectorId, detectorTaskId);
            this.adTaskManager.updateTask(taskId, (Map<String, Object>)ImmutableMap.of((Object)"current_piece", (Object)dataEndTime, (Object)"task_progress", (Object)Float.valueOf(1.0f), (Object)"execution_end_time", (Object)Instant.now().toEpochMilli(), (Object)"init_progress", (Object)Float.valueOf(initProgress), (Object)"state", (Object)((Object)TaskState.FINISHED)), (ActionListener<UpdateResponse>)ActionListener.wrap(r -> internalListener.onResponse((Object)"task execution done"), e -> internalListener.onFailure(e)));
        }
    }

    private void updateDetectorLevelTaskState(String detectorId, String detectorTaskId, String newState) {
        ExecutorFunction function = () -> this.adTaskManager.updateTask(detectorTaskId, (Map<String, Object>)ImmutableMap.of((Object)"state", (Object)newState), (ActionListener<UpdateResponse>)ActionListener.wrap(r -> {
            this.logger.info("Updated HC detector task: {} state as: {} for detector: {}", (Object)detectorTaskId, (Object)newState, (Object)detectorId);
            this.adTaskCacheManager.updateDetectorTaskState(detectorId, detectorTaskId, newState);
        }, e -> this.logger.error("Failed to update HC detector task: {} for detector: {}", (Object)detectorTaskId, (Object)detectorId)));
        if (this.adTaskCacheManager.detectorTaskStateExists(detectorId, detectorTaskId)) {
            if (!Objects.equals(this.adTaskCacheManager.getDetectorTaskState(detectorId, detectorTaskId), newState)) {
                function.execute();
            }
        } else if (!this.adTaskCacheManager.isHistoricalAnalysisCancelledForHC(detectorId, detectorTaskId)) {
            this.adTaskManager.getADTask(detectorTaskId, (ActionListener<Optional<ADTask>>)ActionListener.wrap(task -> {
                if (task.isPresent() && !Objects.equals(((ADTask)task.get()).getState(), newState)) {
                    function.execute();
                }
            }, exception -> this.logger.error("failed to get detector level task " + detectorTaskId, (Throwable)exception)));
        }
    }

    private float calculateInitProgress(String taskId) {
        RandomCutForest rcf = this.adTaskCacheManager.getTRcfModel(taskId).getForest();
        if (rcf == null) {
            return 0.0f;
        }
        float initProgress = (float)rcf.getTotalUpdates() / 32.0f;
        this.logger.debug("RCF total updates {} for task {}", (Object)rcf.getTotalUpdates(), (Object)taskId);
        return initProgress > 1.0f ? 1.0f : initProgress;
    }

    private void checkIfADTaskCancelledAndCleanupCache(ADTask adTask) {
        String taskId = adTask.getTaskId();
        String detectorId = adTask.getConfigId();
        String detectorTaskId = adTask.getConfigLevelTaskId();
        this.adTaskCacheManager.refreshLatestHCTaskRunTime(detectorId);
        if (adTask.getDetector().isHighCardinality() && this.adTaskCacheManager.isHCTaskCoordinatingNode(detectorId) && this.adTaskCacheManager.isHistoricalAnalysisCancelledForHC(detectorId, detectorTaskId)) {
            this.adTaskCacheManager.clearPendingEntities(detectorId);
            this.adTaskCacheManager.removeRunningEntity(detectorId, this.adTaskManager.convertEntityToString(adTask));
            throw new TaskCancelledException(this.adTaskCacheManager.getCancelReasonForHC(detectorId, detectorTaskId), this.adTaskCacheManager.getCancelledByForHC(detectorId, detectorTaskId));
        }
        if (this.adTaskCacheManager.contains(taskId) && this.adTaskCacheManager.isCancelled(taskId)) {
            this.logger.info("AD task cancelled, stop running task {}", (Object)taskId);
            String cancelReason = this.adTaskCacheManager.getCancelReason(taskId);
            String cancelledBy = this.adTaskCacheManager.getCancelledBy(taskId);
            this.adTaskCacheManager.remove(taskId, detectorId, detectorTaskId);
            if (!this.adTaskCacheManager.isHCTaskCoordinatingNode(detectorId) && ParseUtils.isNullOrEmpty(this.adTaskCacheManager.getTasksOfDetector(detectorId))) {
                this.logger.info("All AD task cancelled, cleanup historical task cache for detector {}", (Object)detectorId);
                this.adTaskCacheManager.removeHistoricalTaskCache(detectorId);
            }
            throw new TaskCancelledException(cancelReason, cancelledBy);
        }
    }
}

