/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import java.io.IOException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.forecast.model.Forecaster;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.model.Config;

public class ValidateConfigRequest
extends ActionRequest {
    private final AnalysisType context;
    private final Config config;
    private final String validationType;
    private final Integer maxSingleStreamConfigs;
    private final Integer maxHCConfigs;
    private final Integer maxFeatures;
    private final TimeValue requestTimeout;
    private final Integer maxCategoricalFields;

    public ValidateConfigRequest(StreamInput in) throws IOException {
        super(in);
        this.context = (AnalysisType)in.readEnum(AnalysisType.class);
        if (this.context.isAD()) {
            this.config = new AnomalyDetector(in);
        } else if (this.context.isForecast()) {
            this.config = new Forecaster(in);
        } else {
            throw new UnsupportedOperationException("This method is not supported");
        }
        this.validationType = in.readString();
        this.maxSingleStreamConfigs = in.readInt();
        this.maxHCConfigs = in.readInt();
        this.maxFeatures = in.readInt();
        this.requestTimeout = in.readTimeValue();
        this.maxCategoricalFields = in.readInt();
    }

    public ValidateConfigRequest(AnalysisType context, Config config, String validationType, Integer maxSingleStreamConfigs, Integer maxHCConfigs, Integer maxFeatures, TimeValue requestTimeout, Integer maxCategoricalFields) {
        this.context = context;
        this.config = config;
        this.validationType = validationType;
        this.maxSingleStreamConfigs = maxSingleStreamConfigs;
        this.maxHCConfigs = maxHCConfigs;
        this.maxFeatures = maxFeatures;
        this.requestTimeout = requestTimeout;
        this.maxCategoricalFields = maxCategoricalFields;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeEnum((Enum)this.context);
        this.config.writeTo(out);
        out.writeString(this.validationType);
        out.writeInt(this.maxSingleStreamConfigs.intValue());
        out.writeInt(this.maxHCConfigs.intValue());
        out.writeInt(this.maxFeatures.intValue());
        out.writeTimeValue(this.requestTimeout);
        out.writeInt(this.maxCategoricalFields.intValue());
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public Config getConfig() {
        return this.config;
    }

    public String getValidationType() {
        return this.validationType;
    }

    public Integer getMaxSingleEntityAnomalyDetectors() {
        return this.maxSingleStreamConfigs;
    }

    public Integer getMaxMultiEntityAnomalyDetectors() {
        return this.maxHCConfigs;
    }

    public Integer getMaxAnomalyFeatures() {
        return this.maxFeatures;
    }

    public TimeValue getRequestTimeout() {
        return this.requestTimeout;
    }

    public Integer getMaxCategoricalFields() {
        return this.maxCategoricalFields;
    }
}

