"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ModelService = void 0;
var _model = require("./utils/model");
var _constants = require("./utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/*
 *   Copyright OpenSearch Contributors
 *
 *   Licensed under the Apache License, Version 2.0 (the "License").
 *   You may not use this file except in compliance with the License.
 *   A copy of the License is located at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   or in the "license" file accompanying this file. This file is distributed
 *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *   express or implied. See the License for the specific language governing
 *   permissions and limitations under the License.
 */

const modelSortFieldMapping = {
  name: 'name.keyword',
  id: '_id'
};
class ModelService {
  static async search({
    from,
    size,
    sort,
    transport,
    ...restParams
  }) {
    const {
      body: {
        hits
      }
    } = await transport.request({
      method: 'POST',
      path: `${_constants.MODEL_BASE_API}/_search`,
      body: {
        query: (0, _model.generateModelSearchQuery)(restParams),
        from,
        size,
        ...(sort ? {
          sort: sort.map(sorting => {
            const [field, direction] = sorting.split('-');
            return {
              [modelSortFieldMapping[field] || field]: direction
            };
          })
        } : {})
      }
    });
    return {
      data: hits.hits.map(({
        _id,
        _source
      }) => ({
        id: _id,
        ..._source
      })),
      total_models: hits.total.value
    };
  }
}
exports.ModelService = ModelService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfbW9kZWwiLCJyZXF1aXJlIiwiX2NvbnN0YW50cyIsIm1vZGVsU29ydEZpZWxkTWFwcGluZyIsIm5hbWUiLCJpZCIsIk1vZGVsU2VydmljZSIsInNlYXJjaCIsImZyb20iLCJzaXplIiwic29ydCIsInRyYW5zcG9ydCIsInJlc3RQYXJhbXMiLCJib2R5IiwiaGl0cyIsInJlcXVlc3QiLCJtZXRob2QiLCJwYXRoIiwiTU9ERUxfQkFTRV9BUEkiLCJxdWVyeSIsImdlbmVyYXRlTW9kZWxTZWFyY2hRdWVyeSIsIm1hcCIsInNvcnRpbmciLCJmaWVsZCIsImRpcmVjdGlvbiIsInNwbGl0IiwiZGF0YSIsIl9pZCIsIl9zb3VyY2UiLCJ0b3RhbF9tb2RlbHMiLCJ0b3RhbCIsInZhbHVlIiwiZXhwb3J0cyJdLCJzb3VyY2VzIjpbIm1vZGVsX3NlcnZpY2UudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG4vKlxuICogICBDb3B5cmlnaHQgT3BlblNlYXJjaCBDb250cmlidXRvcnNcbiAqXG4gKiAgIExpY2Vuc2VkIHVuZGVyIHRoZSBBcGFjaGUgTGljZW5zZSwgVmVyc2lvbiAyLjAgKHRoZSBcIkxpY2Vuc2VcIikuXG4gKiAgIFlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2Ugd2l0aCB0aGUgTGljZW5zZS5cbiAqICAgQSBjb3B5IG9mIHRoZSBMaWNlbnNlIGlzIGxvY2F0ZWQgYXRcbiAqXG4gKiAgICAgICBodHRwOi8vd3d3LmFwYWNoZS5vcmcvbGljZW5zZXMvTElDRU5TRS0yLjBcbiAqXG4gKiAgIG9yIGluIHRoZSBcImxpY2Vuc2VcIiBmaWxlIGFjY29tcGFueWluZyB0aGlzIGZpbGUuIFRoaXMgZmlsZSBpcyBkaXN0cmlidXRlZFxuICogICBvbiBhbiBcIkFTIElTXCIgQkFTSVMsIFdJVEhPVVQgV0FSUkFOVElFUyBPUiBDT05ESVRJT05TIE9GIEFOWSBLSU5ELCBlaXRoZXJcbiAqICAgZXhwcmVzcyBvciBpbXBsaWVkLiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmdcbiAqICAgcGVybWlzc2lvbnMgYW5kIGxpbWl0YXRpb25zIHVuZGVyIHRoZSBMaWNlbnNlLlxuICovXG5cbmltcG9ydCB7IE9wZW5TZWFyY2hDbGllbnQgfSBmcm9tICcuLi8uLi8uLi8uLi9zcmMvY29yZS9zZXJ2ZXInO1xuaW1wb3J0IHsgTU9ERUxfU1RBVEUsIE1vZGVsU2VhcmNoU29ydCB9IGZyb20gJy4uLy4uL2NvbW1vbic7XG5cbmltcG9ydCB7IGdlbmVyYXRlTW9kZWxTZWFyY2hRdWVyeSB9IGZyb20gJy4vdXRpbHMvbW9kZWwnO1xuaW1wb3J0IHsgTU9ERUxfQkFTRV9BUEkgfSBmcm9tICcuL3V0aWxzL2NvbnN0YW50cyc7XG5cbmNvbnN0IG1vZGVsU29ydEZpZWxkTWFwcGluZzogeyBba2V5OiBzdHJpbmddOiBzdHJpbmcgfSA9IHtcbiAgbmFtZTogJ25hbWUua2V5d29yZCcsXG4gIGlkOiAnX2lkJyxcbn07XG5cbmV4cG9ydCBjbGFzcyBNb2RlbFNlcnZpY2Uge1xuICBwdWJsaWMgc3RhdGljIGFzeW5jIHNlYXJjaCh7XG4gICAgZnJvbSxcbiAgICBzaXplLFxuICAgIHNvcnQsXG4gICAgdHJhbnNwb3J0LFxuICAgIC4uLnJlc3RQYXJhbXNcbiAgfToge1xuICAgIHRyYW5zcG9ydDogT3BlblNlYXJjaENsaWVudFsndHJhbnNwb3J0J107XG4gICAgZnJvbTogbnVtYmVyO1xuICAgIHNpemU6IG51bWJlcjtcbiAgICBzb3J0PzogTW9kZWxTZWFyY2hTb3J0W107XG4gICAgc3RhdGVzPzogTU9ERUxfU1RBVEVbXTtcbiAgICBleHRyYVF1ZXJ5PzogUmVjb3JkPHN0cmluZywgYW55PjtcbiAgICBuYW1lT3JJZD86IHN0cmluZztcbiAgfSkge1xuICAgIGNvbnN0IHtcbiAgICAgIGJvZHk6IHsgaGl0cyB9LFxuICAgIH0gPSBhd2FpdCB0cmFuc3BvcnQucmVxdWVzdCh7XG4gICAgICBtZXRob2Q6ICdQT1NUJyxcbiAgICAgIHBhdGg6IGAke01PREVMX0JBU0VfQVBJfS9fc2VhcmNoYCxcbiAgICAgIGJvZHk6IHtcbiAgICAgICAgcXVlcnk6IGdlbmVyYXRlTW9kZWxTZWFyY2hRdWVyeShyZXN0UGFyYW1zKSxcbiAgICAgICAgZnJvbSxcbiAgICAgICAgc2l6ZSxcbiAgICAgICAgLi4uKHNvcnRcbiAgICAgICAgICA/IHtcbiAgICAgICAgICAgICAgc29ydDogc29ydC5tYXAoKHNvcnRpbmcpID0+IHtcbiAgICAgICAgICAgICAgICBjb25zdCBbZmllbGQsIGRpcmVjdGlvbl0gPSBzb3J0aW5nLnNwbGl0KCctJyk7XG4gICAgICAgICAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgICAgICAgIFttb2RlbFNvcnRGaWVsZE1hcHBpbmdbZmllbGRdIHx8IGZpZWxkXTogZGlyZWN0aW9uLFxuICAgICAgICAgICAgICAgIH07XG4gICAgICAgICAgICAgIH0pLFxuICAgICAgICAgICAgfVxuICAgICAgICAgIDoge30pLFxuICAgICAgfSxcbiAgICB9KTtcblxuICAgIHJldHVybiB7XG4gICAgICBkYXRhOiBoaXRzLmhpdHMubWFwKCh7IF9pZCwgX3NvdXJjZSB9KSA9PiAoe1xuICAgICAgICBpZDogX2lkLFxuICAgICAgICAuLi5fc291cmNlLFxuICAgICAgfSkpLFxuICAgICAgdG90YWxfbW9kZWxzOiBoaXRzLnRvdGFsLnZhbHVlLFxuICAgIH07XG4gIH1cbn1cbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBdUJBLElBQUFBLE1BQUEsR0FBQUMsT0FBQTtBQUNBLElBQUFDLFVBQUEsR0FBQUQsT0FBQTtBQXhCQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQVFBLE1BQU1FLHFCQUFnRCxHQUFHO0VBQ3ZEQyxJQUFJLEVBQUUsY0FBYztFQUNwQkMsRUFBRSxFQUFFO0FBQ04sQ0FBQztBQUVNLE1BQU1DLFlBQVksQ0FBQztFQUN4QixhQUFvQkMsTUFBTUEsQ0FBQztJQUN6QkMsSUFBSTtJQUNKQyxJQUFJO0lBQ0pDLElBQUk7SUFDSkMsU0FBUztJQUNULEdBQUdDO0VBU0wsQ0FBQyxFQUFFO0lBQ0QsTUFBTTtNQUNKQyxJQUFJLEVBQUU7UUFBRUM7TUFBSztJQUNmLENBQUMsR0FBRyxNQUFNSCxTQUFTLENBQUNJLE9BQU8sQ0FBQztNQUMxQkMsTUFBTSxFQUFFLE1BQU07TUFDZEMsSUFBSSxFQUFHLEdBQUVDLHlCQUFlLFVBQVM7TUFDakNMLElBQUksRUFBRTtRQUNKTSxLQUFLLEVBQUUsSUFBQUMsK0JBQXdCLEVBQUNSLFVBQVUsQ0FBQztRQUMzQ0osSUFBSTtRQUNKQyxJQUFJO1FBQ0osSUFBSUMsSUFBSSxHQUNKO1VBQ0VBLElBQUksRUFBRUEsSUFBSSxDQUFDVyxHQUFHLENBQUVDLE9BQU8sSUFBSztZQUMxQixNQUFNLENBQUNDLEtBQUssRUFBRUMsU0FBUyxDQUFDLEdBQUdGLE9BQU8sQ0FBQ0csS0FBSyxDQUFDLEdBQUcsQ0FBQztZQUM3QyxPQUFPO2NBQ0wsQ0FBQ3RCLHFCQUFxQixDQUFDb0IsS0FBSyxDQUFDLElBQUlBLEtBQUssR0FBR0M7WUFDM0MsQ0FBQztVQUNILENBQUM7UUFDSCxDQUFDLEdBQ0QsQ0FBQyxDQUFDO01BQ1I7SUFDRixDQUFDLENBQUM7SUFFRixPQUFPO01BQ0xFLElBQUksRUFBRVosSUFBSSxDQUFDQSxJQUFJLENBQUNPLEdBQUcsQ0FBQyxDQUFDO1FBQUVNLEdBQUc7UUFBRUM7TUFBUSxDQUFDLE1BQU07UUFDekN2QixFQUFFLEVBQUVzQixHQUFHO1FBQ1AsR0FBR0M7TUFDTCxDQUFDLENBQUMsQ0FBQztNQUNIQyxZQUFZLEVBQUVmLElBQUksQ0FBQ2dCLEtBQUssQ0FBQ0M7SUFDM0IsQ0FBQztFQUNIO0FBQ0Y7QUFBQ0MsT0FBQSxDQUFBMUIsWUFBQSxHQUFBQSxZQUFBIn0=