/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * sign(i64vec2(-15l, -7l)) => i64vec2(-1l, -1l)
 * sign(i64vec2(0l, 7l)) => i64vec2(0l, 1l)
 * sign(i64vec2(15l, -15l)) => i64vec2(1l, -1l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal(sign(i64vec2(-15l, -7l)), i64vec2(-1l, -1l))) ? 1 : -1] array0;
  float[all(equal(sign(i64vec2(0l, 7l)), i64vec2(0l, 1l))) ? 1 : -1] array1;
  float[all(equal(sign(i64vec2(15l, -15l)), i64vec2(1l, -1l))) ? 1 : -1] array2;
  gl_Position = vec4(array0.length() + array1.length() + array2.length());
}
