/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.merlin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.ScheduleFrom;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.FileHelper;
import net.sf.mpxj.common.InputStreamHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.merlin.Row;
import net.sf.mpxj.merlin.SqliteResultSetRow;
import net.sf.mpxj.reader.ProjectReader;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class MerlinReader
implements ProjectReader {
    private ProjectFile m_project;
    private EventManager m_eventManager;
    private Integer m_projectID = 1;
    private Connection m_connection;
    private PreparedStatement m_ps;
    private ResultSet m_rs;
    private Map<String, Integer> m_meta = new HashMap<String, Integer>();
    private List<ProjectListener> m_projectListeners;
    private DocumentBuilder m_documentBuilder;
    private DateFormat m_calendarTimeFormat = new SimpleDateFormat("HH:mm:ss");
    private XPathExpression m_dayTimeIntervals;

    @Override
    public void addProjectListener(ProjectListener projectListener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(projectListener);
    }

    @Override
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        File file = null;
        try {
            file = InputStreamHelper.writeStreamToTempFile(inputStream, ".sqlite");
            ProjectFile projectFile = this.read(file);
            return projectFile;
        }
        catch (IOException iOException) {
            throw new MPXJException("", iOException);
        }
        finally {
            FileHelper.deleteQuietly(file);
        }
    }

    @Override
    public ProjectFile read(String string) throws MPXJException {
        return this.read(new File(string));
    }

    @Override
    public ProjectFile read(File file) throws MPXJException {
        File file2 = file.isDirectory() ? new File(file, "state.sql") : file;
        return this.readFile(file2);
    }

    private ProjectFile readFile(File file) throws MPXJException {
        throw new MPXJException("Not implemented");
    }

    private ProjectFile read() throws Exception {
        this.m_project = new ProjectFile();
        this.m_eventManager = this.m_project.getEventManager();
        ProjectConfig projectConfig = this.m_project.getProjectConfig();
        projectConfig.setAutoCalendarUniqueID(false);
        projectConfig.setAutoTaskUniqueID(false);
        projectConfig.setAutoResourceUniqueID(false);
        this.m_project.getProjectProperties().setFileApplication("Merlin");
        this.m_project.getProjectProperties().setFileType("SQLITE");
        this.m_eventManager.addProjectListeners(this.m_projectListeners);
        this.processProject();
        this.processCalendars();
        this.processResources();
        this.processTasks();
        this.processAssignments();
        this.processDependencies();
        return this.m_project;
    }

    private void processProject() throws SQLException {
        ProjectProperties projectProperties = this.m_project.getProjectProperties();
        Row row = this.getRows("select * from zproject where z_pk=?", this.m_projectID).get(0);
        projectProperties.setWeekStartDay(Day.getInstance(row.getInt("ZFIRSTDAYOFWEEK") + 1));
        projectProperties.setScheduleFrom(row.getInt("ZSCHEDULINGDIRECTION") == 1 ? ScheduleFrom.START : ScheduleFrom.FINISH);
        projectProperties.setMinutesPerDay(row.getInt("ZHOURSPERDAY") * 60);
        projectProperties.setDaysPerMonth(row.getInteger("ZDAYSPERMONTH"));
        projectProperties.setMinutesPerWeek(row.getInt("ZHOURSPERWEEK") * 60);
        projectProperties.setStatusDate(row.getTimestamp("ZGIVENSTATUSDATE"));
        projectProperties.setCurrencySymbol(row.getString("ZCURRENCYSYMBOL"));
        projectProperties.setName(row.getString("ZTITLE"));
        projectProperties.setUniqueID(row.getUUID("ZUNIQUEID").toString());
    }

    private void processCalendars() throws Exception {
        List<Row> list = this.getRows("select * from zcalendar where zproject=?", this.m_projectID);
        for (Row row : list) {
            ProjectCalendar projectCalendar = this.m_project.addCalendar();
            projectCalendar.setUniqueID(row.getInteger("Z_PK"));
            projectCalendar.setName(row.getString("ZTITLE"));
            this.processDays(projectCalendar);
            this.processExceptions(projectCalendar);
            this.m_eventManager.fireCalendarReadEvent(projectCalendar);
        }
    }

    private void processDays(ProjectCalendar projectCalendar) throws Exception {
        for (Day day : Day.values()) {
            projectCalendar.setWorkingDay(day, false);
        }
        List<Row> list = this.getRows("select * from zcalendarrule where zcalendar1=? and z_ent=13", projectCalendar.getUniqueID());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Day day;
            Row row = (Row)iterator.next();
            day = row.getDay("ZWEEKDAY");
            String string = row.getString("ZTIMEINTERVALS");
            if (string == null) {
                projectCalendar.setWorkingDay(day, false);
                continue;
            }
            ProjectCalendarHours projectCalendarHours = projectCalendar.addCalendarHours(day);
            NodeList nodeList = this.getNodeList(string, this.m_dayTimeIntervals);
            projectCalendar.setWorkingDay(day, nodeList.getLength() > 0);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
                Date date = this.m_calendarTimeFormat.parse(namedNodeMap.getNamedItem("startTime").getTextContent());
                Date date2 = this.m_calendarTimeFormat.parse(namedNodeMap.getNamedItem("endTime").getTextContent());
                if (date.getTime() >= date2.getTime()) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date2);
                    calendar.add(6, 1);
                    date2 = calendar.getTime();
                }
                projectCalendarHours.addRange(new DateRange(date, date2));
            }
        }
    }

    private void processExceptions(ProjectCalendar projectCalendar) throws Exception {
        List<Row> list = this.getRows("select * from zcalendarrule where zcalendar=? and z_ent=12", projectCalendar.getUniqueID());
        for (Row row : list) {
            Date date = row.getDate("ZSTARTDAY");
            Date date2 = row.getDate("ZENDDAY");
            ProjectCalendarException projectCalendarException = projectCalendar.addCalendarException(date, date2);
            String string = row.getString("ZTIMEINTERVALS");
            if (string == null) continue;
            NodeList nodeList = this.getNodeList(string, this.m_dayTimeIntervals);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
                Date date3 = this.m_calendarTimeFormat.parse(namedNodeMap.getNamedItem("startTime").getTextContent());
                Date date4 = this.m_calendarTimeFormat.parse(namedNodeMap.getNamedItem("endTime").getTextContent());
                if (date3.getTime() >= date4.getTime()) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date4);
                    calendar.add(6, 1);
                    date4 = calendar.getTime();
                }
                projectCalendarException.addRange(new DateRange(date3, date4));
            }
        }
    }

    private void processResources() throws SQLException {
        List<Row> list = this.getRows("select * from zresource where zproject=? order by zorderinproject", this.m_projectID);
        for (Row row : list) {
            ProjectCalendar projectCalendar;
            Integer n;
            Resource resource = this.m_project.addResource();
            resource.setUniqueID(row.getInteger("Z_PK"));
            resource.setEmailAddress(row.getString("ZEMAIL"));
            resource.setInitials(row.getString("ZINITIALS"));
            resource.setName(row.getString("ZTITLE_"));
            resource.setGUID(row.getUUID("ZUNIQUEID"));
            resource.setType(row.getResourceType("ZTYPE"));
            resource.setMaterialLabel(row.getString("ZMATERIALUNIT"));
            if (resource.getType() == ResourceType.WORK) {
                resource.setMaxUnits(NumberHelper.getDouble(row.getDouble("ZAVAILABLEUNITS_")) * 100.0);
            }
            if ((n = row.getInteger("ZRESOURCECALENDAR")) != null && (projectCalendar = this.m_project.getCalendarByUniqueID(n)) != null) {
                projectCalendar.setName(resource.getName());
                resource.setResourceCalendar(projectCalendar);
            }
            this.m_eventManager.fireResourceReadEvent(resource);
        }
    }

    private void processTasks() throws SQLException {
        List<Row> list = this.getRows("select * from zscheduleitem where zproject=? and zparentactivity_ is null and z_ent=45 order by zorderinparentactivity", this.m_projectID);
        for (Row row : list) {
            Task task = this.m_project.addTask();
            this.populateTask(row, task);
            this.processChildTasks(task);
        }
    }

    private void processChildTasks(Task task) throws SQLException {
        List<Row> list = this.getRows("select * from zscheduleitem where zparentactivity_=? and z_ent=45 order by zorderinparentactivity", task.getUniqueID());
        for (Row row : list) {
            Task task2 = task.addTask();
            this.populateTask(row, task2);
            this.processChildTasks(task2);
        }
    }

    private void populateTask(Row row, Task task) {
        ProjectCalendar projectCalendar;
        task.setUniqueID(row.getInteger("Z_PK"));
        task.setName(row.getString("ZTITLE"));
        task.setPriority(Priority.getInstance(row.getInt("ZPRIORITY")));
        task.setMilestone(row.getBoolean("ZISMILESTONE"));
        task.setActualFinish(row.getTimestamp("ZGIVENACTUALENDDATE_"));
        task.setActualStart(row.getTimestamp("ZGIVENACTUALSTARTDATE_"));
        task.setNotes(row.getString("ZOBJECTDESCRIPTION"));
        task.setDuration(row.getDuration("ZGIVENDURATION_"));
        task.setOvertimeWork(row.getWork("ZGIVENWORKOVERTIME_"));
        task.setWork(row.getWork("ZGIVENWORK_"));
        task.setLevelingDelay(row.getDuration("ZLEVELINGDELAY_"));
        task.setActualOvertimeWork(row.getWork("ZGIVENACTUALWORKOVERTIME_"));
        task.setActualWork(row.getWork("ZGIVENACTUALWORK_"));
        task.setRemainingWork(row.getWork("ZGIVENACTUALWORK_"));
        task.setGUID(row.getUUID("ZUNIQUEID"));
        Integer n = row.getInteger("ZGIVENCALENDAR");
        if (n != null && (projectCalendar = this.m_project.getCalendarByUniqueID(n)) != null) {
            task.setCalendar(projectCalendar);
        }
        this.populateConstraints(row, task);
        this.m_eventManager.fireTaskReadEvent(task);
    }

    private void populateConstraints(Row row, Task task) {
        Date date = row.getTimestamp("ZGIVENENDDATEMAX_");
        Date date2 = row.getTimestamp("ZGIVENENDDATEMIN_");
        Date date3 = row.getTimestamp("ZGIVENSTARTDATEMAX_");
        Date date4 = row.getTimestamp("ZGIVENSTARTDATEMIN_");
        ConstraintType constraintType = null;
        Date date5 = null;
        if (date != null) {
            constraintType = ConstraintType.FINISH_NO_LATER_THAN;
            date5 = date;
        }
        if (date2 != null) {
            constraintType = ConstraintType.FINISH_NO_EARLIER_THAN;
            date5 = date2;
        }
        if (date2 != null && date2 == date) {
            constraintType = ConstraintType.MUST_FINISH_ON;
            date5 = date2;
        }
        if (date3 != null) {
            constraintType = ConstraintType.START_NO_LATER_THAN;
            date5 = date3;
        }
        if (date4 != null) {
            constraintType = ConstraintType.START_NO_EARLIER_THAN;
            date5 = date4;
        }
        if (date4 != null && date4 == date) {
            constraintType = ConstraintType.MUST_START_ON;
            date5 = date2;
        }
        task.setConstraintType(constraintType);
        task.setConstraintDate(date5);
    }

    private void processAssignments() throws SQLException {
        List<Row> list = this.getRows("select * from zscheduleitem where zproject=? and z_ent=47 order by zorderinactivity", this.m_projectID);
        for (Row row : list) {
            Task task = this.m_project.getTaskByUniqueID(row.getInteger("ZACTIVITY_"));
            Resource resource = this.m_project.getResourceByUniqueID(row.getInteger("ZRESOURCE"));
            if (task == null || resource == null) continue;
            ResourceAssignment resourceAssignment = task.addResourceAssignment(resource);
            resourceAssignment.setGUID(row.getUUID("ZUNIQUEID"));
            resourceAssignment.setActualFinish(row.getTimestamp("ZGIVENACTUALENDDATE_"));
            resourceAssignment.setActualStart(row.getTimestamp("ZGIVENACTUALSTARTDATE_"));
            resourceAssignment.setWork(this.assignmentDuration(task, row.getWork("ZGIVENWORK_")));
            resourceAssignment.setOvertimeWork(this.assignmentDuration(task, row.getWork("ZGIVENWORKOVERTIME_")));
            resourceAssignment.setActualWork(this.assignmentDuration(task, row.getWork("ZGIVENACTUALWORK_")));
            resourceAssignment.setActualOvertimeWork(this.assignmentDuration(task, row.getWork("ZGIVENACTUALWORKOVERTIME_")));
            resourceAssignment.setRemainingWork(this.assignmentDuration(task, row.getWork("ZGIVENREMAININGWORK_")));
            resourceAssignment.setLevelingDelay(row.getDuration("ZLEVELINGDELAY_"));
            if (resourceAssignment.getRemainingWork() == null) {
                resourceAssignment.setRemainingWork(resourceAssignment.getWork());
            }
            if (resource.getType() != ResourceType.WORK) continue;
            resourceAssignment.setUnits(NumberHelper.getDouble(row.getDouble("ZRESOURCEUNITS_")) * 100.0);
        }
    }

    private Duration assignmentDuration(Task task, Duration duration) {
        Duration duration2;
        Duration duration3 = duration;
        if (duration3 != null && duration3.getUnits() == TimeUnit.PERCENT && (duration2 = task.getWork()) != null) {
            duration3 = Duration.getInstance(duration2.getDuration() * duration3.getDuration(), duration2.getUnits());
        }
        return duration3;
    }

    private void processDependencies() throws SQLException {
        List<Row> list = this.getRows("select * from zdependency where zproject=?", this.m_projectID);
        for (Row row : list) {
            Task task = this.m_project.getTaskByUniqueID(row.getInteger("ZNEXTACTIVITY_"));
            Task task2 = this.m_project.getTaskByUniqueID(row.getInteger("ZPREVIOUSACTIVITY_"));
            Duration duration = row.getDuration("ZLAG_");
            RelationType relationType = row.getRelationType("ZTYPE");
            task.addPredecessor(task2, relationType, duration);
        }
    }

    private List<Row> getRows(String string, Integer n) throws SQLException {
        LinkedList<Row> linkedList = new LinkedList<Row>();
        this.m_ps = this.m_connection.prepareStatement(string);
        this.m_ps.setInt(1, NumberHelper.getInt(n));
        this.m_rs = this.m_ps.executeQuery();
        this.populateMetaData();
        while (this.m_rs.next()) {
            linkedList.add(new SqliteResultSetRow(this.m_rs, this.m_meta));
        }
        return linkedList;
    }

    private void populateMetaData() throws SQLException {
        this.m_meta.clear();
        ResultSetMetaData resultSetMetaData = this.m_rs.getMetaData();
        int n = resultSetMetaData.getColumnCount() + 1;
        for (int i = 1; i < n; ++i) {
            String string = resultSetMetaData.getColumnName(i);
            Integer n2 = resultSetMetaData.getColumnType(i);
            this.m_meta.put(string, n2);
        }
    }

    private NodeList getNodeList(String string, XPathExpression xPathExpression) throws Exception {
        Document document = this.m_documentBuilder.parse(new InputSource(new StringReader(string)));
        return (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
    }
}

