# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.nsx.trust_management.oidc_uris.action.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class ConfigureWs1bOidcEndpoint(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.trust_management.oidc_uris.action.configure_ws1b_oidc_endpoint'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ConfigureWs1bOidcEndpointStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self,
               ws1b_oidc_endpoint_create_request,
               ):
        """
        Configures NSX to use VC/WS1B for OIDC authentication. Using the
        provided JWT token, NSX will create an OAuth app on VC/WS1B, creating a
        client ID and client secret. NSX will subsequently use that client
        ID/secret to authenticate user, and will support single sign-on across
        VMware products.

        :type  ws1b_oidc_endpoint_create_request: :class:`com.vmware.nsx.model_client.Ws1bOidcEndpointCreateRequest`
        :param ws1b_oidc_endpoint_create_request: (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('create',
                            {
                            'ws1b_oidc_endpoint_create_request': ws1b_oidc_endpoint_create_request,
                            })
class RemoveWs1bOidcEndpoint(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.nsx.trust_management.oidc_uris.action.remove_ws1b_oidc_endpoint'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _RemoveWs1bOidcEndpointStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self,
               ws1b_oidc_endpoint_removal_request,
               ):
        """
        Removes the OAuth app on VC/W1B and deletes the associated OIDC
        endpoint from NSX.

        :type  ws1b_oidc_endpoint_removal_request: :class:`com.vmware.nsx.model_client.Ws1bOidcEndpointRemovalRequest`
        :param ws1b_oidc_endpoint_removal_request: (required)
        :rtype: :class:`com.vmware.nsx.model_client.Ws1bOidcEndpointRemovalResponse`
        :return: com.vmware.nsx.model.Ws1bOidcEndpointRemovalResponse
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request, Precondition Failed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            Service Unavailable
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal Server Error
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Not Found
        """
        return self._invoke('create',
                            {
                            'ws1b_oidc_endpoint_removal_request': ws1b_oidc_endpoint_removal_request,
                            })
class _ConfigureWs1bOidcEndpointStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for create operation
        create_input_type = type.StructType('operation-input', {
            'ws1b_oidc_endpoint_create_request': type.ReferenceType('com.vmware.nsx.model_client', 'Ws1bOidcEndpointCreateRequest'),
        })
        create_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        create_input_value_validator_list = [
        ]
        create_output_validator_list = [
        ]
        create_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/trust-management/oidc-uris/action/configure-ws1b-oidc-endpoint',
            request_body_parameter='ws1b_oidc_endpoint_create_request',
            path_variables={
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'create': {
                'input_type': create_input_type,
                'output_type': type.VoidType(),
                'errors': create_error_dict,
                'input_value_validator_list': create_input_value_validator_list,
                'output_validator_list': create_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'create': create_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.trust_management.oidc_uris.action.configure_ws1b_oidc_endpoint',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _RemoveWs1bOidcEndpointStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for create operation
        create_input_type = type.StructType('operation-input', {
            'ws1b_oidc_endpoint_removal_request': type.ReferenceType('com.vmware.nsx.model_client', 'Ws1bOidcEndpointRemovalRequest'),
        })
        create_error_dict = {
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        create_input_value_validator_list = [
        ]
        create_output_validator_list = [
        ]
        create_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/api/v1/trust-management/oidc-uris/action/remove-ws1b-oidc-endpoint',
            request_body_parameter='ws1b_oidc_endpoint_removal_request',
            path_variables={
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'create': {
                'input_type': create_input_type,
                'output_type': type.ReferenceType('com.vmware.nsx.model_client', 'Ws1bOidcEndpointRemovalResponse'),
                'errors': create_error_dict,
                'input_value_validator_list': create_input_value_validator_list,
                'output_validator_list': create_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'create': create_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.nsx.trust_management.oidc_uris.action.remove_ws1b_oidc_endpoint',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'ConfigureWs1bOidcEndpoint': ConfigureWs1bOidcEndpoint,
        'RemoveWs1bOidcEndpoint': RemoveWs1bOidcEndpoint,
    }

