/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.config.delegate;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.config.delegate.Delegate;
import de.rub.nds.tlsattacker.core.connection.OutboundConnection;

public class ProxyDelegate
extends Delegate {
    @Parameter(names={"-proxyData"}, description="Specify the host and port for data used in the proxy. Syntax: localhost:4444")
    private String proxyData = "localhost:4444";
    @Parameter(names={"-proxyControl"}, description="Specify the host and port for control messafes used in the proxy. Syntax: localhost:5555")
    private String proxyControl = "localhost:5555";

    @Override
    public void applyDelegate(Config config) {
        OutboundConnection con = config.getDefaultClientConnection();
        if (con == null) {
            con = new OutboundConnection();
            config.setDefaultClientConnection(con);
        }
        if (this.proxyData != null) {
            String[] parsedProxyData = this.proxyData.split(":");
            switch (parsedProxyData.length) {
                case 1: {
                    con.setProxyDataHostname(this.proxyData);
                    break;
                }
                case 2: {
                    con.setProxyDataHostname(parsedProxyData[0]);
                    con.setProxyDataPort(this.parsePort(parsedProxyData[1]));
                    break;
                }
                default: {
                    throw new ParameterException("Could not parse provided proxyData: " + this.proxyData);
                }
            }
        }
        if (this.proxyControl != null) {
            String[] parsedProxyControl = this.proxyControl.split(":");
            switch (parsedProxyControl.length) {
                case 1: {
                    con.setProxyControlHostname(this.proxyControl);
                    break;
                }
                case 2: {
                    con.setProxyControlHostname(parsedProxyControl[0]);
                    con.setProxyControlPort(this.parsePort(parsedProxyControl[1]));
                    break;
                }
                default: {
                    throw new ParameterException("Could not parse provided proxyControl: " + this.proxyControl);
                }
            }
        }
    }

    private int parsePort(String portStr) {
        int port = Integer.parseInt(portStr);
        if (port < 0 || port > 65535) {
            throw new ParameterException("port must be in interval [0,65535], but is " + port);
        }
        return port;
    }
}

