/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.protocol.handler.DtlsHandshakeMessageFragmentHandler;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class DtlsHandshakeMessageFragment
extends HandshakeMessage {
    @ModifiableVariableProperty
    private ModifiableByteArray content;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.COUNT)
    private ModifiableInteger messageSeq = null;
    @ModifiableVariableProperty
    private ModifiableInteger fragmentOffset = null;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger fragmentLength = null;
    private ModifiableInteger epoch = null;
    private byte[] fragmentContentConfig = new byte[0];
    private int messageSequenceConfig = 0;
    private int offsetConfig = 0;
    private int handshakeMessageLengthConfig = 0;

    public DtlsHandshakeMessageFragment() {
        super(HandshakeMessageType.UNKNOWN);
        this.IS_INCLUDE_IN_DIGEST_DEFAULT = false;
        this.ADJUST_CONTEXT_DEFAULT = false;
    }

    public DtlsHandshakeMessageFragment(HandshakeMessageType handshakeMessageType, byte[] fragmentContentConfig, int messageSequenceConfig, int offsetConfig, int handshakeMessageLengthConfig) {
        super(handshakeMessageType);
        this.IS_INCLUDE_IN_DIGEST_DEFAULT = false;
        this.ADJUST_CONTEXT_DEFAULT = false;
        this.fragmentContentConfig = fragmentContentConfig;
        this.messageSequenceConfig = messageSequenceConfig;
        this.offsetConfig = offsetConfig;
        this.handshakeMessageLengthConfig = handshakeMessageLengthConfig;
    }

    public DtlsHandshakeMessageFragment(Config tlsConfig) {
        super(tlsConfig, HandshakeMessageType.UNKNOWN);
        this.IS_INCLUDE_IN_DIGEST_DEFAULT = false;
        this.ADJUST_CONTEXT_DEFAULT = false;
    }

    public DtlsHandshakeMessageFragment(HandshakeMessageType handshakeMessageType) {
        super(handshakeMessageType);
        this.IS_INCLUDE_IN_DIGEST_DEFAULT = false;
        this.ADJUST_CONTEXT_DEFAULT = false;
    }

    @Override
    public DtlsHandshakeMessageFragmentHandler getHandler(TlsContext context) {
        return new DtlsHandshakeMessageFragmentHandler(context);
    }

    public byte[] getFragmentContentConfig() {
        return this.fragmentContentConfig;
    }

    public void setFragmentContentConfig(byte[] fragmentContentConfig) {
        this.fragmentContentConfig = fragmentContentConfig;
    }

    public int getMessageSequenceConfig() {
        return this.messageSequenceConfig;
    }

    public void setMessageSequenceConfig(int messageSequenceConfig) {
        this.messageSequenceConfig = messageSequenceConfig;
    }

    public int getOffsetConfig() {
        return this.offsetConfig;
    }

    public void setOffsetConfig(int offsetConfig) {
        this.offsetConfig = offsetConfig;
    }

    public int getHandshakeMessageLengthConfig() {
        return this.handshakeMessageLengthConfig;
    }

    public void setHandshakeMessageLengthConfig(int handshakeMessageLengthConfig) {
        this.handshakeMessageLengthConfig = handshakeMessageLengthConfig;
    }

    public ModifiableByteArray getContent() {
        return this.content;
    }

    public void setContent(ModifiableByteArray content) {
        this.content = content;
    }

    public void setContent(byte[] content) {
        this.content = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.content, (byte[])content);
    }

    public ModifiableInteger getMessageSeq() {
        return this.messageSeq;
    }

    public ModifiableInteger getFragmentOffset() {
        return this.fragmentOffset;
    }

    public ModifiableInteger getFragmentLength() {
        return this.fragmentLength;
    }

    public void setMessageSeq(int messageSeq) {
        this.messageSeq = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.messageSeq, (Integer)messageSeq);
    }

    public void setMessageSeq(ModifiableInteger messageSeq) {
        this.messageSeq = messageSeq;
    }

    public void setFragmentOffset(int fragmentOffset) {
        this.fragmentOffset = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.fragmentOffset, (Integer)fragmentOffset);
    }

    public void setFragmentOffset(ModifiableInteger fragmentOffset) {
        this.fragmentOffset = fragmentOffset;
    }

    public void setFragmentLength(int fragmentLength) {
        this.fragmentLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.fragmentLength, (Integer)fragmentLength);
    }

    public void setFragmentLength(ModifiableInteger fragmentLength) {
        this.fragmentLength = fragmentLength;
    }

    public ModifiableInteger getEpoch() {
        return this.epoch;
    }

    public void setEpoch(ModifiableInteger epoch) {
        this.epoch = epoch;
    }

    public void setEpoch(int epoch) {
        this.epoch = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.epoch, (Integer)epoch);
    }

    @Override
    public String toCompactString() {
        return this.getHandshakeMessageType().name().toUpperCase() + "_DTLS_FRAGMENT";
    }
}

