/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import java.util.LinkedHashSet;
import java.util.Set;
import nu.validator.datatype.AbstractDatatype;
import nu.validator.datatype.CssNumberToken;
import nu.validator.datatype.MediaCondition;
import org.relaxng.datatype.DatatypeException;

public class SourceSizeList
extends AbstractDatatype {
    private static final int CLIP_LIMIT = 25;
    private static final Set<String> LENGTH_UNITS = new LinkedHashSet<String>();
    private static final StringBuilder VALID_UNITS = new StringBuilder();
    private static final Set<String> FUNCTION_NAMES;
    private static final StringBuilder VALID_FUNCTION_NAMES;
    private static final CssNumberToken CSS_NUMBER_TOKEN;
    private static final MediaCondition MEDIA_CONDITION;
    public static final SourceSizeList THE_INSTANCE;

    protected SourceSizeList() {
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        String currentChunk;
        if (literal.length() == 0) {
            this.err("Must not be empty.");
        }
        int offset = 0;
        boolean isFirst = true;
        StringBuilder unparsedSize = new StringBuilder();
        StringBuilder extract = new StringBuilder();
        for (int i = 0; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            extract.append(c);
            if (',' != c) continue;
            currentChunk = literal.subSequence(offset, i).toString();
            this.checkForInvalidComments(currentChunk, extract);
            unparsedSize.append(currentChunk);
            unparsedSize = this.removeComments(unparsedSize, extract);
            this.checkSize(unparsedSize, literal, extract, isFirst, false);
            isFirst = false;
            unparsedSize.setLength(0);
            offset = i + 1;
        }
        currentChunk = literal.subSequence(offset, literal.length()).toString();
        this.checkForInvalidComments(currentChunk, extract);
        unparsedSize.append(currentChunk);
        unparsedSize = this.removeComments(unparsedSize, extract);
        this.checkSize(unparsedSize, literal, extract, isFirst, true);
    }

    private void checkSize(StringBuilder unparsedSize, CharSequence literal, StringBuilder extract, boolean isFirst, boolean isLast) throws DatatypeException {
        this.trimWhitespace(unparsedSize);
        if (unparsedSize.length() == 0) {
            this.errEmpty(isFirst, isLast, extract);
            return;
        }
        if (')' == unparsedSize.charAt(unparsedSize.length() - 1)) {
            this.checkFunction(unparsedSize, extract, isLast);
            return;
        }
        int sizeValueStart = this.lastSpaceIndex(unparsedSize);
        String size = unparsedSize.substring(this.lastSpaceIndex(unparsedSize), unparsedSize.length());
        try {
            if (Float.parseFloat(size) == 0.0f) {
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String units = this.getUnits(size);
        String num = size.substring(0, size.length() - units.length());
        boolean sizeIsLessThanZero = false;
        try {
            CSS_NUMBER_TOKEN.checkValid(num);
            if (Float.parseFloat(num) < 0.0f) {
                sizeIsLessThanZero = true;
            }
        }
        catch (DatatypeException e) {
            this.errFromOtherDatatype(e.getMessage(), extract);
        }
        catch (NumberFormatException e) {
            this.errNotNumber(num, extract);
        }
        if (sizeIsLessThanZero) {
            this.errNotPositive(size, extract);
        }
        if (!LENGTH_UNITS.contains(units)) {
            this.errNotUnits(units, extract);
        }
        unparsedSize.setLength(sizeValueStart);
        this.trimTrailingWhitespace(unparsedSize);
        if (unparsedSize.length() == 0) {
            if (!isLast) {
                this.errNoMediaCondition(unparsedSize, extract);
            }
            return;
        }
        try {
            MEDIA_CONDITION.checkValid(unparsedSize);
        }
        catch (DatatypeException e) {
            this.errFromOtherDatatype(e.getMessage(), extract);
        }
    }

    private void checkFunction(StringBuilder sb, CharSequence extract, boolean isLast) throws DatatypeException {
        int firstParenPosition = sb.length() - 1;
        int unMatchedParenCount = 1;
        while (unMatchedParenCount > 0) {
            char c;
            if (firstParenPosition == 0) {
                this.errMismatchedParens(sb, extract);
            }
            if ('(' == (c = sb.charAt(--firstParenPosition))) {
                --unMatchedParenCount;
                continue;
            }
            if (')' != c) continue;
            ++unMatchedParenCount;
        }
        String functionName = this.extractFunctionNameFromTail(sb.subSequence(0, firstParenPosition)).toString();
        int nameStartPosition = firstParenPosition - functionName.length();
        if (functionName.isEmpty()) {
            this.errNotFunctionName("", extract);
        } else if (!isLast && nameStartPosition == 0) {
            this.errNoMediaCondition(sb, extract);
        } else if (nameStartPosition != 0 && !this.isWhitespace(sb.charAt(nameStartPosition - 1))) {
            this.errNoWhitespaceBeforeFunction(extract);
        } else if (!FUNCTION_NAMES.contains(SourceSizeList.toAsciiLowerCase(functionName))) {
            this.errNotFunctionName(functionName, extract);
        }
    }

    private CharSequence extractFunctionNameFromTail(CharSequence sequence) {
        for (int i = sequence.length() - 1; i >= 0; --i) {
            char c = sequence.charAt(i);
            if (!this.isWhitespace(c) && c != ')') continue;
            return sequence.subSequence(i + 1, sequence.length());
        }
        return sequence;
    }

    private void checkForInvalidComments(String currentChunk, StringBuilder extract) throws DatatypeException {
        if (currentChunk.contains("+/")) {
            this.errNotNumber("+/", extract);
        }
        if (currentChunk.contains("-/")) {
            this.errNotNumber("-/", extract);
        }
        for (String units : LENGTH_UNITS) {
            if (!currentChunk.contains("/" + units)) continue;
            this.errNotUnits("/" + units, extract);
        }
    }

    private StringBuilder removeComments(StringBuilder sb, CharSequence extract) throws DatatypeException {
        if (sb.indexOf("/*") == -1) {
            return sb;
        }
        StringBuilder sb2 = new StringBuilder();
        State state = State.IN_SIZE;
        block6: for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            switch (state) {
                case IN_SIZE: {
                    if ('/' == sb.charAt(i)) {
                        sb2.append('/');
                        state = State.AFTER_SLASH;
                        continue block6;
                    }
                    sb2.append(c);
                    continue block6;
                }
                case AFTER_SLASH: {
                    if ('*' == sb.charAt(i)) {
                        sb2.setLength(sb2.length() - 1);
                        state = State.IN_COMMENT;
                        continue block6;
                    }
                    sb2.append(c);
                    continue block6;
                }
                case IN_COMMENT: {
                    if ('*' != sb.charAt(i)) continue block6;
                    state = State.IN_COMMENT_AFTER_ASTERISK;
                    continue block6;
                }
                case IN_COMMENT_AFTER_ASTERISK: {
                    if ('/' != sb.charAt(i)) continue block6;
                    state = State.IN_SIZE;
                    continue block6;
                }
            }
        }
        if (state == State.IN_COMMENT || state == State.IN_COMMENT_AFTER_ASTERISK) {
            this.trimWhitespace(sb);
            this.errUnclosedComment(sb, extract);
        }
        return sb2;
    }

    private int lastSpaceIndex(StringBuilder sb) {
        for (int i = sb.length(); i > 0; --i) {
            char c = sb.charAt(i - 1);
            if (!this.isWhitespace(c)) continue;
            return i;
        }
        return 0;
    }

    private void trimWhitespace(StringBuilder sb) {
        this.trimTrailingWhitespace(sb);
        this.trimLeadingWhitespace(sb);
    }

    private void trimTrailingWhitespace(StringBuilder sb) {
        for (int i = sb.length(); i > 0; --i) {
            if (!this.isWhitespace(sb.charAt(i - 1))) {
                return;
            }
            sb.setLength(i - 1);
        }
    }

    private void trimLeadingWhitespace(StringBuilder sb) {
        for (int i = 0; i < sb.length(); ++i) {
            if (this.isWhitespace(sb.charAt(i))) continue;
            sb.delete(0, i);
            return;
        }
    }

    private String getUnits(String val) {
        for (int i = val.length(); i > 0; --i) {
            char c = val.charAt(i - 1);
            if (c < '0' || c > '9') continue;
            return val.substring(i, val.length());
        }
        return "";
    }

    private void err(String message) throws DatatypeException {
        throw this.newDatatypeException(message);
    }

    private void errFromOtherDatatype(CharSequence msg, CharSequence extract) throws DatatypeException {
        this.err(msg.subSequence(0, msg.length() - 1) + " at " + this.clip(extract) + ".");
    }

    private void errEmpty(boolean isFirst, boolean isLast, CharSequence extract) throws DatatypeException {
        if (isFirst) {
            if (isLast) {
                this.err("Must contain one or more source sizes.");
            } else {
                this.err("Starts with empty source size.");
            }
        } else {
            this.err("Empty source size at " + this.clip(extract) + ".");
        }
    }

    private void errNoMediaCondition(CharSequence sourceSize, CharSequence extract) throws DatatypeException {
        this.err("Expected media condition before " + this.code(sourceSize) + " at " + this.clip(extract) + ".");
    }

    private void errNotPositive(CharSequence size, CharSequence extract) throws DatatypeException {
        this.err("Expected positive size value but found " + this.code(size) + " at " + this.clip(extract) + ".");
    }

    private void errNotNumber(CharSequence num, CharSequence extract) throws DatatypeException {
        this.err("Expected number but found " + this.code(num) + " at " + this.clip(extract) + ".");
    }

    private void errNotUnits(CharSequence units, StringBuilder extract) throws DatatypeException {
        String msg = "Expected units (one of" + VALID_UNITS + ") but found ";
        msg = "".equals(units) ? msg + "no units" : msg + this.code(units);
        msg = msg + " at " + this.clip(extract) + ".";
        this.err(msg);
    }

    private void errNotFunctionName(CharSequence name, CharSequence extract) throws DatatypeException {
        String msg = "Expected function (one of" + VALID_FUNCTION_NAMES + ") but found ";
        msg = "".equals(name) ? msg + "no name" : msg + this.code(name);
        msg = msg + " at " + this.clip(extract) + ".";
        this.err(msg);
    }

    private void errNoWhitespaceBeforeFunction(CharSequence extract) throws DatatypeException {
        this.err("There must be a whitespace between media query and a function at " + this.clip(extract) + ".");
    }

    private void errMismatchedParens(CharSequence cs, CharSequence extract) throws DatatypeException {
        this.err("Mismatched parentheses in " + this.clip(extract) + ".");
    }

    private void errUnclosedComment(CharSequence cs, CharSequence extract) throws DatatypeException {
        this.err("Unclosed comment in " + this.code(cs) + " at " + this.clip(extract) + ".");
    }

    private CharSequence clip(CharSequence cs) {
        int len = cs.length();
        if (len > 25) {
            cs = "\u2026" + cs.subSequence(len - 25, len);
        }
        return this.code(cs);
    }

    private CharSequence code(CharSequence cs) {
        return "\u201c" + cs + "\u201d";
    }

    @Override
    public String getName() {
        return "source size list";
    }

    static {
        LENGTH_UNITS.add("em");
        LENGTH_UNITS.add("ex");
        LENGTH_UNITS.add("ch");
        LENGTH_UNITS.add("rem");
        LENGTH_UNITS.add("cap");
        LENGTH_UNITS.add("ic");
        LENGTH_UNITS.add("vw");
        LENGTH_UNITS.add("svw");
        LENGTH_UNITS.add("lvw");
        LENGTH_UNITS.add("dvw");
        LENGTH_UNITS.add("vh");
        LENGTH_UNITS.add("svh");
        LENGTH_UNITS.add("lvh");
        LENGTH_UNITS.add("dvh");
        LENGTH_UNITS.add("vi");
        LENGTH_UNITS.add("svi");
        LENGTH_UNITS.add("lvi");
        LENGTH_UNITS.add("dvi");
        LENGTH_UNITS.add("vb");
        LENGTH_UNITS.add("svb");
        LENGTH_UNITS.add("lvb");
        LENGTH_UNITS.add("dvb");
        LENGTH_UNITS.add("vmin");
        LENGTH_UNITS.add("svmin");
        LENGTH_UNITS.add("lvmin");
        LENGTH_UNITS.add("dvmin");
        LENGTH_UNITS.add("vmax");
        LENGTH_UNITS.add("svmax");
        LENGTH_UNITS.add("lvmax");
        LENGTH_UNITS.add("dvmax");
        LENGTH_UNITS.add("cm");
        LENGTH_UNITS.add("mm");
        LENGTH_UNITS.add("q");
        LENGTH_UNITS.add("in");
        LENGTH_UNITS.add("pc");
        LENGTH_UNITS.add("pt");
        LENGTH_UNITS.add("px");
        for (CharSequence charSequence : LENGTH_UNITS) {
            VALID_UNITS.append(" \u201c").append(charSequence).append("\u201d,");
        }
        VALID_UNITS.setLength(VALID_UNITS.length() - 1);
        FUNCTION_NAMES = new LinkedHashSet<String>();
        VALID_FUNCTION_NAMES = new StringBuilder();
        FUNCTION_NAMES.add("calc");
        FUNCTION_NAMES.add("min");
        FUNCTION_NAMES.add("max");
        FUNCTION_NAMES.add("clamp");
        FUNCTION_NAMES.add("sin");
        FUNCTION_NAMES.add("cos");
        FUNCTION_NAMES.add("tan");
        FUNCTION_NAMES.add("asin");
        FUNCTION_NAMES.add("acos");
        FUNCTION_NAMES.add("atan");
        FUNCTION_NAMES.add("atan2");
        FUNCTION_NAMES.add("pow");
        FUNCTION_NAMES.add("sqrt");
        FUNCTION_NAMES.add("hypot");
        FUNCTION_NAMES.add("log");
        FUNCTION_NAMES.add("exp");
        FUNCTION_NAMES.add("abs");
        FUNCTION_NAMES.add("sign");
        for (CharSequence charSequence : FUNCTION_NAMES) {
            VALID_FUNCTION_NAMES.append(" \u201c").append(charSequence).append("\u201d,");
        }
        VALID_FUNCTION_NAMES.setLength(VALID_FUNCTION_NAMES.length() - 1);
        CSS_NUMBER_TOKEN = CssNumberToken.THE_INSTANCE;
        MEDIA_CONDITION = MediaCondition.THE_INSTANCE;
        THE_INSTANCE = new SourceSizeList();
    }

    private static enum State {
        IN_SIZE,
        AFTER_SLASH,
        IN_COMMENT,
        IN_COMMENT_AFTER_ASTERISK;

    }
}

