/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel;

import java.util.Arrays;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.internal.tasks.DefaultSourceSetContainer;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.plugin.devel.PluginDeclaration;

public abstract class GradlePluginDevelopmentExtension {
    private final Property<String> website;
    private final Property<String> vcsUrl;
    private final SourceSetContainer testSourceSets;
    private SourceSet pluginSourceSet;
    private boolean automatedPublishing = true;
    private final NamedDomainObjectContainer<PluginDeclaration> plugins;

    public GradlePluginDevelopmentExtension(Project project, SourceSet pluginSourceSet, SourceSet testSourceSet) {
        this(project, pluginSourceSet, new SourceSet[]{testSourceSet});
    }

    public GradlePluginDevelopmentExtension(Project project, SourceSet pluginSourceSet, SourceSet[] testSourceSets) {
        this.plugins = project.container(PluginDeclaration.class);
        this.pluginSourceSet = pluginSourceSet;
        this.testSourceSets = (SourceSetContainer)project.getObjects().newInstance(DefaultSourceSetContainer.class, new Object[0]);
        this.website = project.getObjects().property(String.class);
        this.vcsUrl = project.getObjects().property(String.class);
        this.testSourceSets(testSourceSets);
    }

    public void pluginSourceSet(SourceSet pluginSourceSet) {
        this.pluginSourceSet = pluginSourceSet;
    }

    @Incubating
    public void testSourceSet(SourceSet testSourceSet) {
        this.testSourceSets.add((Object)testSourceSet);
    }

    public void testSourceSets(SourceSet ... testSourceSets) {
        this.testSourceSets.clear();
        this.testSourceSets.addAll(Arrays.asList(testSourceSets));
    }

    public SourceSet getPluginSourceSet() {
        return this.pluginSourceSet;
    }

    public Set<SourceSet> getTestSourceSets() {
        return this.testSourceSets;
    }

    @Incubating
    public Property<String> getWebsite() {
        return this.website;
    }

    @Incubating
    public Property<String> getVcsUrl() {
        return this.vcsUrl;
    }

    public NamedDomainObjectContainer<PluginDeclaration> getPlugins() {
        return this.plugins;
    }

    public void plugins(Action<? super NamedDomainObjectContainer<PluginDeclaration>> action) {
        action.execute(this.plugins);
    }

    public boolean isAutomatedPublishing() {
        return this.automatedPublishing;
    }

    public void setAutomatedPublishing(boolean automatedPublishing) {
        this.automatedPublishing = automatedPublishing;
    }
}

