/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.enterprise.test.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.gradle.internal.enterprise.test.TestTaskForkOptions;

class DefaultTestTaskForkOptions
implements TestTaskForkOptions {
    private final File workingDir;
    private final String executable;
    private final int javaMajorVersion;
    private final Iterable<File> classpath;
    private final Iterable<File> modulePath;
    private final List<String> jvmArgs;
    private final Map<String, String> environment;

    DefaultTestTaskForkOptions(File workingDir, String executable, int javaMajorVersion, Iterable<File> classpath, Iterable<File> modulePath, List<String> jvmArgs, Map<String, String> environment) {
        this.workingDir = workingDir;
        this.executable = executable;
        this.javaMajorVersion = javaMajorVersion;
        this.classpath = classpath;
        this.modulePath = modulePath;
        this.jvmArgs = ImmutableList.copyOf(jvmArgs);
        this.environment = ImmutableMap.copyOf(environment);
    }

    @Override
    public File getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public String getExecutable() {
        return this.executable;
    }

    @Override
    public int getJavaMajorVersion() {
        return this.javaMajorVersion;
    }

    @Override
    public Stream<File> getClasspath() {
        return StreamSupport.stream(this.classpath.spliterator(), false);
    }

    @Override
    public Stream<File> getModulePath() {
        return StreamSupport.stream(this.modulePath.spliterator(), false);
    }

    @Override
    public List<String> getJvmArgs() {
        return this.jvmArgs;
    }

    @Override
    public Map<String, String> getEnvironment() {
        return this.environment;
    }
}

