/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import com.google.common.base.Objects;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.ValueSnapshotter;

public class GradleSerializedValueSnapshot
implements ValueSnapshot {
    private final HashCode implementationHash;
    private final byte[] serializedValue;

    public GradleSerializedValueSnapshot(@Nullable HashCode implementationHash, byte[] serializedValue) {
        this.implementationHash = implementationHash;
        this.serializedValue = serializedValue;
    }

    @Nullable
    public HashCode getImplementationHash() {
        return this.implementationHash;
    }

    public byte[] getValue() {
        return this.serializedValue;
    }

    public ValueSnapshot snapshot(Object value, ValueSnapshotter snapshotter) {
        ValueSnapshot snapshot = snapshotter.snapshot(value);
        if (this.hasSameSerializedValue(value, snapshot)) {
            return this;
        }
        return snapshot;
    }

    private boolean hasSameSerializedValue(Object value, ValueSnapshot snapshot) {
        if (snapshot instanceof GradleSerializedValueSnapshot) {
            GradleSerializedValueSnapshot newSnapshot = (GradleSerializedValueSnapshot)snapshot;
            if (!Objects.equal((Object)this.implementationHash, (Object)newSnapshot.implementationHash)) {
                return false;
            }
            if (Arrays.equals(this.serializedValue, newSnapshot.serializedValue)) {
                return true;
            }
        }
        return false;
    }

    public void appendToHasher(Hasher hasher) {
        if (this.implementationHash == null) {
            hasher.putNull();
        } else {
            hasher.putHash(this.implementationHash);
        }
        hasher.putBytes(this.serializedValue);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        GradleSerializedValueSnapshot other = (GradleSerializedValueSnapshot)obj;
        return Objects.equal((Object)this.implementationHash, (Object)other.implementationHash) && Arrays.equals(this.serializedValue, other.serializedValue);
    }

    public int hashCode() {
        return Arrays.hashCode(this.serializedValue);
    }
}

