/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.Profile;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.grants.OAuth2GrantType;
import org.keycloak.protocol.oidc.grants.OAuth2GrantTypeBase;
import org.keycloak.protocol.oidc.utils.OAuth2Code;
import org.keycloak.protocol.oidc.utils.OAuth2CodeParser;
import org.keycloak.protocol.oidc.utils.PkceUtils;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.TokenRequestContext;
import org.keycloak.services.clientpolicy.context.TokenResponseContext;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.util.DefaultClientSessionContext;

public class AuthorizationCodeGrantType
extends OAuth2GrantTypeBase {
    private static final Logger logger = Logger.getLogger(AuthorizationCodeGrantType.class);

    public Response process(OAuth2GrantType.Context context) {
        this.setContext(context);
        this.checkAndRetrieveDPoPProof(Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.DPOP));
        String code = (String)this.formParams.getFirst((Object)"code");
        if (code == null) {
            String errorMessage = "Missing parameter: code";
            this.event.detail("reason", errorMessage);
            this.event.error("invalid_code");
            throw new CorsErrorResponseException(this.cors, "invalid_request", errorMessage, Response.Status.BAD_REQUEST);
        }
        OAuth2CodeParser.ParseResult parseResult = OAuth2CodeParser.parseCode(this.session, code, this.realm, this.event);
        if (parseResult.isIllegalCode()) {
            AuthenticatedClientSessionModel clientSession = parseResult.getClientSession();
            if (clientSession != null) {
                clientSession.detachFromUserSession();
            }
            this.event.error("invalid_code");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "Code not valid", Response.Status.BAD_REQUEST);
        }
        AuthenticatedClientSessionModel clientSession = parseResult.getClientSession();
        if (parseResult.isExpiredCode()) {
            this.event.error("expired_code");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "Code is expired", Response.Status.BAD_REQUEST);
        }
        UserSessionModel userSession = null;
        if (clientSession != null) {
            userSession = clientSession.getUserSession();
        }
        if (userSession == null) {
            this.event.error("user_session_not_found");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "User session not found", Response.Status.BAD_REQUEST);
        }
        UserModel user = userSession.getUser();
        if (user == null) {
            this.event.error("user_not_found");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "User not found", Response.Status.BAD_REQUEST);
        }
        this.event.user(userSession.getUser());
        if (!user.isEnabled()) {
            this.event.error("user_disabled");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "User disabled", Response.Status.BAD_REQUEST);
        }
        OAuth2Code codeData = parseResult.getCodeData();
        String redirectUri = codeData.getRedirectUriParam();
        String redirectUriParam = (String)this.formParams.getFirst((Object)"redirect_uri");
        if (redirectUriParam != null && redirectUriParam.contains("session_state=") && !redirectUri.contains("session_state=")) {
            redirectUriParam = KeycloakUriBuilder.fromUri((String)redirectUriParam).replaceQueryParam("session_state", null).build(new Object[0]).toString();
        }
        if (redirectUri != null && !redirectUri.equals(redirectUriParam)) {
            String errorMessage = "Parameter 'redirect_uri' did not match originally saved redirect URI used in initial OIDC request. Saved redirectUri: %s, redirectUri parameter: %s";
            this.event.detail("reason", String.format(errorMessage, redirectUri, redirectUriParam));
            this.event.error("invalid_redirect_uri");
            logger.tracef(errorMessage, (Object)redirectUri, (Object)redirectUriParam);
            throw new CorsErrorResponseException(this.cors, "invalid_grant", "Incorrect redirect_uri", Response.Status.BAD_REQUEST);
        }
        if (!this.client.getClientId().equals(clientSession.getClient().getClientId())) {
            String errorMessage = "Auth error: Found different client_id in clientSession";
            this.event.detail("reason", errorMessage);
            this.event.error("invalid_client");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", errorMessage, Response.Status.BAD_REQUEST);
        }
        if (!this.client.isStandardFlowEnabled()) {
            String errorMessage = "Client not allowed to exchange code";
            this.event.detail("reason", errorMessage);
            this.event.error("not_allowed");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", errorMessage, Response.Status.BAD_REQUEST);
        }
        if (!AuthenticationManager.isSessionValid(this.realm, userSession)) {
            String errorMessage = "Session not active";
            this.event.detail("reason", errorMessage);
            this.event.error("user_session_not_found");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", errorMessage, Response.Status.BAD_REQUEST);
        }
        String codeVerifier = (String)this.formParams.getFirst((Object)"code_verifier");
        String codeChallenge = codeData.getCodeChallenge();
        String codeChallengeMethod = codeData.getCodeChallengeMethod();
        String authUserId = user.getId();
        String authUsername = user.getUsername();
        if (authUserId == null) {
            authUserId = "unknown";
        }
        if (authUsername == null) {
            authUsername = "unknown";
        }
        if (codeChallengeMethod != null && !codeChallengeMethod.isEmpty()) {
            PkceUtils.checkParamsForPkceEnforcedClient(codeVerifier, codeChallenge, codeChallengeMethod, authUserId, authUsername, this.event, this.cors);
        } else {
            PkceUtils.checkParamsForPkceNotEnforcedClient(codeVerifier, codeChallenge, codeChallengeMethod, authUserId, authUsername, this.event, this.cors);
        }
        try {
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new TokenRequestContext((MultivaluedMap<String, String>)this.formParams, parseResult));
        }
        catch (ClientPolicyException cpe) {
            this.event.error(cpe.getError());
            throw new CorsErrorResponseException(this.cors, "invalid_grant", cpe.getErrorDetail(), Response.Status.BAD_REQUEST);
        }
        this.updateClientSession(clientSession);
        this.updateUserSessionFromClientAuth(userSession);
        String scopeParam = codeData.getScope();
        Supplier<Stream> clientScopesSupplier = () -> TokenManager.getRequestedClientScopes(scopeParam, this.client);
        if (!TokenManager.verifyConsentStillAvailable(this.session, user, this.client, clientScopesSupplier.get())) {
            String errorMessage = "Client no longer has requested consent from user";
            this.event.detail("reason", errorMessage);
            this.event.error("not_allowed");
            throw new CorsErrorResponseException(this.cors, "invalid_scope", errorMessage, Response.Status.BAD_REQUEST);
        }
        DefaultClientSessionContext clientSessionCtx = DefaultClientSessionContext.fromClientSessionAndScopeParameter(clientSession, scopeParam, this.session);
        clientSessionCtx.setAttribute("nonce", codeData.getNonce());
        return this.createTokenResponse(user, userSession, clientSessionCtx, scopeParam, true, s -> new TokenResponseContext((MultivaluedMap<String, String>)this.formParams, parseResult, clientSessionCtx, (TokenManager.AccessTokenResponseBuilder)s));
    }

    public EventType getEventType() {
        return EventType.CODE_TO_TOKEN;
    }
}

