/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes;

import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.models.sessions.infinispan.PersistentUserSessionProvider;
import org.keycloak.models.sessions.infinispan.SessionFunction;
import org.keycloak.models.sessions.infinispan.UserSessionAdapter;
import org.keycloak.models.sessions.infinispan.changes.PersistentSessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.PersistentSessionsChangelogBasedTransaction;
import org.keycloak.models.sessions.infinispan.changes.PersistentUpdate;
import org.keycloak.models.sessions.infinispan.changes.SerializeExecutionsByKey;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdatesList;
import org.keycloak.models.sessions.infinispan.changes.Tasks;
import org.keycloak.models.sessions.infinispan.changes.UserSessionPersistentChangelogBasedTransaction;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionStore;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;
import org.keycloak.models.sessions.infinispan.remotestore.RemoteCacheInvoker;

public class ClientSessionPersistentChangelogBasedTransaction
extends PersistentSessionsChangelogBasedTransaction<UUID, AuthenticatedClientSessionEntity> {
    private static final Logger LOG = Logger.getLogger(ClientSessionPersistentChangelogBasedTransaction.class);
    private final UserSessionPersistentChangelogBasedTransaction userSessionTx;

    public ClientSessionPersistentChangelogBasedTransaction(KeycloakSession session, Cache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> cache, Cache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> offlineCache, RemoteCacheInvoker remoteCacheInvoker, SessionFunction<AuthenticatedClientSessionEntity> lifespanMsLoader, SessionFunction<AuthenticatedClientSessionEntity> maxIdleTimeMsLoader, SessionFunction<AuthenticatedClientSessionEntity> offlineLifespanMsLoader, SessionFunction<AuthenticatedClientSessionEntity> offlineMaxIdleTimeMsLoader, UserSessionPersistentChangelogBasedTransaction userSessionTx, ArrayBlockingQueue<PersistentUpdate> batchingQueue, SerializeExecutionsByKey<UUID> serializerOnline, SerializeExecutionsByKey<UUID> serializerOffline) {
        super(session, cache, offlineCache, remoteCacheInvoker, lifespanMsLoader, maxIdleTimeMsLoader, offlineLifespanMsLoader, offlineMaxIdleTimeMsLoader, batchingQueue, serializerOnline, serializerOffline);
        this.userSessionTx = userSessionTx;
    }

    public SessionEntityWrapper<AuthenticatedClientSessionEntity> get(RealmModel realm, ClientModel client, UserSessionModel userSession, UUID key, boolean offline) {
        SessionUpdatesList<Object> myUpdates = this.getUpdates(offline).get(key);
        if (myUpdates == null) {
            SessionEntityWrapper<AuthenticatedClientSessionEntity> wrappedEntity = null;
            wrappedEntity = (SessionEntityWrapper<AuthenticatedClientSessionEntity>)this.getCache(offline).get((Object)key);
            if (wrappedEntity == null) {
                LOG.debugf("client-session not found in cache for sessionId=%s, offline=%s, loading from persister", (Object)key, (Object)offline);
                wrappedEntity = this.getSessionEntityFromPersister(realm, client, userSession, offline);
            } else {
                LOG.debugf("client-session found in cache for sessionId=%s, offline=%s", (Object)key, (Object)offline);
            }
            if (wrappedEntity == null) {
                LOG.debugf("client-session not found in persister for sessionId=%s, offline=%s", (Object)key, (Object)offline);
                return null;
            }
            ((AuthenticatedClientSessionEntity)wrappedEntity.getEntity()).setOffline(offline);
            RealmModel realmFromSession = this.kcSession.realms().getRealm(wrappedEntity.getEntity().getRealmId());
            if (!realmFromSession.getId().equals(realm.getId())) {
                LOG.warnf("Realm mismatch for session %s. Expected realm %s, but found realm %s", (Object)wrappedEntity.getEntity(), (Object)realm.getId(), (Object)realmFromSession.getId());
                return null;
            }
            myUpdates = new SessionUpdatesList<AuthenticatedClientSessionEntity>(realm, wrappedEntity);
            this.getUpdates(offline).put(key, myUpdates);
            return wrappedEntity;
        }
        boolean scheduledForRemove = myUpdates.getUpdateTasks().stream().filter(task -> task.getOperation() == SessionUpdateTask.CacheOperation.REMOVE).findFirst().isPresent();
        return scheduledForRemove ? null : myUpdates.getEntityWrapper();
    }

    private SessionEntityWrapper<AuthenticatedClientSessionEntity> getSessionEntityFromPersister(RealmModel realm, ClientModel client, UserSessionModel userSession, boolean offline) {
        UserSessionPersisterProvider persister = (UserSessionPersisterProvider)this.kcSession.getProvider(UserSessionPersisterProvider.class);
        AuthenticatedClientSessionModel clientSession = persister.loadClientSession(realm, client, userSession, offline);
        if (clientSession == null) {
            return null;
        }
        SessionEntityWrapper<AuthenticatedClientSessionEntity> authenticatedClientSessionEntitySessionEntityWrapper = this.importClientSession(realm, client, userSession, clientSession);
        if (authenticatedClientSessionEntitySessionEntityWrapper == null) {
            LOG.debugf("client-session not imported from persister for sessionId=%s, offline=%s, removing from persister.", (Object)clientSession.getId(), (Object)offline);
            persister.removeClientSession(userSession.getId(), client.getId(), offline);
        }
        return authenticatedClientSessionEntitySessionEntityWrapper;
    }

    private AuthenticatedClientSessionEntity createAuthenticatedClientSessionInstance(String userSessionId, AuthenticatedClientSessionModel clientSession, String realmId, String clientId) {
        UUID clientSessionId = PersistentUserSessionProvider.createClientSessionUUID(userSessionId, clientId);
        AuthenticatedClientSessionEntity entity = new AuthenticatedClientSessionEntity(clientSessionId);
        entity.setRealmId(realmId);
        entity.setAction(clientSession.getAction());
        entity.setAuthMethod(clientSession.getProtocol());
        entity.setNotes(clientSession.getNotes() == null ? new ConcurrentHashMap() : clientSession.getNotes());
        entity.setClientId(clientId);
        entity.setRedirectUri(clientSession.getRedirectUri());
        entity.setTimestamp(clientSession.getTimestamp());
        entity.setOffline(clientSession.getUserSession().isOffline());
        return entity;
    }

    private SessionEntityWrapper<AuthenticatedClientSessionEntity> importClientSession(RealmModel realm, ClientModel client, UserSessionModel userSession, AuthenticatedClientSessionModel persistentClientSession) {
        AuthenticatedClientSessionEntity entity = this.createAuthenticatedClientSessionInstance(userSession.getId(), persistentClientSession, realm.getId(), client.getId());
        boolean offline = userSession.isOffline();
        entity.setUserSessionId(userSession.getId());
        entity.setTimestamp(userSession.getLastSessionRefresh());
        if (this.getMaxIdleMsLoader(offline).apply(realm, client, entity) == -2L || this.getLifespanMsLoader(offline).apply(realm, client, entity) == -2L) {
            return null;
        }
        UUID clientSessionId = entity.getId();
        SessionUpdateTask createClientSessionTask = Tasks.addIfAbsentSync();
        this.addTask(entity.getId(), createClientSessionTask, entity, UserSessionModel.SessionPersistenceState.PERSISTENT);
        if (!(userSession instanceof UserSessionAdapter)) {
            throw new IllegalStateException("UserSessionModel must be instance of UserSessionAdapter");
        }
        UserSessionAdapter sessionToImportInto = (UserSessionAdapter)userSession;
        AuthenticatedClientSessionStore clientSessions = sessionToImportInto.getEntity().getAuthenticatedClientSessions();
        clientSessions.put(client.getId(), clientSessionId);
        RegisterClientSessionTask registerClientSessionTask = new RegisterClientSessionTask(client.getId(), clientSessionId, offline);
        this.userSessionTx.addTask(sessionToImportInto.getId(), registerClientSessionTask);
        return new SessionEntityWrapper<AuthenticatedClientSessionEntity>(entity);
    }

    public static class RegisterClientSessionTask
    implements PersistentSessionUpdateTask<UserSessionEntity> {
        private final String clientUuid;
        private final UUID clientSessionId;
        private final boolean offline;

        public RegisterClientSessionTask(String clientUuid, UUID clientSessionId, boolean offline) {
            this.clientUuid = clientUuid;
            this.clientSessionId = clientSessionId;
            this.offline = offline;
        }

        @Override
        public void runUpdate(UserSessionEntity session) {
            AuthenticatedClientSessionStore clientSessions = session.getAuthenticatedClientSessions();
            clientSessions.put(this.clientUuid, this.clientSessionId);
        }

        @Override
        public SessionUpdateTask.CacheOperation getOperation() {
            return SessionUpdateTask.CacheOperation.REPLACE;
        }

        @Override
        public SessionUpdateTask.CrossDCMessageStatus getCrossDCMessageStatus(SessionEntityWrapper<UserSessionEntity> sessionWrapper) {
            return SessionUpdateTask.CrossDCMessageStatus.SYNC;
        }

        @Override
        public boolean isOffline() {
            return this.offline;
        }
    }
}

