/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.encoding;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.extension.ExtensionWriter;
import io.smallrye.openapi.runtime.io.header.HeaderWriter;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.media.Encoding;

public class EncodingWriter {
    private EncodingWriter() {
    }

    public static void writeEncodings(ObjectNode parent, Map<String, Encoding> models) {
        if (models == null) {
            return;
        }
        ObjectNode node = parent.putObject("encoding");
        for (Map.Entry<String, Encoding> entry : models.entrySet()) {
            EncodingWriter.writeEncoding(node, entry.getValue(), entry.getKey());
        }
    }

    private static void writeEncoding(ObjectNode parent, Encoding model, String name) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject(name);
        JsonUtil.stringProperty(node, "contentType", model.getContentType());
        HeaderWriter.writeHeaders(node, model.getHeaders());
        JsonUtil.enumProperty(node, "style", model.getStyle());
        JsonUtil.booleanProperty(node, "explode", model.getExplode());
        JsonUtil.booleanProperty(node, "allowReserved", model.getAllowReserved());
        ExtensionWriter.writeExtensions(node, model);
    }
}

