/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.internal;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.hibernate.CacheMode;
import org.hibernate.IdentifierLoadAccess;
import org.hibernate.LockOptions;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.SessionFactory;
import org.hibernate.UnknownProfileException;
import org.hibernate.bytecode.enhance.spi.interceptor.BytecodeLazyAttributeInterceptor;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.bytecode.spi.BytecodeEnhancementMetadata;
import org.hibernate.engine.spi.EffectiveEntityGraph;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.loader.internal.LoadAccessContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class IdentifierLoadAccessImpl<T>
implements IdentifierLoadAccess<T>,
JavaType.CoercionContext {
    private final LoadAccessContext context;
    private final EntityPersister entityPersister;
    private LockOptions lockOptions;
    private CacheMode cacheMode;
    private Boolean readOnly;
    private RootGraphImplementor<T> rootGraph;
    private GraphSemantic graphSemantic;
    private Set<String> enabledFetchProfiles;
    private Set<String> disabledFetchProfiles;

    public IdentifierLoadAccessImpl(LoadAccessContext context, EntityPersister entityPersister) {
        this.context = context;
        this.entityPersister = entityPersister;
    }

    @Override
    public final IdentifierLoadAccessImpl<T> with(LockOptions lockOptions) {
        this.lockOptions = lockOptions;
        return this;
    }

    @Override
    public IdentifierLoadAccess<T> with(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
        return this;
    }

    @Override
    public IdentifierLoadAccess<T> withReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Override
    public IdentifierLoadAccess<T> with(RootGraph<T> graph, GraphSemantic semantic) {
        this.rootGraph = (RootGraphImplementor)graph;
        this.graphSemantic = semantic;
        return this;
    }

    @Override
    public final T getReference(Object id) {
        return (T)this.perform(() -> this.doGetReference(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T perform(Supplier<T> executor) {
        SessionImplementor session = this.context.getSession();
        CacheMode sessionCacheMode = session.getCacheMode();
        boolean cacheModeChanged = false;
        if (this.cacheMode != null && this.cacheMode != sessionCacheMode) {
            session.setCacheMode(this.cacheMode);
            cacheModeChanged = true;
        }
        try {
            T t;
            LoadQueryInfluencers influencers = session.getLoadQueryInfluencers();
            HashSet<String> fetchProfiles = influencers.adjustFetchProfiles(this.disabledFetchProfiles, this.enabledFetchProfiles);
            EffectiveEntityGraph effectiveEntityGraph = session.getLoadQueryInfluencers().applyEntityGraph(this.rootGraph, this.graphSemantic);
            try {
                t = executor.get();
                effectiveEntityGraph.clear();
                influencers.setEnabledFetchProfileNames(fetchProfiles);
            }
            catch (Throwable throwable) {
                effectiveEntityGraph.clear();
                influencers.setEnabledFetchProfileNames(fetchProfiles);
                throw throwable;
            }
            return t;
        }
        finally {
            if (cacheModeChanged) {
                session.setCacheMode(sessionCacheMode);
            }
        }
    }

    protected T doGetReference(Object id) {
        SessionImplementor session = this.context.getSession();
        SessionFactory factory = session.getFactory();
        return (T)this.getReference(this.coerceId(id, (SessionFactoryImplementor)factory), session.asEventSource(), (SessionFactoryImplementor)factory, this.entityPersister.getEntityName(), this.isReadOnly(session));
    }

    private Boolean isReadOnly(SessionImplementor session) {
        return this.readOnly != null ? this.readOnly : session.getLoadQueryInfluencers().getReadOnly();
    }

    @Override
    public final T load(Object id) {
        return (T)this.perform(() -> this.doLoad(id));
    }

    @Override
    public Optional<T> loadOptional(Object id) {
        return Optional.ofNullable(this.perform(() -> this.doLoad(id)));
    }

    protected final T doLoad(Object id) {
        SessionImplementor session = this.context.getSession();
        Object result = this.load(this.coerceId(id, (SessionFactoryImplementor)session.getFactory()), session.asEventSource(), this.entityPersister.getEntityName(), this.isReadOnly(session));
        this.initializeIfNecessary(result);
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getReference(Object id, EventSource eventSource, SessionFactoryImplementor factory, String entityName, Boolean readOnly) {
        if (this.lockOptions != null) {
            LoadEvent event = new LoadEvent(id, entityName, this.lockOptions, eventSource, readOnly);
            this.context.fireLoad(event, LoadEventListener.LOAD);
            return event.getResult();
        }
        LoadEvent event = new LoadEvent(id, entityName, false, eventSource, readOnly);
        boolean success = false;
        try {
            this.context.fireLoad(event, LoadEventListener.LOAD);
            Object result = event.getResult();
            if (result == null) {
                factory.getEntityNotFoundDelegate().handleEntityNotFound(entityName, id);
            }
            success = true;
            Object object = result;
            return object;
        }
        finally {
            this.context.afterOperation(success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object load(Object id, EventSource eventSource, String entityName, Boolean readOnly) {
        LoadEvent event;
        if (this.lockOptions != null) {
            event = new LoadEvent(id, entityName, this.lockOptions, eventSource, readOnly);
            this.context.fireLoad(event, LoadEventListener.GET);
        } else {
            event = new LoadEvent(id, entityName, false, eventSource, readOnly);
            boolean success = false;
            try {
                this.context.fireLoad(event, LoadEventListener.GET);
                success = true;
            }
            catch (ObjectNotFoundException objectNotFoundException) {
            }
            finally {
                this.context.afterOperation(success);
            }
        }
        return event.getResult();
    }

    private Object coerceId(Object id, SessionFactoryImplementor factory) {
        if (IdentifierLoadAccessImpl.isLoadByIdComplianceEnabled(factory)) {
            return id;
        }
        try {
            return this.entityPersister.getIdentifierMapping().getJavaType().coerce(id, this);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Argument '" + id + "' could not be converted to the identifier type of entity '" + this.entityPersister.getEntityName() + "' [" + e.getMessage() + "]", e);
        }
    }

    private void initializeIfNecessary(Object result) {
        if (result != null) {
            LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(result);
            if (lazyInitializer != null) {
                if (lazyInitializer.isUninitialized()) {
                    lazyInitializer.initialize();
                }
            } else {
                BytecodeLazyAttributeInterceptor interceptor;
                BytecodeEnhancementMetadata enhancementMetadata = this.entityPersister.getEntityMetamodel().getBytecodeEnhancementMetadata();
                if (enhancementMetadata.isEnhancedForLazyLoading() && (interceptor = enhancementMetadata.extractLazyInterceptor(result)) instanceof EnhancementAsProxyLazinessInterceptor) {
                    EnhancementAsProxyLazinessInterceptor lazinessInterceptor = (EnhancementAsProxyLazinessInterceptor)interceptor;
                    lazinessInterceptor.forceInitialize(result, null);
                }
            }
        }
    }

    private static boolean isLoadByIdComplianceEnabled(SessionFactoryImplementor factory) {
        return factory.getSessionFactoryOptions().getJpaCompliance().isLoadByIdComplianceEnabled();
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.context.getSession().getSessionFactory().getTypeConfiguration();
    }

    @Override
    public IdentifierLoadAccess<T> enableFetchProfile(String profileName) {
        if (!this.context.getSession().getFactory().containsFetchProfileDefinition(profileName)) {
            throw new UnknownProfileException(profileName);
        }
        if (this.enabledFetchProfiles == null) {
            this.enabledFetchProfiles = new HashSet<String>();
        }
        this.enabledFetchProfiles.add(profileName);
        if (this.disabledFetchProfiles != null) {
            this.disabledFetchProfiles.remove(profileName);
        }
        return this;
    }

    @Override
    public IdentifierLoadAccess<T> disableFetchProfile(String profileName) {
        if (this.disabledFetchProfiles == null) {
            this.disabledFetchProfiles = new HashSet<String>();
        }
        this.disabledFetchProfiles.add(profileName);
        if (this.enabledFetchProfiles != null) {
            this.enabledFetchProfiles.remove(profileName);
        }
        return this;
    }
}

