/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.Unmarshaller;

public abstract class MarshallerObjectInputStream
extends ObjectInputStream
implements ByteInput {
    private final Unmarshaller input;

    protected MarshallerObjectInputStream(Unmarshaller input) throws IOException, SecurityException {
        this.input = input;
    }

    @Override
    protected Object readObjectOverride() throws IOException, ClassNotFoundException {
        return this.input.readObject();
    }

    @Override
    public Object readUnshared() throws IOException, ClassNotFoundException {
        return this.input.readObjectUnshared();
    }

    @Override
    public int read() throws IOException {
        return this.input.read();
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.input.read(buf, 0, buf.length);
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        return this.input.read(buf, off, len);
    }

    @Override
    public int available() throws IOException {
        return this.input.available();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.input.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.input.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.input.readUnsignedByte();
    }

    @Override
    public char readChar() throws IOException {
        return this.input.readChar();
    }

    @Override
    public short readShort() throws IOException {
        return this.input.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.input.readUnsignedShort();
    }

    @Override
    public int readInt() throws IOException {
        return this.input.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.input.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.input.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.input.readDouble();
    }

    @Override
    public void readFully(byte[] buf) throws IOException {
        this.input.readFully(buf);
    }

    @Override
    public void readFully(byte[] buf, int off, int len) throws IOException {
        this.input.readFully(buf, off, len);
    }

    @Override
    public int skipBytes(int len) throws IOException {
        return this.input.skipBytes(len);
    }

    @Override
    @Deprecated
    public String readLine() throws IOException {
        return this.input.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.input.readUTF();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.input.skip(n);
    }

    @Override
    public final void mark(int readlimit) {
    }

    @Override
    public final void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public final boolean markSupported() {
        return false;
    }

    @Override
    public final void close() throws IllegalStateException {
        throw new IllegalStateException("Stream may not be closed in this context");
    }

    @Override
    protected final Class<?> resolveClass(ObjectStreamClass desc) throws IllegalStateException {
        throw new IllegalStateException("Class may not be resolved in this context");
    }

    @Override
    protected final Class<?> resolveProxyClass(String[] interfaces) throws IllegalStateException {
        throw new IllegalStateException("Class may not be resolved in this context");
    }

    @Override
    protected final Object resolveObject(Object obj) throws IllegalStateException {
        throw new IllegalStateException("Object may not be resolved in this context");
    }

    @Override
    protected final boolean enableResolveObject(boolean enable) throws IllegalStateException {
        throw new IllegalStateException("Object resolution may not be enabled in this context");
    }

    @Override
    protected final void readStreamHeader() throws IllegalStateException {
        throw new IllegalStateException("Stream header may not be read in this context");
    }

    @Override
    protected final ObjectStreamClass readClassDescriptor() throws IllegalStateException {
        throw new IllegalStateException("Class descriptor may not be read in this context");
    }

    @Override
    public abstract void defaultReadObject() throws IOException, ClassNotFoundException;

    @Override
    public abstract ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException;

    @Override
    public abstract void registerValidation(ObjectInputValidation var1, int var2) throws NotActiveException, InvalidObjectException;
}

