/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.commons.configuration.io.ConfigurationReaderContext;
import org.infinispan.commons.configuration.io.ConfigurationResourceResolver;
import org.infinispan.commons.configuration.io.NamingStrategy;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.AsyncStoreConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.global.AllowListConfigurationBuilder;
import org.infinispan.configuration.global.GlobalAuthorizationConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalRoleConfigurationBuilder;
import org.infinispan.configuration.global.GlobalSecurityConfigurationBuilder;
import org.infinispan.configuration.global.GlobalStateConfigurationBuilder;
import org.infinispan.configuration.global.SerializationConfigurationBuilder;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.configuration.global.ThreadPoolBuilderAdapter;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.configuration.global.ThreadsConfigurationBuilder;
import org.infinispan.configuration.global.TracingExporterProtocol;
import org.infinispan.configuration.global.TransportConfigurationBuilder;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.CacheParser;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.ParserScope;
import org.infinispan.factories.KnownComponentNames;
import org.infinispan.factories.threads.DefaultThreadFactory;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.globalstate.LocalConfigurationStorage;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.BuiltinJGroupsChannelConfigurator;
import org.infinispan.remoting.transport.jgroups.EmbeddedJGroupsChannelConfigurator;
import org.infinispan.remoting.transport.jgroups.FileJGroupsChannelConfigurator;
import org.infinispan.security.AuditLogger;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.RolePermissionMapper;
import org.infinispan.security.mappers.CaseNameRewriter;
import org.infinispan.security.mappers.ClusterPermissionMapper;
import org.infinispan.security.mappers.ClusterRoleMapper;
import org.infinispan.security.mappers.CommonNameRoleMapper;
import org.infinispan.security.mappers.IdentityRoleMapper;
import org.infinispan.security.mappers.RegexNameRewriter;
import org.infinispan.util.logging.Log;
import org.jgroups.conf.ProtocolConfiguration;

@Namespaces(value={@Namespace(root="infinispan"), @Namespace(uri="urn:infinispan:config:*", root="infinispan")})
public class Parser
extends CacheParser {
    public static final String NAMESPACE = "urn:infinispan:config:";

    @Override
    public void readElement(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        this.addJGroupsDefaultStacksIfNeeded(reader, holder);
        block5: while (reader.inTag("infinispan")) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CACHE_CONTAINER: {
                    this.parseContainer(reader, holder);
                    continue block5;
                }
                case JGROUPS: {
                    this.parseJGroups(reader, holder);
                    continue block5;
                }
                case THREADS: {
                    this.parseThreads(reader, holder);
                    continue block5;
                }
            }
            reader.handleAny((ConfigurationReaderContext)holder);
        }
    }

    private void parseSerialization(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        block15: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case MARSHALLER: {
                    builder.serialization().marshaller((Marshaller)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block15;
                }
                case SCHEMA_COMPATIBILITY: {
                    builder.serialization().schemaCompatibilityValidation(ParseUtils.parseEnum(reader, i, Configuration.SchemaValidation.class, value));
                    continue block15;
                }
                case VERSION: {
                    ParseUtils.removedSince(reader, 11, 0);
                    ParseUtils.ignoreAttribute(reader, i);
                    continue block15;
                }
                case CONTEXT_INITIALIZERS: {
                    for (String klass : reader.getListAttributeValue(i)) {
                        builder.serialization().addContextInitializer((SerializationContextInitializer)Util.getInstance((String)klass, (ClassLoader)holder.getClassLoader()));
                    }
                    continue block15;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block17: while (reader.hasNext()) {
            reader.nextElement();
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SERIALIZATION: {
                    reader.require(ConfigurationReader.ElementType.END_ELEMENT);
                    return;
                }
                case ADVANCED_EXTERNALIZERS: {
                    continue block17;
                }
                case SERIALIZATION_CONTEXT_INITIALIZERS: {
                    if (reader.getAttributeCount() <= 0) continue block17;
                    this.parseSerializationContextInitializer(reader, holder.getClassLoader(), builder.serialization());
                    continue block17;
                }
                case ADVANCED_EXTERNALIZER: {
                    Log.CONFIG.advancedExternalizerDeprecated();
                    this.parseAdvancedExternalizer(reader, holder.getClassLoader(), builder.serialization());
                    continue block17;
                }
                case SERIALIZATION_CONTEXT_INITIALIZER: {
                    this.parseSerializationContextInitializer(reader, holder.getClassLoader(), builder.serialization());
                    continue block17;
                }
                case WHITE_LIST: {
                    ParseUtils.removedSince(reader, 12, 0);
                    Log.CONFIG.configDeprecatedUseOther(Element.WHITE_LIST, Element.ALLOW_LIST, reader.getLocation());
                    this.parseAllowList(reader, builder.serialization().allowList(), Element.WHITE_LIST);
                    continue block17;
                }
                case ALLOW_LIST: {
                    this.parseAllowList(reader, builder.serialization().allowList(), Element.ALLOW_LIST);
                    continue block17;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseSerializationContextInitializer(ConfigurationReader reader, ClassLoader classLoader, SerializationConfigurationBuilder builder) {
        int attributes = reader.getAttributeCount();
        ParseUtils.requireAttributes(reader, Attribute.CLASS.getLocalName());
        block3: for (int i = 0; i < attributes; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case CLASS: {
                    builder.addContextInitializer((SerializationContextInitializer)Util.getInstance((String)value, (ClassLoader)classLoader));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseAllowList(ConfigurationReader reader, AllowListConfigurationBuilder builder, Element outerElement) {
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String[] values = reader.getListAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case CLASS: {
                    builder.addClasses(values);
                    continue block8;
                }
                case REGEX: {
                    builder.addRegexps(values);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
        }
        block9: while (reader.inTag((Enum)outerElement)) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CLASS: {
                    builder.addClass(reader.getElementText());
                    continue block9;
                }
                case REGEX: {
                    builder.addRegexp(reader.getElementText());
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseAdvancedExternalizer(ConfigurationReader reader, ClassLoader classLoader, SerializationConfigurationBuilder builder) {
        int attributes = reader.getAttributeCount();
        AdvancedExternalizer advancedExternalizer = null;
        Integer id = null;
        ParseUtils.requireAttributes(reader, Attribute.CLASS.getLocalName());
        block4: for (int i = 0; i < attributes; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case CLASS: {
                    advancedExternalizer = (AdvancedExternalizer)Util.getInstance((String)value, (ClassLoader)classLoader);
                    continue block4;
                }
                case ID: {
                    id = ParseUtils.parseInt(reader, i, value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
        if (id != null) {
            builder.addAdvancedExternalizer(id, advancedExternalizer);
        } else {
            builder.addAdvancedExternalizer(advancedExternalizer);
        }
    }

    private void parseThreads(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        block6: while (reader.hasNext()) {
            reader.nextElement();
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case THREADS: {
                    reader.require(ConfigurationReader.ElementType.END_ELEMENT);
                    return;
                }
                case THREAD_FACTORIES: {
                    while (reader.inTag((Enum)Element.THREAD_FACTORIES)) {
                        this.parseThreadFactory(reader, holder);
                    }
                    continue block6;
                }
                case THREAD_POOLS: {
                    while (reader.inTag((Enum)Element.THREAD_POOLS)) {
                        this.parseThreadPools(reader, holder);
                    }
                    continue block6;
                }
                case THREAD_FACTORY: {
                    this.parseThreadFactory(reader, holder);
                    continue block6;
                }
            }
            this.parseThreadPools(reader, holder);
        }
    }

    private void parseThreadPools(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        Map.Entry threadPool = reader.getMapItem((Enum)Attribute.NAME);
        Element element = Element.forName((String)threadPool.getValue());
        switch (element) {
            case CACHED_THREAD_POOL: {
                this.parseCachedThreadPool(reader, holder, (String)threadPool.getKey());
                break;
            }
            case SCHEDULED_THREAD_POOL: {
                this.parseScheduledThreadPool(reader, holder, (String)threadPool.getKey());
                break;
            }
            case BLOCKING_BOUNDED_QUEUE_THREAD_POOL: {
                this.parseBoundedQueueThreadPool(reader, holder, (String)threadPool.getKey(), false);
                break;
            }
            case NON_BLOCKING_BOUNDED_QUEUE_THREAD_POOL: {
                this.parseBoundedQueueThreadPool(reader, holder, (String)threadPool.getKey(), true);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement(reader);
            }
        }
        reader.endMapItem();
    }

    public void parseBoundedQueueThreadPool(ConfigurationReader reader, ConfigurationBuilderHolder holder, String name, boolean isNonBlocking) {
        ThreadsConfigurationBuilder threadsBuilder = holder.getGlobalConfigurationBuilder().threads();
        String threadFactoryName = null;
        int maxThreads = 0;
        int coreThreads = 0;
        int queueLength = 0;
        long keepAlive = 0L;
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    continue block8;
                }
                case THREAD_FACTORY: {
                    threadFactoryName = value;
                    continue block8;
                }
                case CORE_THREADS: {
                    coreThreads = ParseUtils.parseInt(reader, i, value);
                    continue block8;
                }
                case MAX_THREADS: {
                    maxThreads = ParseUtils.parseInt(reader, i, value);
                    continue block8;
                }
                case QUEUE_LENGTH: {
                    queueLength = ParseUtils.parseInt(reader, i, value);
                    continue block8;
                }
                case KEEP_ALIVE_TIME: {
                    keepAlive = ParseUtils.parseLong(reader, i, value);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        threadsBuilder.addBoundedThreadPool(name).threadFactory(threadFactoryName).coreThreads(coreThreads).maxThreads(maxThreads).queueLength(queueLength).keepAliveTime(keepAlive).nonBlocking(isNonBlocking);
        ParseUtils.requireNoContent(reader);
    }

    private void parseScheduledThreadPool(ConfigurationReader reader, ConfigurationBuilderHolder holder, String name) {
        ThreadsConfigurationBuilder threadsBuilder = holder.getGlobalConfigurationBuilder().threads();
        String threadFactoryName = null;
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    continue block4;
                }
                case THREAD_FACTORY: {
                    threadFactoryName = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        threadsBuilder.addScheduledThreadPool(name).threadFactory(threadFactoryName);
        ParseUtils.requireNoContent(reader);
    }

    private void parseCachedThreadPool(ConfigurationReader reader, ConfigurationBuilderHolder holder, String name) {
        ThreadsConfigurationBuilder threadsBuilder = holder.getGlobalConfigurationBuilder().threads();
        String threadFactoryName = null;
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    continue block4;
                }
                case THREAD_FACTORY: {
                    threadFactoryName = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        threadsBuilder.addCachedThreadPool(name).threadFactory(threadFactoryName);
        ParseUtils.requireNoContent(reader);
    }

    private void parseThreadFactory(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        Map.Entry threadFactory = reader.getMapItem((Enum)Attribute.NAME);
        String threadGroupName = null;
        String threadNamePattern = null;
        int priority = 1;
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    continue block6;
                }
                case GROUP_NAME: {
                    threadGroupName = value;
                    continue block6;
                }
                case THREAD_NAME_PATTERN: {
                    threadNamePattern = value;
                    continue block6;
                }
                case PRIORITY: {
                    priority = ParseUtils.parseInt(reader, i, value);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        holder.getGlobalConfigurationBuilder().threads().addThreadFactory((String)threadFactory.getKey()).groupName(threadGroupName).priority(priority).threadNamePattern(threadNamePattern);
        ParseUtils.requireNoContent(reader);
        reader.endMapItem();
    }

    private void parseJGroups(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        Transport transport = null;
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) continue;
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case TRANSPORT: {
                    transport = (Transport)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader());
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (transport == null) {
            holder.getGlobalConfigurationBuilder().transport().defaultTransport();
        } else {
            holder.getGlobalConfigurationBuilder().transport().transport(transport);
        }
        block9: while (reader.inTag((Enum)Element.JGROUPS)) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case STACK_FILE: {
                    this.parseStackFile(reader, holder, ParseUtils.requireAttributes(reader, Attribute.NAME)[0]);
                    continue block9;
                }
                case STACKS: {
                    this.parseJGroupsStacks(reader, holder);
                    continue block9;
                }
                case STACK: {
                    this.parseJGroupsStack(reader, holder, ParseUtils.requireAttributes(reader, Attribute.NAME)[0]);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseJGroupsStacks(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        while (reader.inTag((Enum)Element.STACKS)) {
            Map.Entry mapElement = reader.getMapItem((Enum)Attribute.NAME);
            Element type = Element.forName((String)mapElement.getValue());
            switch (type) {
                case STACK: {
                    this.parseJGroupsStack(reader, holder, (String)mapElement.getKey());
                    break;
                }
                case STACK_FILE: {
                    this.parseStackFile(reader, holder, (String)mapElement.getKey());
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            reader.endMapItem();
        }
    }

    private void addJGroupsStackFile(ConfigurationBuilderHolder holder, String name, String path, Properties properties, ConfigurationResourceResolver resourceResolver) {
        URL url = FileLookupFactory.newInstance().lookupFileLocation(path, holder.getClassLoader());
        try (InputStream xml = (url != null ? url : resourceResolver.resolveResource(path)).openStream();){
            holder.addJGroupsStack(new FileJGroupsChannelConfigurator(name, path, xml, properties));
        }
        catch (FileNotFoundException e) {
            throw Log.CONFIG.jgroupsConfigurationNotFound(path);
        }
        catch (IOException e) {
            throw Log.CONFIG.unableToAddJGroupsStack(name, e);
        }
    }

    private void parseJGroupsStack(ConfigurationReader reader, ConfigurationBuilderHolder holder, String stackName) {
        String extend = null;
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    continue block7;
                }
                case EXTENDS: {
                    extend = value;
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ArrayList<ProtocolConfiguration> stack = new ArrayList<ProtocolConfiguration>();
        EmbeddedJGroupsChannelConfigurator.RemoteSites remoteSites = null;
        block8: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case REMOTE_SITES: {
                    remoteSites = this.parseJGroupsRelay(reader, holder, stackName);
                    continue block8;
                }
            }
            String protocolName = reader.getLocalName(NamingStrategy.IDENTITY);
            HashMap<String, String> protocolAttributes = new HashMap<String, String>();
            for (int i = 0; i < reader.getAttributeCount(); ++i) {
                protocolAttributes.put(reader.getAttributeName(i, NamingStrategy.SNAKE_CASE), reader.getAttributeValue(i));
            }
            ParseUtils.requireNoContent(reader);
            stack.add(new ProtocolConfiguration(protocolName, protocolAttributes));
        }
        EmbeddedJGroupsChannelConfigurator stackConfigurator = new EmbeddedJGroupsChannelConfigurator(stackName, stack, remoteSites);
        holder.addJGroupsStack(stackConfigurator, extend);
    }

    private EmbeddedJGroupsChannelConfigurator.RemoteSites parseJGroupsRelay(ConfigurationReader reader, ConfigurationBuilderHolder holder, String stackName) {
        String defaultStack = ParseUtils.requireAttributes(reader, Attribute.DEFAULT_STACK)[0];
        String defaultCluster = "xsite";
        if (!holder.hasJGroupsStack(defaultStack)) {
            throw Log.CONFIG.missingJGroupsStack(defaultStack);
        }
        block12: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) continue;
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case DEFAULT_STACK: {
                    continue block12;
                }
                case CLUSTER: {
                    defaultCluster = value;
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        EmbeddedJGroupsChannelConfigurator.RemoteSites remoteSites = new EmbeddedJGroupsChannelConfigurator.RemoteSites(defaultStack, defaultCluster);
        block13: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case REMOTE_SITE: {
                    if (reader.getAttributeCount() <= 0) continue block13;
                    String remoteSite = ParseUtils.requireAttributes(reader, Attribute.NAME)[0];
                    String cluster = defaultCluster;
                    String stack = defaultStack;
                    block14: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        Attribute attribute = Attribute.forName(reader.getAttributeName(i));
                        switch (attribute) {
                            case NAME: {
                                continue block14;
                            }
                            case STACK: {
                                stack = reader.getAttributeValue(i);
                                continue block14;
                            }
                            case CLUSTER: {
                                cluster = reader.getAttributeValue(i);
                                continue block14;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute(reader, i);
                            }
                        }
                    }
                    ParseUtils.requireNoContent(reader);
                    remoteSites.addRemoteSite(stackName, remoteSite, cluster, stack);
                    continue block13;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        return remoteSites;
    }

    private void parseStackFile(ConfigurationReader reader, ConfigurationBuilderHolder holder, String name) {
        String path = ParseUtils.requireAttributes(reader, Attribute.PATH)[0];
        ParseUtils.requireNoContent(reader);
        this.addJGroupsStackFile(holder, name, path, reader.getProperties(), reader.getResourceResolver());
    }

    private void parseContainer(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        holder.pushScope(ParserScope.CACHE_CONTAINER);
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        block32: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) continue;
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    builder.cacheManagerName(value);
                    continue block32;
                }
                case DEFAULT_CACHE: {
                    builder.defaultCacheName(value);
                    continue block32;
                }
                case ALIASES: 
                case JNDI_NAME: 
                case MODULE: 
                case START: 
                case ASYNC_EXECUTOR: 
                case PERSISTENCE_EXECUTOR: {
                    ParseUtils.removedSince(reader, 11, 0);
                    ParseUtils.ignoreAttribute(reader, i);
                    continue block32;
                }
                case LISTENER_EXECUTOR: {
                    builder.listenerThreadPoolName(value);
                    builder.listenerThreadPool().read(this.createThreadPoolConfiguration(value, "org.infinispan.executors.notification", holder), holder.getCombine());
                    continue block32;
                }
                case EVICTION_EXECUTOR: {
                    ParseUtils.removedSince(reader, 11, 0);
                    Log.CONFIG.evictionExecutorDeprecated();
                }
                case EXPIRATION_EXECUTOR: {
                    builder.expirationThreadPoolName(value);
                    builder.expirationThreadPool().read(this.createThreadPoolConfiguration(value, "org.infinispan.executors.expiration", holder), holder.getCombine());
                    continue block32;
                }
                case NON_BLOCKING_EXECUTOR: {
                    builder.nonBlockingThreadPoolName(value);
                    builder.nonBlockingThreadPool().read(this.createThreadPoolConfiguration(value, "org.infinispan.executors.non-blocking", holder), holder.getCombine());
                    continue block32;
                }
                case BLOCKING_EXECUTOR: {
                    builder.blockingThreadPoolName(value);
                    builder.blockingThreadPool().read(this.createThreadPoolConfiguration(value, "org.infinispan.executors.blocking", holder), holder.getCombine());
                    continue block32;
                }
                case STATISTICS: {
                    boolean statistics = ParseUtils.parseBoolean(reader, i, value);
                    builder.cacheContainer().statistics(statistics);
                    if (reader.getSchema().since(10, 1)) continue block32;
                    builder.jmx().enabled(statistics);
                    continue block32;
                }
                case SHUTDOWN_HOOK: {
                    builder.shutdown().hookBehavior(ParseUtils.parseEnum(reader, i, ShutdownHookBehavior.class, value));
                    continue block32;
                }
                case ZERO_CAPACITY_NODE: {
                    builder.zeroCapacityNode(ParseUtils.parseBoolean(reader, i, value));
                    continue block32;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block33: while (reader.inTag((Enum)Element.CACHE_CONTAINER)) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CACHES: {
                    this.parseCaches(reader, holder);
                    continue block33;
                }
                case TRANSPORT: {
                    this.parseTransport(reader, holder);
                    continue block33;
                }
                case LOCAL_CACHE: {
                    this.parseLocalCache(reader, holder, ParseUtils.requireAttributes(reader, Attribute.NAME)[0], false);
                    continue block33;
                }
                case LOCAL_CACHE_CONFIGURATION: {
                    this.parseLocalCache(reader, holder, ParseUtils.requireAttributes(reader, Attribute.NAME)[0], true);
                    continue block33;
                }
                case INVALIDATION_CACHE: {
                    this.parseInvalidationCache(reader, holder, ParseUtils.requireAttributes(reader, Attribute.NAME)[0], false);
                    continue block33;
                }
                case INVALIDATION_CACHE_CONFIGURATION: {
                    this.parseInvalidationCache(reader, holder, ParseUtils.requireAttributes(reader, Attribute.NAME)[0], true);
                    continue block33;
                }
                case REPLICATED_CACHE: {
                    this.parseReplicatedCache(reader, holder, ParseUtils.requireAttributes(reader, Attribute.NAME)[0], false);
                    continue block33;
                }
                case REPLICATED_CACHE_CONFIGURATION: {
                    this.parseReplicatedCache(reader, holder, ParseUtils.requireAttributes(reader, Attribute.NAME)[0], true);
                    continue block33;
                }
                case DISTRIBUTED_CACHE: {
                    this.parseDistributedCache(reader, holder, ParseUtils.requireAttributes(reader, Attribute.NAME)[0], false);
                    continue block33;
                }
                case DISTRIBUTED_CACHE_CONFIGURATION: {
                    this.parseDistributedCache(reader, holder, ParseUtils.requireAttributes(reader, Attribute.NAME)[0], true);
                    continue block33;
                }
                case SCATTERED_CACHE: 
                case SCATTERED_CACHE_CONFIGURATION: {
                    ParseUtils.removedSince(reader, 15, 0);
                    this.parseScatteredCache(reader, holder, element);
                    continue block33;
                }
                case SERIALIZATION: {
                    this.parseSerialization(reader, holder);
                    continue block33;
                }
                case METRICS: {
                    this.parseMetrics(reader, holder);
                    continue block33;
                }
                case TRACING: {
                    this.parseTracing(reader, holder);
                    continue block33;
                }
                case JMX: {
                    this.parseJmx(reader, holder);
                    continue block33;
                }
                case SECURITY: {
                    this.parseGlobalSecurity(reader, holder);
                    continue block33;
                }
                case GLOBAL_STATE: {
                    this.parseGlobalState(reader, holder);
                    continue block33;
                }
            }
            reader.handleAny((ConfigurationReaderContext)holder);
        }
        holder.popScope();
    }

    private void parseCaches(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        while (reader.inTag((Enum)Element.CACHES)) {
            Map.Entry mapElement = reader.getMapItem((Enum)Attribute.NAME);
            String name = (String)mapElement.getKey();
            Element type = Element.forName((String)mapElement.getValue());
            switch (type) {
                case LOCAL_CACHE: {
                    this.parseLocalCache(reader, holder, name, false);
                    break;
                }
                case LOCAL_CACHE_CONFIGURATION: {
                    this.parseLocalCache(reader, holder, name, true);
                    break;
                }
                case INVALIDATION_CACHE: {
                    this.parseInvalidationCache(reader, holder, name, false);
                    break;
                }
                case INVALIDATION_CACHE_CONFIGURATION: {
                    this.parseInvalidationCache(reader, holder, name, true);
                    break;
                }
                case REPLICATED_CACHE: {
                    this.parseReplicatedCache(reader, holder, name, false);
                    break;
                }
                case REPLICATED_CACHE_CONFIGURATION: {
                    this.parseReplicatedCache(reader, holder, name, true);
                    break;
                }
                case DISTRIBUTED_CACHE: {
                    this.parseDistributedCache(reader, holder, name, false);
                    break;
                }
                case DISTRIBUTED_CACHE_CONFIGURATION: {
                    this.parseDistributedCache(reader, holder, name, true);
                    break;
                }
                case SCATTERED_CACHE: 
                case SCATTERED_CACHE_CONFIGURATION: {
                    this.parseScatteredCache(reader, holder, type);
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedElement(reader, type);
                }
            }
            reader.endMapItem();
        }
    }

    private void parseGlobalSecurity(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        GlobalSecurityConfigurationBuilder security = holder.getGlobalConfigurationBuilder().security();
        ParseUtils.parseAttributes(reader, security);
        block3: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case AUTHORIZATION: {
                    this.parseGlobalAuthorization(reader, holder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseGlobalAuthorization(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        GlobalAuthorizationConfigurationBuilder builder = holder.getGlobalConfigurationBuilder().security().authorization().enable();
        Boolean groupOnlyMapping = reader.getSchema().since(15, 0) ? null : Boolean.valueOf(false);
        block15: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case AUDIT_LOGGER: {
                    builder.auditLogger((AuditLogger)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block15;
                }
                case GROUP_ONLY_MAPPING: {
                    groupOnlyMapping = ParseUtils.parseBoolean(reader, i, value);
                    continue block15;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        PrincipalRoleMapper roleMapper = null;
        RolePermissionMapper permissionMapper = null;
        block16: while (reader.hasNext()) {
            reader.nextElement();
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case AUTHORIZATION: {
                    reader.require(ConfigurationReader.ElementType.END_ELEMENT);
                    if (permissionMapper != null) {
                        builder.rolePermissionMapper(permissionMapper);
                    }
                    if (roleMapper != null) {
                        builder.principalRoleMapper(roleMapper);
                    }
                    if (groupOnlyMapping != null) {
                        builder.groupOnlyMapping(groupOnlyMapping);
                    }
                    return;
                }
                case CLUSTER_PERMISSION_MAPPER: {
                    if (permissionMapper != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    ParseUtils.requireNoAttributes(reader);
                    ParseUtils.requireNoContent(reader);
                    permissionMapper = new ClusterPermissionMapper();
                    continue block16;
                }
                case CUSTOM_PERMISSION_MAPPER: {
                    if (permissionMapper != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    permissionMapper = this.parseCustomPermissionMapper(reader, holder);
                    continue block16;
                }
                case IDENTITY_ROLE_MAPPER: {
                    if (roleMapper != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    ParseUtils.requireNoAttributes(reader);
                    ParseUtils.requireNoContent(reader);
                    roleMapper = new IdentityRoleMapper();
                    continue block16;
                }
                case COMMON_NAME_ROLE_MAPPER: {
                    if (roleMapper != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    ParseUtils.requireNoAttributes(reader);
                    ParseUtils.requireNoContent(reader);
                    roleMapper = new CommonNameRoleMapper();
                    continue block16;
                }
                case CLUSTER_ROLE_MAPPER: {
                    if (roleMapper != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    roleMapper = this.parseClusterRoleMapper(reader);
                    continue block16;
                }
                case CUSTOM_ROLE_MAPPER: {
                    if (roleMapper != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    roleMapper = this.parseCustomRoleMapper(reader, holder);
                    continue block16;
                }
                case ROLES: {
                    while (reader.inTag()) {
                        Map.Entry item = reader.getMapItem((Enum)Attribute.NAME);
                        this.parseGlobalRole(reader, builder, (String)item.getKey());
                        reader.endMapItem();
                    }
                    continue block16;
                }
                case ROLE: {
                    this.parseGlobalRole(reader, builder, null);
                    continue block16;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private ClusterRoleMapper parseClusterRoleMapper(ConfigurationReader reader) {
        ParseUtils.requireNoAttributes(reader);
        ClusterRoleMapper mapper = new ClusterRoleMapper();
        while (reader.inTag()) {
            if (Element.forName(reader.getLocalName()) != Element.NAME_REWRITER) continue;
            block10: while (reader.inTag()) {
                switch (Element.forName(reader.getLocalName())) {
                    case CASE_PRINCIPAL_TRANSFORMER: {
                        boolean uppercase = true;
                        for (int i = 0; i < reader.getAttributeCount(); ++i) {
                            ParseUtils.requireNoNamespaceAttribute(reader, i);
                            String value = reader.getAttributeValue(i);
                            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
                            if (Objects.requireNonNull(attribute) != Attribute.UPPERCASE) {
                                throw ParseUtils.unexpectedAttribute(reader, i);
                            }
                            uppercase = ParseUtils.parseBoolean(reader, i, value);
                        }
                        mapper.nameRewriter(new CaseNameRewriter(uppercase));
                        ParseUtils.requireNoContent(reader);
                        continue block10;
                    }
                    case COMMON_NAME_PRINCIPAL_TRANSFORMER: {
                        ParseUtils.requireNoAttributes(reader);
                        mapper.nameRewriter(new RegexNameRewriter(Pattern.compile("cn=([^,]+),.*", 2), "$1", false));
                        ParseUtils.requireNoContent(reader);
                        continue block10;
                    }
                    case REGEX_PRINCIPAL_TRANSFORMER: {
                        String[] attributes = ParseUtils.requireAttributes(reader, Attribute.PATTERN, Attribute.REPLACEMENT);
                        boolean replaceAll = false;
                        block12: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                            ParseUtils.requireNoNamespaceAttribute(reader, i);
                            String value = reader.getAttributeValue(i);
                            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
                            switch (attribute) {
                                case NAME: 
                                case PATTERN: 
                                case REPLACEMENT: {
                                    continue block12;
                                }
                                case REPLACE_ALL: {
                                    replaceAll = ParseUtils.parseBoolean(reader, i, value);
                                    continue block12;
                                }
                                default: {
                                    throw ParseUtils.unexpectedAttribute(reader, i);
                                }
                            }
                        }
                        mapper.nameRewriter(new RegexNameRewriter(Pattern.compile(attributes[0]), attributes[1], replaceAll));
                        ParseUtils.requireNoContent(reader);
                        continue block10;
                    }
                }
                throw ParseUtils.unexpectedElement(reader);
            }
        }
        return mapper;
    }

    private PrincipalRoleMapper parseCustomRoleMapper(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        String mapperClass = ParseUtils.requireSingleAttribute(reader, Attribute.CLASS.getLocalName());
        ParseUtils.requireNoContent(reader);
        return (PrincipalRoleMapper)Util.getInstance((String)mapperClass, (ClassLoader)holder.getClassLoader());
    }

    private RolePermissionMapper parseCustomPermissionMapper(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        String mapperClass = ParseUtils.requireSingleAttribute(reader, Attribute.CLASS.getLocalName());
        ParseUtils.requireNoContent(reader);
        return (RolePermissionMapper)Util.getInstance((String)mapperClass, (ClassLoader)holder.getClassLoader());
    }

    private void parseGlobalRole(ConfigurationReader reader, GlobalAuthorizationConfigurationBuilder builder, String name) {
        if (name == null) {
            name = ParseUtils.requireAttributes(reader, Attribute.NAME.getLocalName())[0];
        }
        String description = null;
        String[] permissions = null;
        GlobalRoleConfigurationBuilder role = builder.role(name);
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    continue block5;
                }
                case PERMISSIONS: {
                    permissions = reader.getListAttributeValue(i);
                    continue block5;
                }
                case DESCRIPTION: {
                    description = reader.getAttributeValue(i);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        role.description(description);
        if (permissions == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.PERMISSIONS));
        }
        role.permission(permissions);
        ParseUtils.requireNoContent(reader);
    }

    private void parseMetrics(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case GAUGES: {
                    builder.metrics().gauges(ParseUtils.parseBoolean(reader, i, value));
                    continue block7;
                }
                case HISTOGRAMS: {
                    builder.metrics().histograms(ParseUtils.parseBoolean(reader, i, value));
                    continue block7;
                }
                case PREFIX: {
                    builder.metrics().prefix(value);
                    continue block7;
                }
                case NAMES_AS_TAGS: {
                    builder.metrics().namesAsTags(ParseUtils.parseBoolean(reader, i, value));
                    continue block7;
                }
                case ACCURATE_SIZE: {
                    builder.metrics().accurateSize(ParseUtils.parseBoolean(reader, i, value));
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseTracing(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case COLLECTOR_ENDPOINT: {
                    builder.tracing().collectorEndpoint(value);
                    continue block7;
                }
                case ENABLED: {
                    builder.tracing().enabled(ParseUtils.parseBoolean(reader, i, value));
                    continue block7;
                }
                case EXPORTER_PROTOCOL: {
                    builder.tracing().exporterProtocol(ParseUtils.parseEnum(reader, i, TracingExporterProtocol.class, value));
                    continue block7;
                }
                case SERVICE_NAME: {
                    builder.tracing().serviceName(value);
                    continue block7;
                }
                case SECURITY: {
                    boolean security = ParseUtils.parseBoolean(reader, i, value);
                    builder.tracing().traceSecurity(security);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
    }

    private void parseJmx(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case ENABLED: {
                    builder.jmx().enabled(ParseUtils.parseBoolean(reader, i, value));
                    continue block6;
                }
                case DOMAIN: {
                    builder.jmx().domain(value);
                    continue block6;
                }
                case MBEAN_SERVER_LOOKUP: {
                    builder.jmx().mBeanServerLookup((MBeanServerLookup)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block6;
                }
                case ALLOW_DUPLICATE_DOMAINS: {
                    if (!reader.getSchema().since(11, 0)) {
                        ParseUtils.ignoreAttribute(reader, i);
                        continue block6;
                    }
                    throw ParseUtils.attributeRemoved(reader, i);
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        Properties properties = Parser.parseProperties(reader, Element.JMX);
        builder.jmx().withProperties(properties);
    }

    private void parseModules(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        while (reader.inTag()) {
            reader.handleAny((ConfigurationReaderContext)holder);
        }
    }

    private void parseTransport(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        if (holder.getGlobalConfigurationBuilder().transport().getTransport() == null) {
            holder.getGlobalConfigurationBuilder().transport().defaultTransport();
        }
        TransportConfigurationBuilder transport = holder.getGlobalConfigurationBuilder().transport();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            if (ParseUtils.isNoNamespaceAttribute(reader, i)) {
                Attribute attribute = Attribute.forName(reader.getAttributeName(i));
                switch (attribute) {
                    case STACK: {
                        transport.stack(value);
                        break;
                    }
                    case CLUSTER: {
                        transport.clusterName(value);
                        break;
                    }
                    case EXECUTOR: 
                    case REMOTE_COMMAND_EXECUTOR: {
                        ParseUtils.removedSince(reader, 11, 0);
                        break;
                    }
                    case LOCK_TIMEOUT: {
                        transport.distributedSyncTimeout(ParseUtils.parseLong(reader, i, value));
                        break;
                    }
                    case NODE_NAME: {
                        transport.nodeName(value);
                        holder.getGlobalConfigurationBuilder().threads().nodeName(value);
                        break;
                    }
                    case LOCKING: {
                        break;
                    }
                    case MACHINE_ID: {
                        transport.machineId(value);
                        break;
                    }
                    case RACK_ID: {
                        transport.rackId(value);
                        break;
                    }
                    case SITE: {
                        transport.siteId(value);
                        break;
                    }
                    case INITIAL_CLUSTER_SIZE: {
                        ParseUtils.introducedFrom(reader, 8, 2);
                        transport.initialClusterSize(ParseUtils.parseInt(reader, i, value));
                        break;
                    }
                    case INITIAL_CLUSTER_TIMEOUT: {
                        transport.initialClusterTimeout(ParseUtils.parseLong(reader, i, value), TimeUnit.MILLISECONDS);
                        break;
                    }
                    case RAFT_MEMBERS: {
                        transport.raftMembers(reader.getListAttributeValue(i));
                        break;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute(reader, i);
                    }
                }
                continue;
            }
            reader.handleAttribute((ConfigurationReaderContext)holder, i);
        }
        Properties properties = Parser.parseProperties(reader, Element.TRANSPORT);
        for (Map.Entry<Object, Object> propertyEntry : properties.entrySet()) {
            transport.addProperty((String)propertyEntry.getKey(), propertyEntry.getValue());
        }
    }

    private void parseGlobalState(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        GlobalStateConfigurationBuilder builder = holder.getGlobalConfigurationBuilder().globalState().enable();
        ParseUtils.parseAttributes(reader, builder);
        ConfigurationStorage storage = null;
        block10: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PERSISTENT_LOCATION: {
                    this.parseGlobalStatePath(reader, builder::persistentLocation);
                    continue block10;
                }
                case SHARED_PERSISTENT_LOCATION: {
                    this.parseGlobalStatePath(reader, builder::sharedPersistentLocation);
                    continue block10;
                }
                case TEMPORARY_LOCATION: {
                    this.parseGlobalStatePath(reader, builder::temporaryLocation);
                    continue block10;
                }
                case IMMUTABLE_CONFIGURATION_STORAGE: {
                    if (storage != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    storage = ConfigurationStorage.IMMUTABLE;
                    continue block10;
                }
                case VOLATILE_CONFIGURATION_STORAGE: {
                    if (storage != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    ParseUtils.requireNoAttributes(reader);
                    ParseUtils.requireNoContent(reader);
                    storage = ConfigurationStorage.VOLATILE;
                    continue block10;
                }
                case OVERLAY_CONFIGURATION_STORAGE: {
                    if (storage != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    ParseUtils.requireNoAttributes(reader);
                    ParseUtils.requireNoContent(reader);
                    storage = ConfigurationStorage.OVERLAY;
                    continue block10;
                }
                case MANAGED_CONFIGURATION_STORAGE: {
                    if (storage != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    throw Log.CONFIG.managerConfigurationStorageUnavailable();
                }
                case CUSTOM_CONFIGURATION_STORAGE: {
                    if (storage != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    storage = ConfigurationStorage.CUSTOM;
                    builder.configurationStorageSupplier(this.parseCustomConfigurationStorage(reader, holder));
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        if (storage != null) {
            builder.configurationStorage(storage);
        }
    }

    private void parseGlobalStatePath(ConfigurationReader reader, BiConsumer<String, String> pathItems) {
        String path = ParseUtils.requireAttributes(reader, Attribute.PATH.getLocalName())[0];
        String relativeTo = null;
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case RELATIVE_TO: {
                    relativeTo = ParseUtils.requireAttributeProperty(reader, i);
                    continue block4;
                }
                case PATH: {
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
        pathItems.accept(path, relativeTo);
    }

    private Supplier<? extends LocalConfigurationStorage> parseCustomConfigurationStorage(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        String storageClass = ParseUtils.requireSingleAttribute(reader, Attribute.CLASS.getLocalName());
        ParseUtils.requireNoContent(reader);
        return Util.getInstanceSupplier((String)storageClass, (ClassLoader)holder.getClassLoader());
    }

    private ThreadPoolConfiguration createThreadPoolConfiguration(String threadPoolName, String componentName, ConfigurationBuilderHolder holder) {
        ThreadsConfigurationBuilder threads = holder.getGlobalConfigurationBuilder().threads();
        ThreadPoolBuilderAdapter threadPool = threads.getThreadPool(threadPoolName);
        if (threadPool == null) {
            throw Log.CONFIG.undefinedThreadPoolName(threadPoolName);
        }
        ThreadPoolConfiguration threadPoolConfiguration = threadPool.asThreadPoolConfigurationBuilder();
        boolean isNonBlocking = threadPoolConfiguration.threadPoolFactory().createsNonBlockingThreads();
        if ("org.infinispan.executors.non-blocking".equals(componentName) && !isNonBlocking) {
            throw Log.CONFIG.threadPoolFactoryIsBlocking(threadPoolName, componentName);
        }
        DefaultThreadFactory threadFactory = (DefaultThreadFactory)threadPoolConfiguration.threadFactory();
        if (threadFactory != null) {
            threadFactory.setComponent(KnownComponentNames.shortened(componentName));
        }
        return threadPoolConfiguration;
    }

    @Deprecated(forRemoval=true, since="12.0")
    public static void parseStoreAttribute(ConfigurationReader reader, int index, AbstractStoreConfigurationBuilder<?, ?> storeBuilder) {
        CacheParser.parseStoreAttribute(reader, index, storeBuilder);
    }

    @Deprecated(forRemoval=true, since="12.0")
    public static void parseStoreElement(ConfigurationReader reader, StoreConfigurationBuilder<?, ?> storeBuilder) {
        CacheParser.parseStoreElement(reader, storeBuilder);
    }

    @Deprecated(forRemoval=true, since="12.0")
    public static void parseStoreWriteBehind(ConfigurationReader reader, AsyncStoreConfigurationBuilder<?> storeBuilder) {
        CacheParser.parseStoreWriteBehind(reader, storeBuilder);
    }

    @Deprecated(forRemoval=true, since="12.0")
    public static void parseStoreProperty(ConfigurationReader reader, StoreConfigurationBuilder<?, ?> storeBuilder) {
        String property = ParseUtils.requireSingleAttribute(reader, Attribute.NAME.getLocalName());
        String value = reader.getElementText();
        storeBuilder.addProperty(property, value);
    }

    private void addJGroupsDefaultStacksIfNeeded(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        if (!holder.hasJGroupsStack("tcp")) {
            holder.addJGroupsStack(BuiltinJGroupsChannelConfigurator.TCP(reader.getProperties()));
            holder.addJGroupsStack(BuiltinJGroupsChannelConfigurator.UDP(reader.getProperties()));
            holder.addJGroupsStack(BuiltinJGroupsChannelConfigurator.KUBERNETES(reader.getProperties()));
            holder.addJGroupsStack(BuiltinJGroupsChannelConfigurator.EC2(reader.getProperties()));
            holder.addJGroupsStack(BuiltinJGroupsChannelConfigurator.GOOGLE(reader.getProperties()));
            holder.addJGroupsStack(BuiltinJGroupsChannelConfigurator.AZURE(reader.getProperties()));
            holder.addJGroupsStack(BuiltinJGroupsChannelConfigurator.TUNNEL(reader.getProperties()));
        }
    }
}

