/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.util.EnumSet;
import java.util.Iterator;
import org.wildfly.security.ssl.CipherSuitePredicate;
import org.wildfly.security.ssl.KeyAgreement;
import org.wildfly.security.ssl.MechanismDatabase;

final class KeyAgreementCipherSuitePredicate
extends CipherSuitePredicate {
    private final EnumSet<KeyAgreement> set;

    KeyAgreementCipherSuitePredicate(EnumSet<KeyAgreement> set) {
        this.set = set;
    }

    @Override
    void toString(StringBuilder b) {
        b.append("key agreement is one of (");
        Iterator iterator = this.set.iterator();
        if (iterator.hasNext()) {
            KeyAgreement keyAgreement = (KeyAgreement)((Object)iterator.next());
            b.append((Object)keyAgreement);
            while (iterator.hasNext()) {
                keyAgreement = (KeyAgreement)((Object)iterator.next());
                b.append(", ");
                b.append((Object)keyAgreement);
            }
        }
        b.append(')');
    }

    @Override
    public boolean test(MechanismDatabase.Entry entry) {
        return this.set.contains((Object)entry.getKeyAgreement());
    }

    @Override
    boolean isAlwaysTrue() {
        return this.set.size() == KeyAgreement.fullSize;
    }

    @Override
    boolean isAlwaysFalse() {
        return this.set.isEmpty();
    }
}

