/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.keycloak.common.util.CollectionUtil;

public interface MultivaluedMap<K, V>
extends Map<K, List<V>> {
    default public void putSingle(K key, V value) {
        List<V> list = this.createListInstance();
        list.add(value);
        this.put(key, list);
    }

    default public void addAll(K key, V ... newValues) {
        for (V value : newValues) {
            this.add(key, value);
        }
    }

    default public void addAll(K key, List<V> valueList) {
        for (V value : valueList) {
            this.add(key, value);
        }
    }

    default public void addFirst(K key, V value) {
        this.getList(key).add(0, value);
    }

    default public void add(K key, V value) {
        this.getList(key).add(value);
    }

    default public void addMultiple(K key, Collection<V> values) {
        this.getList(key).addAll(values);
    }

    default public V getFirst(K key) {
        return Optional.ofNullable((List)this.get(key)).filter(l -> !l.isEmpty()).map(l -> l.get(0)).orElse(null);
    }

    default public List<V> getList(K key) {
        return this.compute(key, (k, v) -> v != null ? v : this.createListInstance());
    }

    default public void addAll(MultivaluedMap<K, V> other) {
        for (Map.Entry entry : other.entrySet()) {
            this.getList(entry.getKey()).addAll((Collection)entry.getValue());
        }
    }

    default public boolean equalsIgnoreValueOrder(MultivaluedMap<K, V> omap) {
        if (this == omap) {
            return true;
        }
        if (!this.keySet().equals(omap.keySet())) {
            return false;
        }
        for (Map.Entry e : this.entrySet()) {
            List olist;
            List list = (List)e.getValue();
            if (CollectionUtil.collectionEquals(list, olist = (List)omap.get(e.getKey()))) continue;
            return false;
        }
        return true;
    }

    default public List<V> createListInstance() {
        return new ArrayList();
    }
}

