/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConvertWith;
import io.quarkus.runtime.configuration.TrimmedStringConverter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@ConfigGroup
public class HibernateOrmRuntimeConfigPersistenceUnit {
    @ConfigItem(defaultValueDocumentation="'true' if Hibernate ORM is enabled; 'false' otherwise")
    public Optional<Boolean> active = Optional.empty();
    @ConfigItem
    public HibernateOrmConfigPersistenceUnitDatabase database = new HibernateOrmConfigPersistenceUnitDatabase();
    @ConfigItem
    public HibernateOrmConfigPersistenceUnitScripts scripts = new HibernateOrmConfigPersistenceUnitScripts();
    @ConfigItem
    public HibernateOrmConfigPersistenceUnitLog log = new HibernateOrmConfigPersistenceUnitLog();
    @ConfigItem
    public Map<String, String> unsupportedProperties = new HashMap<String, String>();

    public boolean isAnyPropertySet() {
        return this.database.isAnyPropertySet() || this.scripts.isAnyPropertySet() || this.log.isAnyPropertySet() || !this.unsupportedProperties.isEmpty();
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitDatabase {
        @ConfigItem
        public HibernateOrmConfigPersistenceUnitDatabaseGeneration generation = new HibernateOrmConfigPersistenceUnitDatabaseGeneration();
        @ConfigItem
        @ConvertWith(value=TrimmedStringConverter.class)
        public Optional<String> defaultCatalog = Optional.empty();
        @ConfigItem
        @ConvertWith(value=TrimmedStringConverter.class)
        public Optional<String> defaultSchema = Optional.empty();

        public boolean isAnyPropertySet() {
            return this.generation.isAnyPropertySet() || this.defaultCatalog.isPresent() || this.defaultSchema.isPresent();
        }
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitScripts {
        @ConfigItem
        public HibernateOrmConfigPersistenceUnitScriptGeneration generation = new HibernateOrmConfigPersistenceUnitScriptGeneration();

        public boolean isAnyPropertySet() {
            return this.generation.isAnyPropertySet();
        }
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitLog {
        @ConfigItem
        public boolean sql = false;
        @ConfigItem(defaultValue="true")
        public boolean formatSql = true;
        @ConfigItem(defaultValueDocumentation="depends on dialect")
        public Optional<Boolean> jdbcWarnings = Optional.empty();
        @ConfigItem
        public Optional<Long> queriesSlowerThanMs = Optional.empty();

        public boolean isAnyPropertySet() {
            return this.sql || !this.formatSql || this.jdbcWarnings.isPresent() || this.queriesSlowerThanMs.isPresent();
        }
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitScriptGeneration {
        @ConfigItem(name="<<parent>>", defaultValue="none")
        @ConvertWith(value=TrimmedStringConverter.class)
        public String generation = "none";
        @ConfigItem
        @ConvertWith(value=TrimmedStringConverter.class)
        public Optional<String> createTarget = Optional.empty();
        @ConfigItem
        @ConvertWith(value=TrimmedStringConverter.class)
        public Optional<String> dropTarget = Optional.empty();

        public boolean isAnyPropertySet() {
            return !"none".equals(this.generation) || this.createTarget.isPresent() || this.dropTarget.isPresent();
        }
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitDatabaseGeneration {
        @ConfigItem(name="<<parent>>", defaultValue="none")
        @ConvertWith(value=TrimmedStringConverter.class)
        public String generation = "none";
        @ConfigItem
        public boolean createSchemas = false;
        @ConfigItem
        public boolean haltOnError = false;

        public boolean isAnyPropertySet() {
            return !"none".equals(this.generation) || this.createSchemas || this.haltOnError;
        }
    }
}

