/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.DecoderException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.ClientTopology;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

@Immutable
public abstract class HotRodOperation<T>
extends CompletableFuture<T>
implements HotRodConstants,
Runnable {
    private static final Log log = LogFactory.getLog(HotRodOperation.class);
    private static final AtomicLong MSG_ID = new AtomicLong(1L);
    protected final Codec codec;
    protected final Configuration cfg;
    protected final ChannelFactory channelFactory;
    protected final HeaderParams header;
    protected volatile ScheduledFuture<?> timeoutFuture;
    private Channel channel;
    private static final byte NO_TX = 0;
    private static final byte XA_TX = 1;

    protected HotRodOperation(short requestCode, short responseCode, Codec codec, int flags, Configuration cfg, byte[] cacheName, AtomicReference<ClientTopology> clientTopology, ChannelFactory channelFactory, DataFormat dataFormat) {
        this.cfg = cfg;
        this.codec = codec;
        this.channelFactory = channelFactory;
        this.header = new HeaderParams(requestCode, responseCode, flags, 0, MSG_ID.getAndIncrement(), dataFormat, clientTopology).cacheName(cacheName).topologyAge(channelFactory.getTopologyAge());
    }

    protected HotRodOperation(short requestCode, short responseCode, Codec codec, int flags, Configuration cfg, byte[] cacheName, AtomicReference<ClientTopology> clientTopology, ChannelFactory channelFactory) {
        this(requestCode, responseCode, codec, flags, cfg, cacheName, clientTopology, channelFactory, null);
    }

    public abstract CompletableFuture<T> execute();

    public HeaderParams header() {
        return this.header;
    }

    protected void sendHeaderAndRead(Channel channel) {
        this.scheduleRead(channel);
        this.sendHeader(channel);
    }

    protected void sendHeader(Channel channel) {
        ByteBuf buf = channel.alloc().buffer(this.codec.estimateHeaderSize(this.header));
        this.codec.writeHeader(buf, this.header);
        channel.writeAndFlush((Object)buf);
    }

    protected void scheduleRead(Channel channel) {
        ((HeaderDecoder)channel.pipeline().get(HeaderDecoder.class)).registerOperation(channel, this);
    }

    public void releaseChannel(Channel channel) {
        this.channelFactory.releaseChannel(channel);
    }

    public void channelInactive(Channel channel) {
        SocketAddress address = channel.remoteAddress();
        this.completeExceptionally(log.connectionClosed(address, address));
    }

    public void exceptionCaught(Channel channel, Throwable cause) {
        while (cause instanceof DecoderException && cause.getCause() != null) {
            cause = cause.getCause();
        }
        try {
            if (this.closeChannelForCause(cause)) {
                Log.HOTROD.closingChannelAfterError(channel, cause);
                channel.close();
            }
        }
        finally {
            this.completeExceptionally(cause);
        }
    }

    protected final boolean isServerError(Throwable t) {
        return t instanceof HotRodClientException && ((HotRodClientException)t).isServerError();
    }

    protected final boolean closeChannelForCause(Throwable t) {
        return !this.isServerError(t) && !(t instanceof SocketTimeoutException);
    }

    protected void sendArrayOperation(Channel channel, byte[] array) {
        ByteBuf buf = channel.alloc().buffer(this.codec.estimateHeaderSize(this.header) + ByteBufUtil.estimateArraySize(array));
        this.codec.writeHeader(buf, this.header);
        ByteBufUtil.writeArray(buf, array);
        channel.writeAndFlush((Object)buf);
    }

    public abstract void acceptResponse(ByteBuf var1, short var2, HeaderDecoder var3);

    @Override
    public String toString() {
        String cn = this.cacheName() == null || this.cacheName().length == 0 ? "(default)" : new String(this.cacheName());
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.getClass().getSimpleName()).append('{').append(cn);
        this.addParams(sb);
        sb.append(", flags=").append(Integer.toHexString(this.flags()));
        if (this.channel != null) {
            sb.append(", connection=").append(this.channel.remoteAddress());
        }
        sb.append('}');
        return sb.toString();
    }

    protected void addParams(StringBuilder sb) {
    }

    @Override
    public boolean complete(T value) {
        this.cancelTimeout();
        return super.complete(value);
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        this.cancelTimeout();
        return super.completeExceptionally(ex);
    }

    public void scheduleTimeout(Channel channel) {
        assert (this.timeoutFuture == null) : String.valueOf(this) + " is trying to override a timeout";
        this.channel = channel;
        this.timeoutFuture = channel.eventLoop().schedule((Runnable)this, (long)this.channelFactory.socketTimeout(), TimeUnit.MILLISECONDS);
    }

    private void cancelTimeout() {
        if (this.timeoutFuture != null) {
            this.timeoutFuture.cancel(false);
        }
    }

    @Override
    public void run() {
        this.exceptionCaught(this.channel, new SocketTimeoutException(String.valueOf(this) + " timed out after " + this.channelFactory.socketTimeout() + " ms"));
    }

    public final DataFormat dataFormat() {
        return this.header.dataFormat();
    }

    protected final byte[] cacheName() {
        return this.header.cacheName();
    }

    protected final int flags() {
        return this.header.flags();
    }

    public Codec getCodec() {
        return this.codec;
    }
}

