/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * atan(0.0, 1e-10) => 0.0
 * atan(0.0, -1e-10) => 3.1415927
 * atan(0.0, 0.1) => 0.0
 * atan(0.0, -0.1) => 3.1415927
 * atan(0.0, 1.0) => 0.0
 * atan(0.0, -1.0) => 3.1415927
 * atan(0.0, 10.0) => 0.0
 * atan(0.0, -10.0) => 3.1415927
 * atan(0.0, 10000000000.0) => 0.0
 * atan(0.0, -10000000000.0) => 3.1415927
 * atan(1e-10, 0.0) => 1.5707964
 * atan(1e-10, 1e-10) => 0.7853982
 * atan(1e-10, -1e-10) => 2.3561945
 * atan(1e-10, 0.1) => 1e-09
 * atan(1e-10, -0.1) => 3.1415927
 * atan(1e-10, 1.0) => 1e-10
 * atan(1e-10, -1.0) => 3.1415927
 * atan(1e-10, 10.0) => 1e-11
 * atan(1e-10, -10.0) => 3.1415927
 * atan(1e-10, 10000000000.0) => 1.00000005e-20
 * atan(1e-10, -10000000000.0) => 3.1415927
 * atan(-1e-10, 0.0) => -1.5707964
 * atan(-1e-10, 1e-10) => -0.7853982
 * atan(-1e-10, -1e-10) => -2.3561945
 * atan(-1e-10, 0.1) => -1e-09
 * atan(-1e-10, -0.1) => -3.1415927
 * atan(-1e-10, 1.0) => -1e-10
 * atan(-1e-10, -1.0) => -3.1415927
 * atan(-1e-10, 10.0) => -1e-11
 * atan(-1e-10, -10.0) => -3.1415927
 * atan(-1e-10, 10000000000.0) => -1.00000005e-20
 * atan(-1e-10, -10000000000.0) => -3.1415927
 * atan(0.1, 0.0) => 1.5707964
 * atan(0.1, 1e-10) => 1.5707964
 * atan(0.1, -1e-10) => 1.5707964
 * atan(0.1, 0.1) => 0.7853982
 * atan(0.1, -0.1) => 2.3561945
 * atan(0.1, 1.0) => 0.09966865
 * atan(0.1, -1.0) => 3.041924
 * atan(0.1, 10.0) => 0.009999667
 * atan(0.1, -10.0) => 3.131593
 * atan(0.1, 10000000000.0) => 1e-11
 * atan(0.1, -10000000000.0) => 3.1415927
 * atan(-0.1, 0.0) => -1.5707964
 * atan(-0.1, 1e-10) => -1.5707964
 * atan(-0.1, -1e-10) => -1.5707964
 * atan(-0.1, 0.1) => -0.7853982
 * atan(-0.1, -0.1) => -2.3561945
 * atan(-0.1, 1.0) => -0.09966865
 * atan(-0.1, -1.0) => -3.041924
 * atan(-0.1, 10.0) => -0.009999667
 * atan(-0.1, -10.0) => -3.131593
 * atan(-0.1, 10000000000.0) => -1e-11
 * atan(-0.1, -10000000000.0) => -3.1415927
 * atan(1.0, 0.0) => 1.5707964
 * atan(1.0, 1e-10) => 1.5707964
 * atan(1.0, -1e-10) => 1.5707964
 * atan(1.0, 0.1) => 1.4711276
 * atan(1.0, -0.1) => 1.670465
 * atan(1.0, 1.0) => 0.7853982
 * atan(1.0, -1.0) => 2.3561945
 * atan(1.0, 10.0) => 0.09966865
 * atan(1.0, -10.0) => 3.041924
 * atan(1.0, 10000000000.0) => 1e-10
 * atan(1.0, -10000000000.0) => 3.1415927
 * atan(-1.0, 0.0) => -1.5707964
 * atan(-1.0, 1e-10) => -1.5707964
 * atan(-1.0, -1e-10) => -1.5707964
 * atan(-1.0, 0.1) => -1.4711276
 * atan(-1.0, -0.1) => -1.670465
 * atan(-1.0, 1.0) => -0.7853982
 * atan(-1.0, -1.0) => -2.3561945
 * atan(-1.0, 10.0) => -0.09966865
 * atan(-1.0, -10.0) => -3.041924
 * atan(-1.0, 10000000000.0) => -1e-10
 * atan(-1.0, -10000000000.0) => -3.1415927
 * atan(10.0, 0.0) => 1.5707964
 * atan(10.0, 1e-10) => 1.5707964
 * atan(10.0, -1e-10) => 1.5707964
 * atan(10.0, 0.1) => 1.5607966
 * atan(10.0, -0.1) => 1.580796
 * atan(10.0, 1.0) => 1.4711276
 * atan(10.0, -1.0) => 1.670465
 * atan(10.0, 10.0) => 0.7853982
 * atan(10.0, -10.0) => 2.3561945
 * atan(10.0, 10000000000.0) => 1e-09
 * atan(10.0, -10000000000.0) => 3.1415927
 * atan(-10.0, 0.0) => -1.5707964
 * atan(-10.0, 1e-10) => -1.5707964
 * atan(-10.0, -1e-10) => -1.5707964
 * atan(-10.0, 0.1) => -1.5607966
 * atan(-10.0, -0.1) => -1.580796
 * atan(-10.0, 1.0) => -1.4711276
 * atan(-10.0, -1.0) => -1.670465
 * atan(-10.0, 10.0) => -0.7853982
 * atan(-10.0, -10.0) => -2.3561945
 * atan(-10.0, 10000000000.0) => -1e-09
 * atan(-10.0, -10000000000.0) => -3.1415927
 * atan(10000000000.0, 0.0) => 1.5707964
 * atan(10000000000.0, 1e-10) => 1.5707964
 * atan(10000000000.0, -1e-10) => 1.5707964
 * atan(10000000000.0, 0.1) => 1.5707964
 * atan(10000000000.0, -0.1) => 1.5707964
 * atan(10000000000.0, 1.0) => 1.5707964
 * atan(10000000000.0, -1.0) => 1.5707964
 * atan(10000000000.0, 10.0) => 1.5707964
 * atan(10000000000.0, -10.0) => 1.5707964
 * atan(10000000000.0, 10000000000.0) => 0.7853982
 * atan(10000000000.0, -10000000000.0) => 2.3561945
 * atan(-10000000000.0, 0.0) => -1.5707964
 * atan(-10000000000.0, 1e-10) => -1.5707964
 * atan(-10000000000.0, -1e-10) => -1.5707964
 * atan(-10000000000.0, 0.1) => -1.5707964
 * atan(-10000000000.0, -0.1) => -1.5707964
 * atan(-10000000000.0, 1.0) => -1.5707964
 * atan(-10000000000.0, -1.0) => -1.5707964
 * atan(-10000000000.0, 10.0) => -1.5707964
 * atan(-10000000000.0, -10.0) => -1.5707964
 * atan(-10000000000.0, 10000000000.0) => -0.7853982
 * atan(-10000000000.0, -10000000000.0) => -2.3561945
 */
#version 120

void main()
{
  float[distance(atan(0.0, 1e-10), 0.0) <= 1e-04 ? 1 : -1] array0;
  float[distance(atan(0.0, -1e-10), 3.1415927) <= 0.0031415927 ? 1 : -1] array1;
  float[distance(atan(0.0, 0.1), 0.0) <= 1e-04 ? 1 : -1] array2;
  float[distance(atan(0.0, -0.1), 3.1415927) <= 0.0031415927 ? 1 : -1] array3;
  float[distance(atan(0.0, 1.0), 0.0) <= 1e-04 ? 1 : -1] array4;
  float[distance(atan(0.0, -1.0), 3.1415927) <= 0.0031415927 ? 1 : -1] array5;
  float[distance(atan(0.0, 10.0), 0.0) <= 1e-04 ? 1 : -1] array6;
  float[distance(atan(0.0, -10.0), 3.1415927) <= 0.0031415927 ? 1 : -1] array7;
  float[distance(atan(0.0, 10000000000.0), 0.0) <= 1e-04 ? 1 : -1] array8;
  float[distance(atan(0.0, -10000000000.0), 3.1415927) <= 0.0031415927 ? 1 : -1] array9;
  float[distance(atan(1e-10, 0.0), 1.5707964) <= 0.0015707964 ? 1 : -1] array10;
  float[distance(atan(1e-10, 1e-10), 0.7853982) <= 0.0007853982 ? 1 : -1] array11;
  float[distance(atan(1e-10, -1e-10), 2.3561945) <= 0.0023561944 ? 1 : -1] array12;
  float[distance(atan(1e-10, 0.1), 1e-09) <= 1e-04 ? 1 : -1] array13;
  float[distance(atan(1e-10, -0.1), 3.1415927) <= 0.0031415927 ? 1 : -1] array14;
  float[distance(atan(1e-10, 1.0), 1e-10) <= 1e-04 ? 1 : -1] array15;
  float[distance(atan(1e-10, -1.0), 3.1415927) <= 0.0031415927 ? 1 : -1] array16;
  float[distance(atan(1e-10, 10.0), 1e-11) <= 1e-04 ? 1 : -1] array17;
  float[distance(atan(1e-10, -10.0), 3.1415927) <= 0.0031415927 ? 1 : -1] array18;
  float[distance(atan(1e-10, 10000000000.0), 1.00000005e-20) <= 1e-04 ? 1 : -1] array19;
  float[distance(atan(1e-10, -10000000000.0), 3.1415927) <= 0.0031415927 ? 1 : -1] array20;
  float[distance(atan(-1e-10, 0.0), -1.5707964) <= 0.0015707964 ? 1 : -1] array21;
  float[distance(atan(-1e-10, 1e-10), -0.7853982) <= 0.0007853982 ? 1 : -1] array22;
  float[distance(atan(-1e-10, -1e-10), -2.3561945) <= 0.0023561944 ? 1 : -1] array23;
  float[distance(atan(-1e-10, 0.1), -1e-09) <= 1e-04 ? 1 : -1] array24;
  float[distance(atan(-1e-10, -0.1), -3.1415927) <= 0.0031415927 ? 1 : -1] array25;
  float[distance(atan(-1e-10, 1.0), -1e-10) <= 1e-04 ? 1 : -1] array26;
  float[distance(atan(-1e-10, -1.0), -3.1415927) <= 0.0031415927 ? 1 : -1] array27;
  float[distance(atan(-1e-10, 10.0), -1e-11) <= 1e-04 ? 1 : -1] array28;
  float[distance(atan(-1e-10, -10.0), -3.1415927) <= 0.0031415927 ? 1 : -1] array29;
  float[distance(atan(-1e-10, 10000000000.0), -1.00000005e-20) <= 1e-04 ? 1 : -1] array30;
  float[distance(atan(-1e-10, -10000000000.0), -3.1415927) <= 0.0031415927 ? 1 : -1] array31;
  float[distance(atan(0.1, 0.0), 1.5707964) <= 0.0015707964 ? 1 : -1] array32;
  float[distance(atan(0.1, 1e-10), 1.5707964) <= 0.0015707964 ? 1 : -1] array33;
  float[distance(atan(0.1, -1e-10), 1.5707964) <= 0.0015707964 ? 1 : -1] array34;
  float[distance(atan(0.1, 0.1), 0.7853982) <= 0.0007853982 ? 1 : -1] array35;
  float[distance(atan(0.1, -0.1), 2.3561945) <= 0.0023561944 ? 1 : -1] array36;
  float[distance(atan(0.1, 1.0), 0.09966865) <= 1e-04 ? 1 : -1] array37;
  float[distance(atan(0.1, -1.0), 3.041924) <= 0.003041924 ? 1 : -1] array38;
  float[distance(atan(0.1, 10.0), 0.009999667) <= 1e-04 ? 1 : -1] array39;
  float[distance(atan(0.1, -10.0), 3.131593) <= 0.0031315929 ? 1 : -1] array40;
  float[distance(atan(0.1, 10000000000.0), 1e-11) <= 1e-04 ? 1 : -1] array41;
  float[distance(atan(0.1, -10000000000.0), 3.1415927) <= 0.0031415927 ? 1 : -1] array42;
  float[distance(atan(-0.1, 0.0), -1.5707964) <= 0.0015707964 ? 1 : -1] array43;
  float[distance(atan(-0.1, 1e-10), -1.5707964) <= 0.0015707964 ? 1 : -1] array44;
  float[distance(atan(-0.1, -1e-10), -1.5707964) <= 0.0015707964 ? 1 : -1] array45;
  float[distance(atan(-0.1, 0.1), -0.7853982) <= 0.0007853982 ? 1 : -1] array46;
  float[distance(atan(-0.1, -0.1), -2.3561945) <= 0.0023561944 ? 1 : -1] array47;
  float[distance(atan(-0.1, 1.0), -0.09966865) <= 1e-04 ? 1 : -1] array48;
  float[distance(atan(-0.1, -1.0), -3.041924) <= 0.003041924 ? 1 : -1] array49;
  float[distance(atan(-0.1, 10.0), -0.009999667) <= 1e-04 ? 1 : -1] array50;
  float[distance(atan(-0.1, -10.0), -3.131593) <= 0.0031315929 ? 1 : -1] array51;
  float[distance(atan(-0.1, 10000000000.0), -1e-11) <= 1e-04 ? 1 : -1] array52;
  float[distance(atan(-0.1, -10000000000.0), -3.1415927) <= 0.0031415927 ? 1 : -1] array53;
  float[distance(atan(1.0, 0.0), 1.5707964) <= 0.0015707964 ? 1 : -1] array54;
  float[distance(atan(1.0, 1e-10), 1.5707964) <= 0.0015707964 ? 1 : -1] array55;
  float[distance(atan(1.0, -1e-10), 1.5707964) <= 0.0015707964 ? 1 : -1] array56;
  float[distance(atan(1.0, 0.1), 1.4711276) <= 0.0014711276 ? 1 : -1] array57;
  float[distance(atan(1.0, -0.1), 1.670465) <= 0.001670465 ? 1 : -1] array58;
  float[distance(atan(1.0, 1.0), 0.7853982) <= 0.0007853982 ? 1 : -1] array59;
  float[distance(atan(1.0, -1.0), 2.3561945) <= 0.0023561944 ? 1 : -1] array60;
  float[distance(atan(1.0, 10.0), 0.09966865) <= 1e-04 ? 1 : -1] array61;
  float[distance(atan(1.0, -10.0), 3.041924) <= 0.003041924 ? 1 : -1] array62;
  float[distance(atan(1.0, 10000000000.0), 1e-10) <= 1e-04 ? 1 : -1] array63;
  float[distance(atan(1.0, -10000000000.0), 3.1415927) <= 0.0031415927 ? 1 : -1] array64;
  float[distance(atan(-1.0, 0.0), -1.5707964) <= 0.0015707964 ? 1 : -1] array65;
  float[distance(atan(-1.0, 1e-10), -1.5707964) <= 0.0015707964 ? 1 : -1] array66;
  float[distance(atan(-1.0, -1e-10), -1.5707964) <= 0.0015707964 ? 1 : -1] array67;
  float[distance(atan(-1.0, 0.1), -1.4711276) <= 0.0014711276 ? 1 : -1] array68;
  float[distance(atan(-1.0, -0.1), -1.670465) <= 0.001670465 ? 1 : -1] array69;
  float[distance(atan(-1.0, 1.0), -0.7853982) <= 0.0007853982 ? 1 : -1] array70;
  float[distance(atan(-1.0, -1.0), -2.3561945) <= 0.0023561944 ? 1 : -1] array71;
  float[distance(atan(-1.0, 10.0), -0.09966865) <= 1e-04 ? 1 : -1] array72;
  float[distance(atan(-1.0, -10.0), -3.041924) <= 0.003041924 ? 1 : -1] array73;
  float[distance(atan(-1.0, 10000000000.0), -1e-10) <= 1e-04 ? 1 : -1] array74;
  float[distance(atan(-1.0, -10000000000.0), -3.1415927) <= 0.0031415927 ? 1 : -1] array75;
  float[distance(atan(10.0, 0.0), 1.5707964) <= 0.0015707964 ? 1 : -1] array76;
  float[distance(atan(10.0, 1e-10), 1.5707964) <= 0.0015707964 ? 1 : -1] array77;
  float[distance(atan(10.0, -1e-10), 1.5707964) <= 0.0015707964 ? 1 : -1] array78;
  float[distance(atan(10.0, 0.1), 1.5607966) <= 0.0015607966 ? 1 : -1] array79;
  float[distance(atan(10.0, -0.1), 1.580796) <= 0.001580796 ? 1 : -1] array80;
  float[distance(atan(10.0, 1.0), 1.4711276) <= 0.0014711276 ? 1 : -1] array81;
  float[distance(atan(10.0, -1.0), 1.670465) <= 0.001670465 ? 1 : -1] array82;
  float[distance(atan(10.0, 10.0), 0.7853982) <= 0.0007853982 ? 1 : -1] array83;
  float[distance(atan(10.0, -10.0), 2.3561945) <= 0.0023561944 ? 1 : -1] array84;
  float[distance(atan(10.0, 10000000000.0), 1e-09) <= 1e-04 ? 1 : -1] array85;
  float[distance(atan(10.0, -10000000000.0), 3.1415927) <= 0.0031415927 ? 1 : -1] array86;
  float[distance(atan(-10.0, 0.0), -1.5707964) <= 0.0015707964 ? 1 : -1] array87;
  float[distance(atan(-10.0, 1e-10), -1.5707964) <= 0.0015707964 ? 1 : -1] array88;
  float[distance(atan(-10.0, -1e-10), -1.5707964) <= 0.0015707964 ? 1 : -1] array89;
  float[distance(atan(-10.0, 0.1), -1.5607966) <= 0.0015607966 ? 1 : -1] array90;
  float[distance(atan(-10.0, -0.1), -1.580796) <= 0.001580796 ? 1 : -1] array91;
  float[distance(atan(-10.0, 1.0), -1.4711276) <= 0.0014711276 ? 1 : -1] array92;
  float[distance(atan(-10.0, -1.0), -1.670465) <= 0.001670465 ? 1 : -1] array93;
  float[distance(atan(-10.0, 10.0), -0.7853982) <= 0.0007853982 ? 1 : -1] array94;
  float[distance(atan(-10.0, -10.0), -2.3561945) <= 0.0023561944 ? 1 : -1] array95;
  float[distance(atan(-10.0, 10000000000.0), -1e-09) <= 1e-04 ? 1 : -1] array96;
  float[distance(atan(-10.0, -10000000000.0), -3.1415927) <= 0.0031415927 ? 1 : -1] array97;
  float[distance(atan(10000000000.0, 0.0), 1.5707964) <= 0.0015707964 ? 1 : -1] array98;
  float[distance(atan(10000000000.0, 1e-10), 1.5707964) <= 0.0015707964 ? 1 : -1] array99;
  float[distance(atan(10000000000.0, -1e-10), 1.5707964) <= 0.0015707964 ? 1 : -1] array100;
  float[distance(atan(10000000000.0, 0.1), 1.5707964) <= 0.0015707964 ? 1 : -1] array101;
  float[distance(atan(10000000000.0, -0.1), 1.5707964) <= 0.0015707964 ? 1 : -1] array102;
  float[distance(atan(10000000000.0, 1.0), 1.5707964) <= 0.0015707964 ? 1 : -1] array103;
  float[distance(atan(10000000000.0, -1.0), 1.5707964) <= 0.0015707964 ? 1 : -1] array104;
  float[distance(atan(10000000000.0, 10.0), 1.5707964) <= 0.0015707964 ? 1 : -1] array105;
  float[distance(atan(10000000000.0, -10.0), 1.5707964) <= 0.0015707964 ? 1 : -1] array106;
  float[distance(atan(10000000000.0, 10000000000.0), 0.7853982) <= 0.0007853982 ? 1 : -1] array107;
  float[distance(atan(10000000000.0, -10000000000.0), 2.3561945) <= 0.0023561944 ? 1 : -1] array108;
  float[distance(atan(-10000000000.0, 0.0), -1.5707964) <= 0.0015707964 ? 1 : -1] array109;
  float[distance(atan(-10000000000.0, 1e-10), -1.5707964) <= 0.0015707964 ? 1 : -1] array110;
  float[distance(atan(-10000000000.0, -1e-10), -1.5707964) <= 0.0015707964 ? 1 : -1] array111;
  float[distance(atan(-10000000000.0, 0.1), -1.5707964) <= 0.0015707964 ? 1 : -1] array112;
  float[distance(atan(-10000000000.0, -0.1), -1.5707964) <= 0.0015707964 ? 1 : -1] array113;
  float[distance(atan(-10000000000.0, 1.0), -1.5707964) <= 0.0015707964 ? 1 : -1] array114;
  float[distance(atan(-10000000000.0, -1.0), -1.5707964) <= 0.0015707964 ? 1 : -1] array115;
  float[distance(atan(-10000000000.0, 10.0), -1.5707964) <= 0.0015707964 ? 1 : -1] array116;
  float[distance(atan(-10000000000.0, -10.0), -1.5707964) <= 0.0015707964 ? 1 : -1] array117;
  float[distance(atan(-10000000000.0, 10000000000.0), -0.7853982) <= 0.0007853982 ? 1 : -1] array118;
  float[distance(atan(-10000000000.0, -10000000000.0), -2.3561945) <= 0.0023561944 ? 1 : -1] array119;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length() + array20.length() + array21.length() + array22.length() + array23.length() + array24.length() + array25.length() + array26.length() + array27.length() + array28.length() + array29.length() + array30.length() + array31.length() + array32.length() + array33.length() + array34.length() + array35.length() + array36.length() + array37.length() + array38.length() + array39.length() + array40.length() + array41.length() + array42.length() + array43.length() + array44.length() + array45.length() + array46.length() + array47.length() + array48.length() + array49.length() + array50.length() + array51.length() + array52.length() + array53.length() + array54.length() + array55.length() + array56.length() + array57.length() + array58.length() + array59.length() + array60.length() + array61.length() + array62.length() + array63.length() + array64.length() + array65.length() + array66.length() + array67.length() + array68.length() + array69.length() + array70.length() + array71.length() + array72.length() + array73.length() + array74.length() + array75.length() + array76.length() + array77.length() + array78.length() + array79.length() + array80.length() + array81.length() + array82.length() + array83.length() + array84.length() + array85.length() + array86.length() + array87.length() + array88.length() + array89.length() + array90.length() + array91.length() + array92.length() + array93.length() + array94.length() + array95.length() + array96.length() + array97.length() + array98.length() + array99.length() + array100.length() + array101.length() + array102.length() + array103.length() + array104.length() + array105.length() + array106.length() + array107.length() + array108.length() + array109.length() + array110.length() + array111.length() + array112.length() + array113.length() + array114.length() + array115.length() + array116.length() + array117.length() + array118.length() + array119.length());
}
