/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.auth;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jdesktop.swingx.auth.LoginService;

public class JAASLoginService
extends LoginService {
    private static final Logger LOG = Logger.getLogger(JAASLoginService.class.getName());

    public JAASLoginService(String server) {
        super(server);
    }

    public JAASLoginService() {
    }

    public boolean authenticate(String name, char[] password, String server) throws Exception {
        try {
            LoginContext loginContext = null;
            loginContext = new LoginContext(this.getServer(), new JAASCallbackHandler(name, password));
            loginContext.login();
            return true;
        }
        catch (AccountExpiredException e) {
            LOG.log(Level.WARNING, "", e);
            return false;
        }
        catch (CredentialExpiredException e) {
            LOG.log(Level.WARNING, "", e);
            return false;
        }
        catch (FailedLoginException e) {
            LOG.log(Level.WARNING, "", e);
            return false;
        }
        catch (LoginException e) {
            LOG.log(Level.WARNING, "", e);
            return false;
        }
        catch (Throwable e) {
            LOG.log(Level.WARNING, "", e);
            return false;
        }
    }

    class JAASCallbackHandler
    implements CallbackHandler {
        private String name;
        private char[] password;

        public JAASCallbackHandler(String name, char[] passwd) {
            this.name = name;
            this.password = passwd;
        }

        public void handle(Callback[] callbacks) throws IOException {
            for (int i = 0; i < callbacks.length; ++i) {
                Callback cb;
                if (callbacks[i] instanceof NameCallback) {
                    cb = (NameCallback)callbacks[i];
                    ((NameCallback)cb).setName(this.name);
                    continue;
                }
                if (!(callbacks[i] instanceof PasswordCallback)) continue;
                cb = (PasswordCallback)callbacks[i];
                ((PasswordCallback)cb).setPassword(this.password);
            }
        }
    }
}

