/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.schedule;

import com.sun.jna.Library;
import com.sun.jna.Native;
import jakarta.inject.Inject;
import jakarta.ws.rs.client.Client;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.database.StatisticsManager;
import org.traccar.schedule.ScheduleTask;

public class TaskHealthCheck
implements ScheduleTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskHealthCheck.class);
    private final Config config;
    private final Client client;
    private final StatisticsManager statisticsManager;
    private final long gracePeriod = System.currentTimeMillis() + TimeUnit.HOURS.toMillis(1L);
    private SystemD systemD;
    private boolean enabled;
    private long period;
    private double dropThreshold;
    private int messageLastTotal;
    private int messageLastPeriod;

    @Inject
    public TaskHealthCheck(Config config, Client client, StatisticsManager statisticsManager) {
        this.config = config;
        this.client = client;
        this.statisticsManager = statisticsManager;
        if (!config.getBoolean(Keys.WEB_DISABLE_HEALTH_CHECK) && System.getProperty("os.name").toLowerCase().startsWith("linux")) {
            try {
                this.systemD = (SystemD)Native.load((String)"systemd", SystemD.class);
                String watchdogTimer = System.getenv("WATCHDOG_USEC");
                if (watchdogTimer != null && !watchdogTimer.isEmpty()) {
                    this.period = Long.parseLong(watchdogTimer) / 1000L * 4L / 5L;
                }
                if (this.period > 0L) {
                    LOGGER.info("Health check enabled with period {}", (Object)this.period);
                    this.dropThreshold = config.getDouble(Keys.WEB_HEALTH_CHECK_DROP_THRESHOLD);
                    this.enabled = true;
                }
            }
            catch (UnsatisfiedLinkError e) {
                LOGGER.warn("No systemd support", (Throwable)e);
            }
        }
    }

    private String getUrl() {
        String address = this.config.getString(Keys.WEB_ADDRESS, "localhost");
        int port = this.config.getInteger(Keys.WEB_PORT);
        return "http://" + address + ":" + port + "/api/server";
    }

    @Override
    public void schedule(ScheduledExecutorService executor) {
        if (this.enabled) {
            executor.scheduleAtFixedRate(this, this.period, this.period, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void run() {
        LOGGER.debug("Health check running");
        if (System.currentTimeMillis() > this.gracePeriod) {
            double drop;
            boolean success = true;
            int status = this.client.target(this.getUrl()).request().get().getStatus();
            if (status != 200) {
                success = false;
                LOGGER.warn("Web health check failed with status {}", (Object)status);
            }
            int messageCurrentTotal = this.statisticsManager.messageStoredCount();
            int messageCurrentPeriod = messageCurrentTotal - this.messageLastTotal;
            if (this.dropThreshold > 0.0 && this.messageLastPeriod > 0 && (drop = (double)messageCurrentPeriod / (double)this.messageLastPeriod) < this.dropThreshold) {
                success = false;
                LOGGER.warn("Message health check failed with drop {}", (Object)drop);
            }
            this.messageLastTotal = messageCurrentTotal;
            this.messageLastPeriod = messageCurrentPeriod;
            if (success) {
                this.notifyWatchdog();
            }
        } else {
            this.notifyWatchdog();
        }
    }

    private void notifyWatchdog() {
        int result = this.systemD.sd_notify(0, "WATCHDOG=1");
        if (result < 0) {
            LOGGER.warn("Health check notify error {}", (Object)result);
        }
    }

    static interface SystemD
    extends Library {
        public int sd_notify(int var1, String var2);
    }
}

