/*
 * Decompiled with CFR 0.152.
 */
package javax.enterprise.inject.spi;

import java.util.Collections;
import java.util.Comparator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDIProvider;

public abstract class CDI<T>
implements Instance<T> {
    private static final Object lock = new Object();
    protected static volatile Set<CDIProvider> discoveredProviders = null;
    protected static volatile CDIProvider configuredProvider = null;

    public static CDI<Object> current() {
        return CDI.getCDIProvider().getCDI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CDIProvider getCDIProvider() {
        if (configuredProvider != null) {
            return configuredProvider;
        }
        if (discoveredProviders == null) {
            Object object = lock;
            synchronized (object) {
                if (discoveredProviders == null) {
                    CDI.findAllProviders();
                }
            }
        }
        configuredProvider = discoveredProviders.stream().filter(c -> c.getCDI() != null).findFirst().orElseThrow(() -> new IllegalStateException("Unable to access CDI"));
        return configuredProvider;
    }

    public static void setCDIProvider(CDIProvider provider) {
        if (provider == null) {
            throw new IllegalStateException("CDIProvider must not be null");
        }
        configuredProvider = provider;
    }

    private static void findAllProviders() {
        TreeSet<CDIProvider> providers = new TreeSet<CDIProvider>(Comparator.comparingInt(CDIProvider::getPriority).reversed());
        ServiceLoader<CDIProvider> providerLoader = ServiceLoader.load(CDIProvider.class, CDI.class.getClassLoader());
        if (!providerLoader.iterator().hasNext()) {
            throw new IllegalStateException("Unable to locate CDIProvider");
        }
        try {
            providerLoader.forEach(providers::add);
        }
        catch (ServiceConfigurationError e) {
            throw new IllegalStateException(e);
        }
        discoveredProviders = Collections.unmodifiableSet(providers);
    }

    public abstract BeanManager getBeanManager();
}

