/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.css3.CssBorderBottomColor;
import org.w3c.css.properties.css3.CssBorderLeftColor;
import org.w3c.css.properties.css3.CssBorderRightColor;
import org.w3c.css.properties.css3.CssBorderTopColor;
import org.w3c.css.properties.css3.CssColor;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssBorderColor
extends org.w3c.css.properties.css.CssBorderColor {
    public CssBorderColor() {
        this.value = initial;
        this.top = new CssBorderTopColor();
        this.right = new CssBorderRightColor();
        this.bottom = new CssBorderBottomColor();
        this.left = new CssBorderLeftColor();
    }

    public CssBorderColor(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public CssBorderColor(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 4) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        boolean isCssWide = false;
        ArrayList<CssValue> res = new ArrayList<CssValue>();
        while (res.size() < 4 && !expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            if (val.getType() == 0 && CssIdent.isCssWide(val.getIdent())) {
                res.add(val);
                isCssWide = true;
                this.value = val;
            } else {
                try {
                    CssExpression ex = new CssExpression();
                    ex.addValue(val);
                    CssColor tcolor = new CssColor(ac, ex, check2);
                    res.add(tcolor.getValue());
                }
                catch (InvalidParamException e) {
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
            }
            expression.next();
            if (op == ' ') continue;
            throw new InvalidParamException("operator", Character.toString(op), ac);
        }
        if (res.size() > 1 && isCssWide) {
            throw new InvalidParamException("value", this.value.toString(), this.getPropertyName(), ac);
        }
        this.value = res.size() == 1 ? (CssValue)res.get(0) : new CssValueList(res);
        this.top = new CssBorderTopColor();
        this.right = new CssBorderRightColor();
        this.bottom = new CssBorderBottomColor();
        this.left = new CssBorderLeftColor();
        switch (res.size()) {
            case 1: {
                this.right.value = this.bottom.value = res.get(0);
                this.left.value = this.bottom.value;
                this.top.value = this.bottom.value;
                break;
            }
            case 2: {
                this.top.value = this.bottom.value = res.get(0);
                this.right.value = this.left.value = res.get(1);
                break;
            }
            case 3: {
                this.top.value = res.get(0);
                this.right.value = this.left.value = res.get(1);
                this.bottom.value = res.get(2);
                break;
            }
            case 4: {
                this.top.value = res.get(0);
                this.right.value = res.get(1);
                this.bottom.value = res.get(2);
                this.left.value = res.get(3);
                break;
            }
            default: {
                throw new InvalidParamException("unrecognize", ac);
            }
        }
        this.shorthand = true;
    }

    protected static CssValue parseBorderSideColor(ApplContext ac, CssExpression expression, boolean check2, CssProperty caller) throws InvalidParamException {
        if (check2 && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue retval = null;
        CssValue val = expression.getValue();
        if (val.getType() == 0 && CssIdent.isCssWide(val.getIdent())) {
            retval = val;
        } else {
            try {
                CssColor tcolor = new CssColor(ac, expression, check2);
                retval = tcolor.getValue();
            }
            catch (InvalidParamException e) {
                throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
            }
        }
        expression.next();
        return retval;
    }
}

