"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyDetectionOpenSearchDashboardsPlugin = void 0;
var _constants = require("../utils/constants");
var _operators = require("rxjs/operators");
var _router = _interopRequireDefault(require("./router"));
var _adPlugin = _interopRequireDefault(require("./cluster/ad/adPlugin"));
var _alertingPlugin = _interopRequireDefault(require("./cluster/ad/alertingPlugin"));
var _ad = _interopRequireWildcard(require("./routes/ad"));
var _alerting = _interopRequireWildcard(require("./routes/alerting"));
var _opensearch = _interopRequireWildcard(require("./routes/opensearch"));
var _sampleData = _interopRequireWildcard(require("./routes/sampleData"));
var _constants2 = require("./utils/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
class AnomalyDetectionOpenSearchDashboardsPlugin {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;
    _defineProperty(this, "logger", void 0);
    _defineProperty(this, "globalConfig$", void 0);
    this.logger = initializerContext.logger.get();
    this.globalConfig$ = initializerContext.config.legacy.globalConfig$;
  }
  async setup(core, {
    dataSource
  }) {
    // Get any custom/overridden headers
    const globalConfig = await this.globalConfig$.pipe((0, _operators.first)()).toPromise();
    const {
      customHeaders,
      ...rest
    } = globalConfig.opensearch;

    // Create OpenSearch client w/ relevant plugins and headers
    const client = core.opensearch.legacy.createClient('anomaly_detection', {
      plugins: [_adPlugin.default, _alertingPlugin.default],
      customHeaders: {
        ...customHeaders,
        ..._constants2.DEFAULT_HEADERS
      },
      ...rest
    });
    const dataSourceEnabled = !!dataSource;
    if (dataSourceEnabled) {
      dataSource.registerCustomApiSchema(_adPlugin.default);
      dataSource.registerCustomApiSchema(_alertingPlugin.default);
    }

    // Create router
    const apiRouter = (0, _router.default)(core.http.createRouter(), _constants.BASE_NODE_API_PATH);

    // Create services & register with OpenSearch client
    const adService = new _ad.default(client, dataSourceEnabled);
    const alertingService = new _alerting.default(client, dataSourceEnabled);
    const opensearchService = new _opensearch.default(client, dataSourceEnabled);
    const sampleDataService = new _sampleData.default(client, dataSourceEnabled);

    // Register server routes with the service
    (0, _ad.registerADRoutes)(apiRouter, adService);
    (0, _alerting.registerAlertingRoutes)(apiRouter, alertingService);
    (0, _opensearch.registerOpenSearchRoutes)(apiRouter, opensearchService);
    (0, _sampleData.registerSampleDataRoutes)(apiRouter, sampleDataService);
    return {};
  }
  async start(core) {
    return {};
  }
}
exports.AnomalyDetectionOpenSearchDashboardsPlugin = AnomalyDetectionOpenSearchDashboardsPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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