"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const VALID_METHODS = ["HEAD", "GET", "POST", "PUT", "DELETE"];
class CommonService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "apiCaller", async (context, request, response) => {
      const useQuery = !request.body;
      const usedParam = useQuery ? request.query : request.body;
      const {
        endpoint,
        data,
        hideLog
      } = usedParam || {};
      try {
        const finalData = data;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);

        /**
         * The endpoint must not be an empty string, reference from proxy caller
         */
        if (!endpoint) {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: `Expected non-empty string on endpoint`
            }
          });
        }

        /**
         * Update path parameter to follow RFC/generic HTTP convention
         */
        if (endpoint === "transport.request" && typeof (finalData === null || finalData === void 0 ? void 0 : finalData.path) === "string" && !/^\//.test((finalData === null || finalData === void 0 ? void 0 : finalData.path) || "")) {
          finalData.path = `/${finalData.path || ""}`;
        }

        /**
         * Check valid method here
         */
        if (endpoint === "transport.request" && data !== null && data !== void 0 && data.method) {
          var _data$method$toUpperC, _data$method;
          if (VALID_METHODS.indexOf((_data$method$toUpperC = (_data$method = data.method).toUpperCase) === null || _data$method$toUpperC === void 0 ? void 0 : _data$method$toUpperC.call(_data$method)) === -1) {
            return response.custom({
              statusCode: 200,
              body: {
                ok: false,
                error: `Method must be one of, case insensitive ['HEAD', 'GET', 'POST', 'PUT', 'DELETE']. Received '${data.method}'.`
              }
            });
          }
        }
        const payload = useQuery ? JSON.parse(finalData || "{}") : finalData;
        const commonCallerResponse = await callWithRequest(endpoint, payload || {});
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: commonCallerResponse
          }
        });
      } catch (err) {
        if (!hideLog) {
          console.error("Index Management - CommonService - apiCaller", err);
        }
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err === null || err === void 0 ? void 0 : err.message,
            body: (err === null || err === void 0 ? void 0 : err.body) || ""
          }
        });
      }
    });
  }
}
exports.default = CommonService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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