
#ifndef FUTURESQL_EXPORT_H
#define FUTURESQL_EXPORT_H

#ifdef FUTURESQL_STATIC_DEFINE
#  define FUTURESQL_EXPORT
#  define FUTURESQL_NO_EXPORT
#else
#  ifndef FUTURESQL_EXPORT
#    ifdef futuresql6_EXPORTS
        /* We are building this library */
#      define FUTURESQL_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define FUTURESQL_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef FUTURESQL_NO_EXPORT
#    define FUTURESQL_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef FUTURESQL_DECL_DEPRECATED
#  define FUTURESQL_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef FUTURESQL_DECL_DEPRECATED_EXPORT
#  define FUTURESQL_DECL_DEPRECATED_EXPORT FUTURESQL_EXPORT FUTURESQL_DECL_DEPRECATED
#endif

#ifndef FUTURESQL_DECL_DEPRECATED_NO_EXPORT
#  define FUTURESQL_DECL_DEPRECATED_NO_EXPORT FUTURESQL_NO_EXPORT FUTURESQL_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef FUTURESQL_NO_DEPRECATED
#    define FUTURESQL_NO_DEPRECATED
#  endif
#endif

#define FUTURESQL_DECL_DEPRECATED_TEXT(text) FUTURESQL_DECL_DEPRECATED

#if defined(FUTURESQL_NO_DEPRECATED)
#  undef FUTURESQL_DEPRECATED
#  define FUTURESQL_DEPRECATED_EXPORT FUTURESQL_EXPORT
#  define FUTURESQL_DEPRECATED_NO_EXPORT FUTURESQL_NO_EXPORT
#elif defined(FUTURESQL_NO_DEPRECATED_WARNINGS)
#  define FUTURESQL_DEPRECATED
#  define FUTURESQL_DEPRECATED_EXPORT FUTURESQL_EXPORT
#  define FUTURESQL_DEPRECATED_NO_EXPORT FUTURESQL_NO_EXPORT
#else
#  define FUTURESQL_DEPRECATED FUTURESQL_DECL_DEPRECATED
#  define FUTURESQL_DEPRECATED_EXPORT FUTURESQL_DECL_DEPRECATED_EXPORT
#  define FUTURESQL_DEPRECATED_NO_EXPORT FUTURESQL_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define FUTURESQL_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define FUTURESQL_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef FUTURESQL_NO_DEPRECATED
#  define FUTURESQL_DISABLE_DEPRECATED_BEFORE_AND_AT 0x100
#endif
#ifdef FUTURESQL_NO_DEPRECATED_WARNINGS
#  define FUTURESQL_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef FUTURESQL_DEPRECATED_WARNINGS_SINCE
#  ifdef FUTURESQL_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define FUTURESQL_DEPRECATED_WARNINGS_SINCE FUTURESQL_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define FUTURESQL_DEPRECATED_WARNINGS_SINCE 0x100
#  endif
#endif

#ifndef FUTURESQL_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define FUTURESQL_DISABLE_DEPRECATED_BEFORE_AND_AT 0x0
#endif

#ifdef FUTURESQL_DEPRECATED
#  define FUTURESQL_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > FUTURESQL_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define FUTURESQL_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* FUTURESQL_EXPORT_H */
