"use strict";

require("@testing-library/jest-dom/extend-expect");
var _react = require("@testing-library/react");
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

(0, _react.configure)({
  testIdAttribute: 'data-test-subj'
});
jest.mock('@elastic/eui/lib/components/form/form_row/make_id', () => () => 'random_id');
jest.mock('@elastic/eui/lib/services/accessibility/html_id_generator', () => ({
  htmlIdGenerator: () => {
    return () => 'random_html_id';
  }
}));

//for mocking window.scroll(0,0)
const noop = () => {};
Object.defineProperty(window, 'scroll', {
  value: noop,
  writable: true
});

// for Plotly
//@ts-ignore
window.URL.createObjectURL = function () {};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJyZXF1aXJlIiwiX3JlYWN0IiwiY29uZmlndXJlIiwidGVzdElkQXR0cmlidXRlIiwiamVzdCIsIm1vY2siLCJodG1sSWRHZW5lcmF0b3IiLCJub29wIiwiT2JqZWN0IiwiZGVmaW5lUHJvcGVydHkiLCJ3aW5kb3ciLCJ2YWx1ZSIsIndyaXRhYmxlIiwiVVJMIiwiY3JlYXRlT2JqZWN0VVJMIl0sInNvdXJjZXMiOlsic2V0dXAuamVzdC50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqXG4gKiBUaGUgT3BlblNlYXJjaCBDb250cmlidXRvcnMgcmVxdWlyZSBjb250cmlidXRpb25zIG1hZGUgdG9cbiAqIHRoaXMgZmlsZSBiZSBsaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlLTIuMCBsaWNlbnNlIG9yIGFcbiAqIGNvbXBhdGlibGUgb3BlbiBzb3VyY2UgbGljZW5zZS5cbiAqXG4gKiBNb2RpZmljYXRpb25zIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9ycy4gU2VlXG4gKiBHaXRIdWIgaGlzdG9yeSBmb3IgZGV0YWlscy5cbiAqL1xuXG5pbXBvcnQgJ0B0ZXN0aW5nLWxpYnJhcnkvamVzdC1kb20vZXh0ZW5kLWV4cGVjdCc7XG5pbXBvcnQgeyBjb25maWd1cmUgfSBmcm9tICdAdGVzdGluZy1saWJyYXJ5L3JlYWN0JztcblxuY29uZmlndXJlKHsgdGVzdElkQXR0cmlidXRlOiAnZGF0YS10ZXN0LXN1YmonIH0pO1xuXG5qZXN0Lm1vY2soXG4gICdAZWxhc3RpYy9ldWkvbGliL2NvbXBvbmVudHMvZm9ybS9mb3JtX3Jvdy9tYWtlX2lkJyxcbiAgKCkgPT4gKCkgPT4gJ3JhbmRvbV9pZCdcbik7XG5cbmplc3QubW9jaygnQGVsYXN0aWMvZXVpL2xpYi9zZXJ2aWNlcy9hY2Nlc3NpYmlsaXR5L2h0bWxfaWRfZ2VuZXJhdG9yJywgKCkgPT4gKHtcbiAgaHRtbElkR2VuZXJhdG9yOiAoKSA9PiB7XG4gICAgcmV0dXJuICgpID0+ICdyYW5kb21faHRtbF9pZCc7XG4gIH0sXG59KSk7XG5cbi8vZm9yIG1vY2tpbmcgd2luZG93LnNjcm9sbCgwLDApXG5jb25zdCBub29wID0gKCkgPT4ge307XG5PYmplY3QuZGVmaW5lUHJvcGVydHkod2luZG93LCAnc2Nyb2xsJywgeyB2YWx1ZTogbm9vcCwgd3JpdGFibGU6IHRydWUgfSk7XG5cbi8vIGZvciBQbG90bHlcbi8vQHRzLWlnbm9yZVxud2luZG93LlVSTC5jcmVhdGVPYmplY3RVUkwgPSBmdW5jdGlvbiAoKSB7fTtcbiJdLCJtYXBwaW5ncyI6Ijs7QUFXQUEsT0FBQTtBQUNBLElBQUFDLE1BQUEsR0FBQUQsT0FBQTtBQVpBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOztBQUtBLElBQUFFLGdCQUFTLEVBQUM7RUFBRUMsZUFBZSxFQUFFO0FBQWlCLENBQUMsQ0FBQztBQUVoREMsSUFBSSxDQUFDQyxJQUFJLENBQ1AsbURBQW1ELEVBQ25ELE1BQU0sTUFBTSxXQUNkLENBQUM7QUFFREQsSUFBSSxDQUFDQyxJQUFJLENBQUMsMkRBQTJELEVBQUUsT0FBTztFQUM1RUMsZUFBZSxFQUFFQSxDQUFBLEtBQU07SUFDckIsT0FBTyxNQUFNLGdCQUFnQjtFQUMvQjtBQUNGLENBQUMsQ0FBQyxDQUFDOztBQUVIO0FBQ0EsTUFBTUMsSUFBSSxHQUFHQSxDQUFBLEtBQU0sQ0FBQyxDQUFDO0FBQ3JCQyxNQUFNLENBQUNDLGNBQWMsQ0FBQ0MsTUFBTSxFQUFFLFFBQVEsRUFBRTtFQUFFQyxLQUFLLEVBQUVKLElBQUk7RUFBRUssUUFBUSxFQUFFO0FBQUssQ0FBQyxDQUFDOztBQUV4RTtBQUNBO0FBQ0FGLE1BQU0sQ0FBQ0csR0FBRyxDQUFDQyxlQUFlLEdBQUcsWUFBWSxDQUFDLENBQUMifQ==