"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PPLParsers = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const extractPPLQueries = content => {
  return Array.from(content.matchAll(/(^|[\n\r]|:)\s*(source\s*=\s*.+)/gi)).map(match => match[2]);
};
const PPLParsers = exports.PPLParsers = {
  id: 'ppl_visualization_message',
  async parserProvider(interaction) {
    var _interaction$addition;
    const ppls = ((_interaction$addition = interaction.additional_info) === null || _interaction$addition === void 0 || (_interaction$addition = _interaction$addition['PPLTool.output']) === null || _interaction$addition === void 0 ? void 0 : _interaction$addition.flatMap(item => {
      let ppl = '';
      try {
        const outputResp = JSON.parse(item);
        ppl = outputResp.ppl;
      } catch (e) {
        ppl = item;
      }
      return extractPPLQueries(ppl);
    })) || [];
    if (!ppls.length) return [];
    return ppls.map(query => {
      const finalQuery = query.replace(/`/g, '') // workaround for https://github.com/opensearch-project/dashboards-observability/issues/509, https://github.com/opensearch-project/dashboards-observability/issues/557
      .replace(/\bSPAN\(/g, 'span('); // workaround for https://github.com/opensearch-project/dashboards-observability/issues/759
      return {
        type: 'output',
        content: finalQuery,
        contentType: 'ppl_data_grid',
        fullWidth: true
      };
    });
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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