/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.swt;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.swt.PSWTCanvas;
import edu.umd.cs.piccolox.swt.SWTGraphics2D;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class PSWTImage
extends PNode {
    private transient PSWTCanvas canvas;
    private transient Image image;

    public PSWTImage(PSWTCanvas pSWTCanvas) {
        this.canvas = pSWTCanvas;
        pSWTCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (PSWTImage.this.image != null) {
                    PSWTImage.this.image.dispose();
                }
            }
        });
    }

    public PSWTImage(PSWTCanvas pSWTCanvas, Image image) {
        this(pSWTCanvas);
        this.setImage(image);
    }

    public PSWTImage(PSWTCanvas pSWTCanvas, String string) {
        this(pSWTCanvas);
        this.setImage(string);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(String string) {
        this.setImage(new Image((Device)this.canvas.getDisplay(), string));
    }

    public void setImage(Image image) {
        Image image2 = this.image;
        this.image = image;
        if (this.image != null) {
            Rectangle rectangle = this.getImage().getBounds();
            this.setBounds(0.0, 0.0, rectangle.width, rectangle.height);
            this.invalidatePaint();
        } else {
            this.image = null;
        }
        this.firePropertyChange(32768, "image", image2, this.image);
    }

    protected void paint(PPaintContext pPaintContext) {
        if (this.getImage() != null) {
            Rectangle rectangle = this.image.getBounds();
            double d = rectangle.width;
            double d2 = rectangle.height;
            PBounds pBounds = this.getBoundsReference();
            SWTGraphics2D sWTGraphics2D = (SWTGraphics2D)pPaintContext.getGraphics();
            if (pBounds.x != 0.0 || pBounds.y != 0.0 || pBounds.width != d || pBounds.height != d2) {
                sWTGraphics2D.translate(pBounds.x, pBounds.y);
                sWTGraphics2D.scale(pBounds.width / d, pBounds.height / d2);
                sWTGraphics2D.drawImage(this.image, 0.0, 0.0);
                sWTGraphics2D.scale(d / pBounds.width, d2 / pBounds.height);
                sWTGraphics2D.translate(-pBounds.x, -pBounds.y);
            } else {
                sWTGraphics2D.drawImage(this.image, 0.0, 0.0);
            }
        }
    }

    protected String paramString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("image=" + (this.image == null ? "null" : this.image.toString()));
        stringBuffer.append(',');
        stringBuffer.append(super.paramString());
        return stringBuffer.toString();
    }
}

