/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.RandomUtils;

public enum Direction implements Named
{
    N(0, -2, 0, -2),
    NE(1, -1, 0, -1),
    E(1, 0, 1, 0),
    SE(1, 1, 0, 1),
    S(0, 2, 0, 2),
    SW(0, 1, -1, 1),
    W(-1, 0, -1, 0),
    NW(0, -1, -1, -1);

    public static final int NUMBER_OF_DIRECTIONS;
    public static final List<Direction> allDirections;
    public static final List<Direction> longSides;
    public static final List<Direction> corners;
    private final int oddDX;
    private final int oddDY;
    private final int evenDX;
    private final int evenDY;

    private Direction(int oddDX, int oddDY, int evenDX, int evenDY) {
        this.oddDX = oddDX;
        this.oddDY = oddDY;
        this.evenDX = evenDX;
        this.evenDY = evenDY;
    }

    public Map.Position step(int x, int y) {
        return (y & 1) != 0 ? new Map.Position(x + this.oddDX, y + this.oddDY) : new Map.Position(x + this.evenDX, y + this.evenDY);
    }

    public Direction rotate(int n) {
        return Direction.values()[(this.ordinal() + n + NUMBER_OF_DIRECTIONS) % NUMBER_OF_DIRECTIONS];
    }

    public Direction getNextDirection() {
        return this.rotate(1);
    }

    public Direction getPreviousDirection() {
        return this.rotate(-1);
    }

    public Direction getReverseDirection() {
        return this.rotate(NUMBER_OF_DIRECTIONS / 2);
    }

    public Direction getEWMirroredDirection() {
        switch (this) {
            case NW: {
                return NE;
            }
            case W: {
                return E;
            }
            case SW: {
                return SE;
            }
            case NE: {
                return NW;
            }
            case E: {
                return W;
            }
            case SE: {
                return SW;
            }
        }
        return this;
    }

    public static Direction getRandomDirection(String logMe, Logger logger, Random random) {
        return Direction.values()[RandomUtils.randomInt(logger, logMe, random, NUMBER_OF_DIRECTIONS)];
    }

    public static Direction[] getRandomDirections(String logMe, Logger logger, Random random) {
        ArrayList<Direction> directions = new ArrayList<Direction>(allDirections);
        RandomUtils.randomShuffle(logger, logMe, directions, random);
        return directions.toArray(new Direction[0]);
    }

    public Direction[] getClosestDirections(String logMe, Logger logger, Random random) {
        int nbits = (NUMBER_OF_DIRECTIONS - 2) / 2;
        int r = RandomUtils.randomInt(logger, logMe, random, 1 << nbits);
        Direction[] ret = new Direction[NUMBER_OF_DIRECTIONS];
        ret[0] = this;
        int step = 1;
        int mask = 1;
        for (int i = 1; i < NUMBER_OF_DIRECTIONS - 1; i += 2) {
            Direction dr = this.rotate(step);
            Direction dl = this.rotate(NUMBER_OF_DIRECTIONS - step);
            ret[i] = (r & mask) == 0 ? dr : dl;
            ret[i + 1] = (r & mask) == 0 ? dl : dr;
            ++step;
            mask *= 2;
        }
        ret[Direction.NUMBER_OF_DIRECTIONS - 1] = this.getReverseDirection();
        return ret;
    }

    public static Direction angleToDirection(double angle) {
        return Direction.values()[(int)Math.floor(angle / 0.7853981633974483)];
    }

    public String getKey() {
        return "direction." + this;
    }

    @Override
    public String getNameKey() {
        return Messages.nameKey("model." + this.getKey());
    }

    static {
        NUMBER_OF_DIRECTIONS = Direction.values().length;
        allDirections = CollectionUtils.makeUnmodifiableList(N, NE, E, SE, S, SW, W, NW);
        longSides = CollectionUtils.makeUnmodifiableList(NE, SE, SW, NW);
        corners = CollectionUtils.makeUnmodifiableList(N, E, S, W);
    }
}

